/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;

@Internal
public class OptionalUtils {
    public static <T> Stream<T> stream(Optional<T> opt) {
        return opt.map(Stream::of).orElseGet(Stream::empty);
    }

    @SafeVarargs
    public static <T> Optional<T> firstPresent(Optional<T> ... opts) {
        for (Optional<T> opt : opts) {
            if (!opt.isPresent()) continue;
            return opt;
        }
        return Optional.empty();
    }

    private OptionalUtils() {
    }
}

