/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterDelegate;
import org.apache.flink.util.Preconditions;

public class SingleRecordWriter<T extends IOReadableWritable>
implements RecordWriterDelegate<T> {
    private final RecordWriter<T> recordWriter;

    public SingleRecordWriter(RecordWriter<T> recordWriter) {
        this.recordWriter = Preconditions.checkNotNull(recordWriter);
    }

    @Override
    public void broadcastEvent(AbstractEvent event) throws IOException {
        this.recordWriter.broadcastEvent(event);
    }

    @Override
    public RecordWriter<T> getRecordWriter(int outputIndex) {
        Preconditions.checkArgument(outputIndex == 0, "The index should always be 0 for the single record writer delegate.");
        return this.recordWriter;
    }

    @Override
    public void setMaxOverdraftBuffersPerGate(int maxOverdraftBuffersPerGate) {
        this.recordWriter.setMaxOverdraftBuffersPerGate(maxOverdraftBuffersPerGate);
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.recordWriter.getAvailableFuture();
    }

    @Override
    public boolean isAvailable() {
        return this.recordWriter.isAvailable();
    }

    @Override
    public void close() {
        this.recordWriter.close();
    }
}

