/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowTimeRangeBoundedPrecedingFunction<K>
extends KeyedProcessFunction<K, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RowTimeRangeBoundedPrecedingFunction.class);
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private transient JoinedRowData output;
    private transient ValueState<Long> lastTriggeringTsState;
    private transient ValueState<RowData> accState;
    private transient ValueState<Long> cleanupTsState;
    private transient MapState<Long, List<RowData>> inputState;
    private transient AggsHandleFunction function;
    private static final String LATE_ELEMENTS_DROPPED_METRIC_NAME = "numLateRecordsDropped";
    private transient Counter numLateRecordsDropped;

    @VisibleForTesting
    protected Counter getCounter() {
        return this.numLateRecordsDropped;
    }

    public RowTimeRangeBoundedPrecedingFunction(GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, long precedingOffset, int rowTimeIdx) {
        Preconditions.checkNotNull(precedingOffset);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        ValueStateDescriptor<Long> lastTriggeringTsDescriptor = new ValueStateDescriptor<Long>("lastTriggeringTsState", Types.LONG);
        this.lastTriggeringTsState = this.getRuntimeContext().getState(lastTriggeringTsDescriptor);
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor<RowData> accStateDesc = new ValueStateDescriptor<RowData>("accState", accTypeInfo);
        this.accState = this.getRuntimeContext().getState(accStateDesc);
        InternalTypeInfo<RowData> inputType = InternalTypeInfo.ofFields(this.inputFieldTypes);
        ListTypeInfo<RowData> rowListTypeInfo = new ListTypeInfo<RowData>(inputType);
        MapStateDescriptor<Long, RowData> inputStateDesc = new MapStateDescriptor<Long, RowData>("inputState", Types.LONG, (TypeInformation<RowData>)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(inputStateDesc);
        ValueStateDescriptor<Long> cleanupTsStateDescriptor = new ValueStateDescriptor<Long>("cleanupTsState", Types.LONG);
        this.cleanupTsState = this.getRuntimeContext().getState(cleanupTsStateDescriptor);
        this.numLateRecordsDropped = this.getRuntimeContext().getMetricGroup().counter(LATE_ELEMENTS_DROPPED_METRIC_NAME);
    }

    @Override
    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        long triggeringTs = input.getLong(this.rowTimeIdx);
        Long lastTriggeringTs = this.lastTriggeringTsState.value();
        if (lastTriggeringTs == null) {
            lastTriggeringTs = 0L;
        }
        if (triggeringTs > lastTriggeringTs) {
            List<RowData> data = this.inputState.get(triggeringTs);
            if (null != data) {
                data.add(input);
                this.inputState.put(triggeringTs, data);
            } else {
                data = new ArrayList<RowData>();
                data.add(input);
                this.inputState.put(triggeringTs, data);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
            this.registerCleanupTimer(ctx, triggeringTs);
        } else {
            this.numLateRecordsDropped.inc();
        }
    }

    private void registerCleanupTimer(KeyedProcessFunction.Context ctx, long timestamp) throws Exception {
        long minCleanupTimestamp = timestamp + this.precedingOffset + 1L;
        long maxCleanupTimestamp = timestamp + (long)((double)this.precedingOffset * 1.5) + 1L;
        Long curCleanupTimestamp = this.cleanupTsState.value();
        if (curCleanupTimestamp == null || curCleanupTimestamp < minCleanupTimestamp) {
            ctx.timerService().registerEventTimeTimer(maxCleanupTimestamp);
            this.cleanupTsState.update(maxCleanupTimestamp);
        }
    }

    @Override
    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        Long cleanupTimestamp = this.cleanupTsState.value();
        if (cleanupTimestamp != null && cleanupTimestamp <= timestamp) {
            this.inputState.clear();
            this.accState.clear();
            this.lastTriggeringTsState.clear();
            this.cleanupTsState.clear();
            this.function.cleanup();
            return;
        }
        List<RowData> inputs = this.inputState.get(timestamp);
        if (null != inputs) {
            int dataListIndex = 0;
            RowData accumulators = this.accState.value();
            if (null == accumulators) {
                accumulators = this.function.createAccumulators();
            }
            this.function.setAccumulators(accumulators);
            ArrayList<Long> retractTsList = new ArrayList<Long>();
            for (Long dataTs : this.inputState.keys()) {
                Long offset = timestamp - dataTs;
                if (offset <= this.precedingOffset) continue;
                List<RowData> retractDataList = this.inputState.get(dataTs);
                if (retractDataList != null) {
                    for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                        RowData retractRow = retractDataList.get(dataListIndex);
                        this.function.retract(retractRow);
                    }
                    retractTsList.add(dataTs);
                    continue;
                }
                LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                RowData curRow = inputs.get(dataListIndex);
                this.function.accumulate(curRow);
            }
            RowData aggValue = this.function.getValue();
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                RowData curRow = inputs.get(dataListIndex);
                this.output.replace(curRow, aggValue);
                out.collect(this.output);
            }
            for (dataListIndex = 0; dataListIndex < retractTsList.size(); ++dataListIndex) {
                this.inputState.remove((Long)retractTsList.get(dataListIndex));
            }
            accumulators = this.function.getAccumulators();
            this.accState.update(accumulators);
        }
        this.lastTriggeringTsState.update(timestamp);
    }

    @Override
    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

