/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.clients.log4jappender;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientConfigurationConstants;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.clients.log4jappender.Log4jAvroHeaders;
import org.apache.flume.event.EventBuilder;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jAppender
extends AppenderSkeleton {
    private String hostname;
    private int port;
    private boolean unsafeMode = false;
    private long timeout = RpcClientConfigurationConstants.DEFAULT_REQUEST_TIMEOUT_MILLIS;
    private boolean avroReflectionEnabled;
    private String avroSchemaUrl;
    private String clientAddress = "";
    RpcClient rpcClient = null;
    private Schema schema;
    private ByteArrayOutputStream out;
    private DatumWriter<Object> writer;
    private BinaryEncoder encoder;

    public Log4jAppender() {
    }

    public Log4jAppender(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public synchronized void append(LoggingEvent event) throws FlumeException {
        if (this.rpcClient == null) {
            String errorMsg = "Cannot Append to Appender! Appender either closed or not setup correctly!";
            LogLog.error((String)errorMsg);
            if (this.unsafeMode) {
                return;
            }
            throw new FlumeException(errorMsg);
        }
        if (!this.rpcClient.isActive()) {
            this.reconnect();
        }
        List<Event> flumeEvents = this.parseEvents(event);
        try {
            switch (flumeEvents.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.rpcClient.append(flumeEvents.get(0));
                    break;
                }
                default: {
                    this.rpcClient.appendBatch(flumeEvents);
                    break;
                }
            }
        }
        catch (EventDeliveryException e) {
            String msg = "Flume append() failed.";
            LogLog.error((String)msg);
            if (this.unsafeMode) {
                return;
            }
            throw new FlumeException(msg + " Exception follows.", (Throwable)e);
        }
    }

    private List<Event> parseEvents(LoggingEvent loggingEvent) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Log4jAvroHeaders.LOGGER_NAME.toString(), loggingEvent.getLoggerName());
        headers.put(Log4jAvroHeaders.TIMESTAMP.toString(), String.valueOf(loggingEvent.timeStamp));
        headers.put(Log4jAvroHeaders.ADDRESS.toString(), this.clientAddress);
        headers.put(Log4jAvroHeaders.LOG_LEVEL.toString(), String.valueOf(loggingEvent.getLevel().toInt()));
        HashMap<String, String> headersWithEncoding = null;
        Set<Object> messages = loggingEvent.getMessage() instanceof Collection ? (Set<Object>)loggingEvent.getMessage() : Collections.singleton(loggingEvent.getMessage());
        LinkedList<Event> events = new LinkedList<Event>();
        for (Object e : messages) {
            String msg;
            if (e instanceof GenericRecord) {
                GenericRecord record = (GenericRecord)e;
                this.populateAvroHeaders(headers, record.getSchema());
                events.add(EventBuilder.withBody((byte[])this.serialize(record, record.getSchema()), headers));
                continue;
            }
            if (e instanceof SpecificRecord || this.avroReflectionEnabled) {
                Schema schema = ReflectData.get().getSchema(e.getClass());
                this.populateAvroHeaders(headers, schema);
                events.add(EventBuilder.withBody((byte[])this.serialize(e, schema), headers));
                continue;
            }
            if (this.layout != null) {
                LoggingEvent singleLoggingEvent = new LoggingEvent(loggingEvent.getFQNOfLoggerClass(), loggingEvent.getLogger(), loggingEvent.getTimeStamp(), loggingEvent.getLevel(), e, loggingEvent.getThreadName(), loggingEvent.getThrowableInformation(), loggingEvent.getNDC(), loggingEvent.getLocationInformation(), loggingEvent.getProperties());
                msg = this.layout.format(singleLoggingEvent);
            } else {
                msg = e.toString();
            }
            if (headersWithEncoding == null) {
                headersWithEncoding = new HashMap<String, String>(headers);
                headersWithEncoding.put(Log4jAvroHeaders.MESSAGE_ENCODING.toString(), "UTF8");
            }
            events.add(EventBuilder.withBody((String)msg, (Charset)Charset.forName("UTF8"), headersWithEncoding));
        }
        return events;
    }

    protected void populateAvroHeaders(Map<String, String> hdrs, Schema schema) {
        if (this.avroSchemaUrl != null) {
            hdrs.put(Log4jAvroHeaders.AVRO_SCHEMA_URL.toString(), this.avroSchemaUrl);
            return;
        }
        LogLog.warn((String)"Cannot find ID for schema. Adding header for schema, which may be inefficient. Consider setting up an Avro Schema Cache.");
        hdrs.put(Log4jAvroHeaders.AVRO_SCHEMA_LITERAL.toString(), schema.toString());
    }

    private byte[] serialize(Object datum, Schema datumSchema) throws FlumeException {
        if (this.schema == null || !datumSchema.equals((Object)this.schema)) {
            this.schema = datumSchema;
            this.out = new ByteArrayOutputStream();
            this.writer = new ReflectDatumWriter(this.schema);
            this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.out, null);
        }
        this.out.reset();
        try {
            this.writer.write(datum, (Encoder)this.encoder);
            this.encoder.flush();
            return this.out.toByteArray();
        }
        catch (IOException e) {
            throw new FlumeException((Throwable)e);
        }
    }

    public synchronized void close() throws FlumeException {
        if (this.rpcClient != null) {
            try {
                this.rpcClient.close();
            }
            catch (FlumeException ex) {
                LogLog.error((String)"Error while trying to close RpcClient.", (Throwable)ex);
                if (this.unsafeMode) {
                    return;
                }
                throw ex;
            }
            finally {
                this.rpcClient = null;
            }
        } else {
            String errorMsg = "Flume log4jappender already closed!";
            LogLog.error((String)errorMsg);
            if (this.unsafeMode) {
                return;
            }
            throw new FlumeException(errorMsg);
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUnsafeMode(boolean unsafeMode) {
        this.unsafeMode = unsafeMode;
    }

    public boolean getUnsafeMode() {
        return this.unsafeMode;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setAvroReflectionEnabled(boolean avroReflectionEnabled) {
        this.avroReflectionEnabled = avroReflectionEnabled;
    }

    public void setAvroSchemaUrl(String avroSchemaUrl) {
        this.avroSchemaUrl = avroSchemaUrl;
    }

    public void activateOptions() throws FlumeException {
        Properties props = new Properties();
        props.setProperty("hosts", "h1");
        props.setProperty("hosts.h1", this.hostname + ":" + this.port);
        props.setProperty("connect-timeout", String.valueOf(this.timeout));
        props.setProperty("request-timeout", String.valueOf(this.timeout));
        try {
            this.rpcClient = RpcClientFactory.getInstance((Properties)props);
            if (this.layout != null) {
                this.layout.activateOptions();
            }
        }
        catch (FlumeException e) {
            String errormsg = "RPC client creation failed! " + e.getMessage();
            LogLog.error((String)errormsg);
            if (this.unsafeMode) {
                return;
            }
            throw e;
        }
        this.initializeClientAddress();
    }

    protected void initializeClientAddress() throws FlumeException {
        try {
            this.clientAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            String errormsg = "Failed to resolve local host address! " + e.getMessage();
            LogLog.error((String)errormsg);
            if (this.unsafeMode) {
                return;
            }
            throw new FlumeException((Throwable)e);
        }
    }

    private void reconnect() throws FlumeException {
        this.close();
        this.activateOptions();
    }
}

