/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kafka.zk.KafkaZkClient;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.BasicChannelSemantics;
import org.apache.flume.channel.BasicTransactionSemantics;
import org.apache.flume.channel.kafka.ChannelCallback;
import org.apache.flume.channel.kafka.ChannelRebalanceListener;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.kafka.KafkaChannelCounter;
import org.apache.flume.shared.kafka.KafkaSSLUtil;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class KafkaChannel
extends BasicChannelSemantics {
    private static final Logger logger = LoggerFactory.getLogger(KafkaChannel.class);
    private static final int ZK_SESSION_TIMEOUT = 30000;
    private static final int ZK_CONNECTION_TIMEOUT = 30000;
    private final Properties consumerProps = new Properties();
    private final Properties producerProps = new Properties();
    private KafkaProducer<String, byte[]> producer;
    private final String channelUUID = UUID.randomUUID().toString();
    private AtomicReference<String> topic = new AtomicReference();
    private boolean parseAsFlumeEvent = true;
    private String zookeeperConnect = null;
    private String topicStr = "flume-channel";
    private String groupId = "flume";
    private String partitionHeader = null;
    private Integer staticPartitionId;
    @Deprecated
    private boolean migrateZookeeperOffsets = true;
    AtomicBoolean rebalanceFlag = new AtomicBoolean();
    private long pollTimeout = 500L;
    private final List<ConsumerAndRecords> consumers = Collections.synchronizedList(new LinkedList());
    private KafkaChannelCounter counter;
    private final ThreadLocal<ConsumerAndRecords> consumerAndRecords = new ThreadLocal<ConsumerAndRecords>(){

        @Override
        public ConsumerAndRecords initialValue() {
            return KafkaChannel.this.createConsumerAndRecords();
        }
    };

    public void start() {
        logger.info("Starting Kafka Channel: {}", (Object)this.getName());
        if (this.migrateZookeeperOffsets && this.zookeeperConnect != null && !this.zookeeperConnect.isEmpty()) {
            this.migrateOffsets();
        }
        this.producer = new KafkaProducer(this.producerProps);
        logger.info("Topic = {}", (Object)this.topic.get());
        this.counter.start();
        super.start();
    }

    public void stop() {
        for (ConsumerAndRecords c : this.consumers) {
            try {
                this.decommissionConsumerAndRecords(c);
            }
            catch (Exception ex) {
                logger.warn("Error while shutting down consumer.", (Throwable)ex);
            }
        }
        this.producer.close();
        this.counter.stop();
        super.stop();
        logger.info("Kafka channel {} stopped.", (Object)this.getName());
    }

    protected BasicTransactionSemantics createTransaction() {
        return new KafkaTransaction();
    }

    public void configure(Context ctx) {
        String bootStrapServers;
        this.translateOldProps(ctx);
        this.topicStr = ctx.getString("kafka.topic");
        if (this.topicStr == null || this.topicStr.isEmpty()) {
            this.topicStr = "flume-channel";
            logger.info("Topic was not specified. Using {} as the topic.", (Object)this.topicStr);
        }
        this.topic.set(this.topicStr);
        this.groupId = ctx.getString("kafka.consumer.group.id");
        if (this.groupId == null || this.groupId.isEmpty()) {
            this.groupId = "flume";
            logger.info("Group ID was not specified. Using {} as the group id.", (Object)this.groupId);
        }
        if ((bootStrapServers = ctx.getString("kafka.bootstrap.servers")) == null || bootStrapServers.isEmpty()) {
            throw new ConfigurationException("Bootstrap Servers must be specified");
        }
        this.setProducerProps(ctx, bootStrapServers);
        this.setConsumerProps(ctx, bootStrapServers);
        this.parseAsFlumeEvent = ctx.getBoolean("parseAsFlumeEvent", Boolean.valueOf(true));
        this.pollTimeout = ctx.getLong("kafka.pollTimeout", Long.valueOf(500L));
        this.staticPartitionId = ctx.getInteger("defaultPartitionId");
        this.partitionHeader = ctx.getString("partitionIdHeader");
        this.migrateZookeeperOffsets = ctx.getBoolean("migrateZookeeperOffsets", Boolean.valueOf(true));
        this.zookeeperConnect = ctx.getString("zookeeperConnect");
        if (logger.isDebugEnabled() && LogPrivacyUtil.allowLogPrintConfig()) {
            logger.debug("Kafka properties: {}", (Object)ctx);
        }
        if (this.counter == null) {
            this.counter = new KafkaChannelCounter(this.getName());
        }
    }

    private void translateOldProps(Context ctx) {
        Boolean oldReadSmallest;
        String oldGroupId;
        if (!ctx.containsKey("kafka.topic")) {
            ctx.put("kafka.topic", ctx.getString("topic"));
            logger.warn("{} is deprecated. Please use the parameter {}", (Object)"topic", (Object)"kafka.topic");
        }
        if (!ctx.containsKey("kafka.bootstrap.servers")) {
            String brokerList = ctx.getString("brokerList");
            if (brokerList == null || brokerList.isEmpty()) {
                throw new ConfigurationException("Bootstrap Servers must be specified");
            }
            ctx.put("kafka.bootstrap.servers", brokerList);
            logger.warn("{} is deprecated. Please use the parameter {}", (Object)"brokerList", (Object)"kafka.bootstrap.servers");
        }
        if (!ctx.containsKey("kafka.consumer.group.id") && (oldGroupId = ctx.getString("groupId")) != null && !oldGroupId.isEmpty()) {
            ctx.put("kafka.consumer.group.id", oldGroupId);
            logger.warn("{} is deprecated. Please use the parameter {}", (Object)"groupId", (Object)"kafka.consumer.group.id");
        }
        if (!ctx.containsKey("kafka.consumer.auto.offset.reset") && (oldReadSmallest = ctx.getBoolean("readSmallestOffset")) != null) {
            String auto = oldReadSmallest != false ? "earliest" : "latest";
            ctx.put("kafka.consumer.auto.offset.reset", auto);
            logger.warn("{} is deprecated. Please use the parameter {}", (Object)"readSmallestOffset", (Object)"kafka.consumer.auto.offset.reset");
        }
    }

    private void setProducerProps(Context ctx, String bootStrapServers) {
        this.producerProps.clear();
        this.producerProps.put("acks", "all");
        this.producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.producerProps.putAll((Map<?, ?>)ctx.getSubProperties("kafka.producer."));
        this.producerProps.put("bootstrap.servers", bootStrapServers);
        if (KafkaSSLUtil.isSSLEnabled((Properties)this.producerProps) && "true".equalsIgnoreCase(this.producerProps.getProperty("ssl.disableTLSHostnameVerification"))) {
            this.producerProps.put("ssl.endpoint.identification.algorithm", "");
        }
        KafkaSSLUtil.addGlobalSSLParameters((Properties)this.producerProps);
    }

    protected Properties getProducerProps() {
        return this.producerProps;
    }

    private void setConsumerProps(Context ctx, String bootStrapServers) {
        this.consumerProps.clear();
        this.consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        this.consumerProps.put("auto.offset.reset", "earliest");
        this.consumerProps.putAll((Map<?, ?>)ctx.getSubProperties("kafka.consumer."));
        this.consumerProps.put("bootstrap.servers", bootStrapServers);
        this.consumerProps.put("group.id", this.groupId);
        this.consumerProps.put("enable.auto.commit", (Object)false);
        if (KafkaSSLUtil.isSSLEnabled((Properties)this.consumerProps) && "true".equalsIgnoreCase(this.consumerProps.getProperty("ssl.disableTLSHostnameVerification"))) {
            this.consumerProps.put("ssl.endpoint.identification.algorithm", "");
        }
        KafkaSSLUtil.addGlobalSSLParameters((Properties)this.consumerProps);
    }

    protected Properties getConsumerProps() {
        return this.consumerProps;
    }

    private synchronized ConsumerAndRecords createConsumerAndRecords() {
        try {
            KafkaConsumer consumer = new KafkaConsumer(this.consumerProps);
            ConsumerAndRecords car = new ConsumerAndRecords((KafkaConsumer<String, byte[]>)consumer, this.channelUUID);
            logger.info("Created new consumer to connect to Kafka");
            car.consumer.subscribe(Arrays.asList(this.topic.get()), (ConsumerRebalanceListener)new ChannelRebalanceListener(this.rebalanceFlag));
            car.offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            this.consumers.add(car);
            return car;
        }
        catch (Exception e) {
            throw new FlumeException("Unable to connect to Kafka", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateOffsets() {
        try (KafkaZkClient zkClient = KafkaZkClient.apply((String)this.zookeeperConnect, (boolean)JaasUtils.isZkSaslEnabled(), (int)30000, (int)30000, (int)10, (Time)Time.SYSTEM, (String)"kafka.server", (String)"SessionExpireListener", (Option)Option.empty(), (Option)Option.empty());
             KafkaConsumer consumer = new KafkaConsumer(this.consumerProps);){
            Map<TopicPartition, OffsetAndMetadata> kafkaOffsets = this.getKafkaOffsets((KafkaConsumer<String, byte[]>)consumer);
            if (kafkaOffsets == null) {
                logger.warn("Topic " + this.topicStr + " not found in Kafka. Offset migration will be skipped.");
                return;
            }
            if (!kafkaOffsets.isEmpty()) {
                logger.info("Found Kafka offsets for topic {}. Will not migrate from zookeeper", (Object)this.topicStr);
                logger.debug("Offsets found: {}", kafkaOffsets);
                return;
            }
            logger.info("No Kafka offsets found. Migrating zookeeper offsets");
            Map<TopicPartition, OffsetAndMetadata> zookeeperOffsets = this.getZookeeperOffsets(zkClient, (KafkaConsumer<String, byte[]>)consumer);
            if (zookeeperOffsets.isEmpty()) {
                logger.warn("No offsets to migrate found in Zookeeper");
                return;
            }
            logger.info("Committing Zookeeper offsets to Kafka");
            logger.debug("Offsets to commit: {}", zookeeperOffsets);
            consumer.commitSync(zookeeperOffsets);
            Map<TopicPartition, OffsetAndMetadata> newKafkaOffsets = this.getKafkaOffsets((KafkaConsumer<String, byte[]>)consumer);
            logger.debug("Offsets committed: {}", newKafkaOffsets);
            if (newKafkaOffsets == null) throw new FlumeException("Offsets could not be committed");
            if (newKafkaOffsets.keySet().containsAll(zookeeperOffsets.keySet())) return;
            throw new FlumeException("Offsets could not be committed");
        }
    }

    private Map<TopicPartition, OffsetAndMetadata> getKafkaOffsets(KafkaConsumer<String, byte[]> client) {
        HashMap<TopicPartition, OffsetAndMetadata> offsets = null;
        List partitions = client.partitionsFor(this.topicStr);
        if (partitions != null) {
            offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            for (PartitionInfo partition : partitions) {
                TopicPartition key = new TopicPartition(this.topicStr, partition.partition());
                OffsetAndMetadata offsetAndMetadata = client.committed(key);
                if (offsetAndMetadata == null) continue;
                offsets.put(key, offsetAndMetadata);
            }
        }
        return offsets;
    }

    private Map<TopicPartition, OffsetAndMetadata> getZookeeperOffsets(KafkaZkClient zkClient, KafkaConsumer<String, byte[]> consumer) {
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        List partitions = consumer.partitionsFor(this.topicStr);
        for (PartitionInfo partition : partitions) {
            TopicPartition topicPartition = new TopicPartition(this.topicStr, partition.partition());
            Option optionOffset = zkClient.getConsumerOffset(this.groupId, topicPartition);
            if (!optionOffset.nonEmpty()) continue;
            Long offset = (Long)optionOffset.get();
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(offset.longValue());
            offsets.put(topicPartition, offsetAndMetadata);
        }
        return offsets;
    }

    private void decommissionConsumerAndRecords(ConsumerAndRecords c) {
        c.consumer.wakeup();
        c.consumer.close();
    }

    @VisibleForTesting
    void registerThread() {
        try {
            this.consumerAndRecords.get();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static Map<CharSequence, CharSequence> toCharSeqMap(Map<String, String> stringMap) {
        HashMap<CharSequence, CharSequence> charSeqMap = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            charSeqMap.put(entry.getKey(), entry.getValue());
        }
        return charSeqMap;
    }

    private static Map<String, String> toStringMap(Map<CharSequence, CharSequence> charSeqMap) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charSeqMap.entrySet()) {
            stringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return stringMap;
    }

    private class ConsumerAndRecords {
        final KafkaConsumer<String, byte[]> consumer;
        final String uuid;
        final LinkedList<Event> failedEvents = new LinkedList();
        ConsumerRecords<String, byte[]> records;
        Iterator<ConsumerRecord<String, byte[]>> recordIterator;
        Map<TopicPartition, OffsetAndMetadata> offsets;

        ConsumerAndRecords(KafkaConsumer<String, byte[]> consumer, String uuid) {
            this.consumer = consumer;
            this.uuid = uuid;
            this.records = ConsumerRecords.empty();
            this.recordIterator = this.records.iterator();
        }

        private void poll() {
            logger.trace("Polling with timeout: {}ms channel-{}", (Object)KafkaChannel.this.pollTimeout, (Object)KafkaChannel.this.getName());
            try {
                this.records = this.consumer.poll(Duration.ofMillis(KafkaChannel.this.pollTimeout));
                this.recordIterator = this.records.iterator();
                logger.debug("{} returned {} records from last poll", (Object)KafkaChannel.this.getName(), (Object)this.records.count());
            }
            catch (WakeupException e) {
                logger.trace("Consumer woken up for channel {}.", (Object)KafkaChannel.this.getName());
            }
        }

        private void commitOffsets() {
            try {
                this.consumer.commitSync(this.offsets);
            }
            catch (Exception e) {
                logger.info("Error committing offsets.", (Throwable)e);
            }
            finally {
                logger.trace("About to clear offsets map.");
                this.offsets.clear();
            }
        }

        private String getOffsetMapString() {
            StringBuilder sb = new StringBuilder();
            sb.append(KafkaChannel.this.getName()).append(" current offsets map: ");
            for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : this.offsets.entrySet()) {
                sb.append("p").append(entry.getKey().partition()).append('-').append(entry.getValue().offset()).append(' ');
            }
            return sb.toString();
        }

        private String getCommittedOffsetsString() {
            StringBuilder sb = new StringBuilder();
            sb.append(KafkaChannel.this.getName()).append(" committed: ");
            for (TopicPartition tp : this.consumer.assignment()) {
                try {
                    sb.append("[").append(tp).append(",").append(this.consumer.committed(tp).offset()).append("] ");
                }
                catch (NullPointerException npe) {
                    logger.debug("Committed {}", (Object)tp);
                }
            }
            return sb.toString();
        }

        private void saveOffsets(TopicPartition tp, OffsetAndMetadata oam) {
            this.offsets.put(tp, oam);
            if (logger.isTraceEnabled()) {
                logger.trace(this.getOffsetMapString());
            }
        }
    }

    private class KafkaTransaction
    extends BasicTransactionSemantics {
        private TransactionType type = TransactionType.NONE;
        private Optional<ByteArrayOutputStream> tempOutStream = Optional.absent();
        private Optional<LinkedList<ProducerRecord<String, byte[]>>> producerRecords = Optional.absent();
        private Optional<LinkedList<Event>> events = Optional.absent();
        private Optional<SpecificDatumWriter<AvroFlumeEvent>> writer = Optional.absent();
        private Optional<SpecificDatumReader<AvroFlumeEvent>> reader = Optional.absent();
        private Optional<LinkedList<Future<RecordMetadata>>> kafkaFutures = Optional.absent();
        private final String batchUUID = UUID.randomUUID().toString();
        private BinaryEncoder encoder = null;
        private BinaryDecoder decoder = null;
        private boolean eventTaken = false;

        private KafkaTransaction() {
        }

        protected void doBegin() throws InterruptedException {
            KafkaChannel.this.rebalanceFlag.set(false);
        }

        protected void doPut(Event event) throws InterruptedException {
            this.type = TransactionType.PUT;
            if (!this.producerRecords.isPresent()) {
                this.producerRecords = Optional.of(new LinkedList());
            }
            String key = (String)event.getHeaders().get("key");
            Integer partitionId = null;
            try {
                String headerVal;
                if (KafkaChannel.this.staticPartitionId != null) {
                    partitionId = KafkaChannel.this.staticPartitionId;
                }
                if (KafkaChannel.this.partitionHeader != null && (headerVal = (String)event.getHeaders().get(KafkaChannel.this.partitionHeader)) != null) {
                    partitionId = Integer.parseInt(headerVal);
                }
                if (partitionId != null) {
                    ((LinkedList)this.producerRecords.get()).add(new ProducerRecord((String)KafkaChannel.this.topic.get(), partitionId, (Object)key, (Object)this.serializeValue(event, KafkaChannel.this.parseAsFlumeEvent)));
                } else {
                    ((LinkedList)this.producerRecords.get()).add(new ProducerRecord((String)KafkaChannel.this.topic.get(), (Object)key, (Object)this.serializeValue(event, KafkaChannel.this.parseAsFlumeEvent)));
                }
                KafkaChannel.this.counter.incrementEventPutAttemptCount();
            }
            catch (NumberFormatException e) {
                throw new ChannelException("Non integer partition id specified", (Throwable)e);
            }
            catch (Exception e) {
                throw new ChannelException("Error while serializing event", (Throwable)e);
            }
        }

        protected Event doTake() throws InterruptedException {
            Event e;
            logger.trace("Starting event take");
            this.type = TransactionType.TAKE;
            try {
                if (!((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).uuid.equals(KafkaChannel.this.channelUUID)) {
                    logger.info("UUID mismatch, creating new consumer");
                    KafkaChannel.this.decommissionConsumerAndRecords((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get());
                    KafkaChannel.this.consumerAndRecords.remove();
                }
            }
            catch (Exception ex) {
                logger.warn("Error while shutting down consumer", (Throwable)ex);
            }
            if (!this.events.isPresent()) {
                this.events = Optional.of(new LinkedList());
            }
            if (KafkaChannel.this.rebalanceFlag.get()) {
                logger.debug("Returning null event after Consumer rebalance.");
                return null;
            }
            if (!((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).failedEvents.isEmpty()) {
                e = ((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).failedEvents.removeFirst();
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Assignment during take: {}", (Object)((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).consumer.assignment().toString());
                }
                try {
                    long startTime = System.nanoTime();
                    if (!((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).recordIterator.hasNext()) {
                        ((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get()).poll();
                    }
                    if (((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).recordIterator.hasNext()) {
                        ConsumerRecord<String, byte[]> record = ((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).recordIterator.next();
                        e = this.deserializeValue((byte[])record.value(), KafkaChannel.this.parseAsFlumeEvent);
                        TopicPartition tp = new TopicPartition(record.topic(), record.partition());
                        OffsetAndMetadata oam = new OffsetAndMetadata(record.offset() + 1L, this.batchUUID);
                        ((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get()).saveOffsets(tp, oam);
                        if (record.key() != null) {
                            e.getHeaders().put("key", record.key());
                        }
                        long endTime = System.nanoTime();
                        KafkaChannel.this.counter.addToKafkaEventGetTimer((endTime - startTime) / 1000000L);
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} processed output from partition {} offset {}", new Object[]{KafkaChannel.this.getName(), record.partition(), record.offset()});
                        }
                    } else {
                        return null;
                    }
                    KafkaChannel.this.counter.incrementEventTakeAttemptCount();
                }
                catch (Exception ex) {
                    logger.warn("Error while getting events from Kafka. This is usually caused by trying to read a non-flume event. Ensure the setting for parseAsFlumeEvent is correct", (Throwable)ex);
                    throw new ChannelException("Error while getting events from Kafka", (Throwable)ex);
                }
            }
            this.eventTaken = true;
            ((LinkedList)this.events.get()).add(e);
            return e;
        }

        protected void doCommit() throws InterruptedException {
            logger.trace("Starting commit");
            if (this.type.equals((Object)TransactionType.NONE)) {
                return;
            }
            if (this.type.equals((Object)TransactionType.PUT)) {
                if (!this.kafkaFutures.isPresent()) {
                    this.kafkaFutures = Optional.of(new LinkedList());
                }
                try {
                    long batchSize = ((LinkedList)this.producerRecords.get()).size();
                    long startTime = System.nanoTime();
                    int index = 0;
                    for (ProducerRecord record : (LinkedList)this.producerRecords.get()) {
                        ((LinkedList)this.kafkaFutures.get()).add(KafkaChannel.this.producer.send(record, (Callback)new ChannelCallback(++index, startTime)));
                    }
                    KafkaChannel.this.producer.flush();
                    for (Future future : (LinkedList)this.kafkaFutures.get()) {
                        future.get();
                    }
                    long endTime = System.nanoTime();
                    KafkaChannel.this.counter.addToKafkaEventSendTimer((endTime - startTime) / 1000000L);
                    KafkaChannel.this.counter.addToEventPutSuccessCount(batchSize);
                    ((LinkedList)this.producerRecords.get()).clear();
                    ((LinkedList)this.kafkaFutures.get()).clear();
                }
                catch (Exception ex) {
                    logger.warn("Sending events to Kafka failed", (Throwable)ex);
                    throw new ChannelException("Commit failed as send to Kafka failed", (Throwable)ex);
                }
            } else {
                int takes;
                if (((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).failedEvents.isEmpty() && this.eventTaken) {
                    logger.trace("About to commit batch");
                    long startTime = System.nanoTime();
                    ((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get()).commitOffsets();
                    long endTime = System.nanoTime();
                    KafkaChannel.this.counter.addToKafkaCommitTimer((endTime - startTime) / 1000000L);
                    if (logger.isDebugEnabled()) {
                        logger.debug(((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get()).getCommittedOffsetsString());
                    }
                }
                if ((takes = ((LinkedList)this.events.get()).size()) > 0) {
                    KafkaChannel.this.counter.addToEventTakeSuccessCount((long)takes);
                    ((LinkedList)this.events.get()).clear();
                }
            }
        }

        protected void doRollback() throws InterruptedException {
            if (this.type.equals((Object)TransactionType.NONE)) {
                return;
            }
            if (this.type.equals((Object)TransactionType.PUT)) {
                ((LinkedList)this.producerRecords.get()).clear();
                ((LinkedList)this.kafkaFutures.get()).clear();
            } else {
                KafkaChannel.this.counter.addToRollbackCounter((long)((LinkedList)this.events.get()).size());
                ((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).failedEvents.addAll((Collection)this.events.get());
                ((LinkedList)this.events.get()).clear();
            }
        }

        private byte[] serializeValue(Event event, boolean parseAsFlumeEvent) throws IOException {
            byte[] bytes;
            if (parseAsFlumeEvent) {
                if (!this.tempOutStream.isPresent()) {
                    this.tempOutStream = Optional.of((Object)new ByteArrayOutputStream());
                }
                if (!this.writer.isPresent()) {
                    this.writer = Optional.of((Object)new SpecificDatumWriter(AvroFlumeEvent.class));
                }
                ((ByteArrayOutputStream)this.tempOutStream.get()).reset();
                AvroFlumeEvent e = new AvroFlumeEvent(KafkaChannel.toCharSeqMap(event.getHeaders()), ByteBuffer.wrap(event.getBody()));
                this.encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)this.tempOutStream.get(), this.encoder);
                ((SpecificDatumWriter)this.writer.get()).write((Object)e, (Encoder)this.encoder);
                this.encoder.flush();
                bytes = ((ByteArrayOutputStream)this.tempOutStream.get()).toByteArray();
            } else {
                bytes = event.getBody();
            }
            return bytes;
        }

        private Event deserializeValue(byte[] value, boolean parseAsFlumeEvent) throws IOException {
            Event e;
            if (parseAsFlumeEvent) {
                ByteArrayInputStream in = new ByteArrayInputStream(value);
                this.decoder = DecoderFactory.get().directBinaryDecoder((InputStream)in, this.decoder);
                if (!this.reader.isPresent()) {
                    this.reader = Optional.of((Object)new SpecificDatumReader(AvroFlumeEvent.class));
                }
                AvroFlumeEvent event = (AvroFlumeEvent)((SpecificDatumReader)this.reader.get()).read(null, (Decoder)this.decoder);
                e = EventBuilder.withBody((byte[])event.getBody().array(), (Map)KafkaChannel.toStringMap(event.getHeaders()));
            } else {
                e = EventBuilder.withBody((byte[])value, (Map)Collections.EMPTY_MAP);
            }
            return e;
        }
    }

    private static enum TransactionType {
        PUT,
        TAKE,
        NONE;

    }
}

