/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLParameters;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.conf.BatchSizeSupported;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.SslContextAwareAbstractSource;
import org.apache.flume.source.SyslogParser;
import org.apache.flume.source.SyslogUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiportSyslogTCPSource
extends SslContextAwareAbstractSource
implements EventDrivenSource,
Configurable,
BatchSizeSupported {
    public static final Logger logger = LoggerFactory.getLogger(MultiportSyslogTCPSource.class);
    private final ConcurrentMap<Integer, ThreadSafeDecoder> portCharsets;
    private List<Integer> ports = Lists.newArrayList();
    private String host;
    private NioSocketAcceptor acceptor;
    private Integer numProcessors;
    private int maxEventSize;
    private int batchSize;
    private int readBufferSize;
    private String portHeader;
    private String clientIPHeader;
    private String clientHostnameHeader;
    private SourceCounter sourceCounter = null;
    private Charset defaultCharset;
    private ThreadSafeDecoder defaultDecoder;
    private Set<String> keepFields;

    public MultiportSyslogTCPSource() {
        this.portCharsets = new ConcurrentHashMap<Integer, ThreadSafeDecoder>();
    }

    @Override
    public void configure(Context context) {
        this.configureSsl(context);
        String portsStr = context.getString("ports");
        Preconditions.checkNotNull((Object)portsStr, (Object)"Must define config parameter for MultiportSyslogTCPSource: ports");
        for (String portStr : portsStr.split("\\s+")) {
            Integer port = Integer.parseInt(portStr);
            this.ports.add(port);
        }
        this.host = context.getString("host");
        this.numProcessors = context.getInteger("numProcessors");
        this.maxEventSize = context.getInteger("eventSize", SyslogUtils.DEFAULT_SIZE);
        String defaultCharsetStr = context.getString("charset.default", "UTF-8");
        try {
            this.defaultCharset = Charset.forName(defaultCharsetStr);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to parse charset string (" + defaultCharsetStr + ") from port configuration.", ex);
        }
        this.defaultDecoder = new ThreadSafeDecoder(this.defaultCharset);
        this.portCharsets.clear();
        Map portCharsetCfg = context.getSubProperties("charset.port.");
        for (Map.Entry entry : portCharsetCfg.entrySet()) {
            String portStr = (String)entry.getKey();
            String charsetStr = (String)entry.getValue();
            Integer port = Integer.parseInt(portStr);
            Preconditions.checkNotNull((Object)port, (Object)"Invalid port number in config");
            try {
                Charset charset = Charset.forName(charsetStr);
                this.portCharsets.put(port, new ThreadSafeDecoder(charset));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to parse charset string (" + charsetStr + ") from port configuration.", ex);
            }
        }
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(100));
        this.portHeader = context.getString("portHeader");
        this.clientIPHeader = context.getString("clientIPHeader");
        this.clientHostnameHeader = context.getString("clientHostnameHeader");
        this.readBufferSize = context.getInteger("readBufferBytes", Integer.valueOf(1024));
        this.keepFields = SyslogUtils.chooseFieldsToKeep(context.getString("keepFields", "none"));
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @Override
    public void start() {
        logger.info("Starting {}...", (Object)this);
        this.acceptor = this.numProcessors != null ? new NioSocketAcceptor(this.numProcessors.intValue()) : new NioSocketAcceptor();
        this.getSslContextSupplier().get().ifPresent(sslContext -> {
            SslFilter filter = new SslFilter(sslContext);
            SSLParameters sslParameters = sslContext.getDefaultSSLParameters();
            filter.setEnabledProtocols(this.getFilteredProtocols(sslParameters));
            filter.setEnabledCipherSuites(this.getFilteredCipherSuites(sslParameters));
            this.acceptor.getFilterChain().addFirst("ssl", (IoFilter)filter);
        });
        this.acceptor.setReuseAddress(true);
        this.acceptor.getSessionConfig().setReadBufferSize(this.readBufferSize);
        this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        this.acceptor.setHandler((IoHandler)new MultiportSyslogHandler(this.maxEventSize, this.batchSize, this.getChannelProcessor(), this.sourceCounter, this.portHeader, this.clientIPHeader, this.clientHostnameHeader, this.defaultDecoder, this.portCharsets, this.keepFields));
        for (int port : this.ports) {
            InetSocketAddress addr = this.host != null ? new InetSocketAddress(this.host, port) : new InetSocketAddress(port);
            try {
                this.acceptor.bind((SocketAddress)addr);
            }
            catch (IOException ex) {
                logger.error("Could not bind to address: " + String.valueOf(addr), (Throwable)ex);
            }
        }
        this.sourceCounter.start();
        super.start();
        logger.info("{} started.", (Object)this);
    }

    @Override
    public void stop() {
        logger.info("Stopping {}...", (Object)this);
        this.acceptor.unbind();
        this.acceptor.dispose();
        this.sourceCounter.stop();
        super.stop();
        logger.info("{} stopped. Metrics: {}", (Object)this, (Object)this.sourceCounter);
    }

    @Override
    public String toString() {
        return "Multiport Syslog TCP source " + this.getName();
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }

    static class ThreadSafeDecoder
    extends ThreadLocal<CharsetDecoder> {
        private final Charset charset;

        public ThreadSafeDecoder(Charset charset) {
            this.charset = charset;
        }

        @Override
        protected CharsetDecoder initialValue() {
            return this.charset.newDecoder();
        }
    }

    static class ParsedBuffer {
        public IoBuffer buffer = null;
        public boolean incomplete = false;

        ParsedBuffer() {
        }
    }

    static class LineSplitter {
        private static final byte NEWLINE = 10;
        private final int maxLineLength;

        public LineSplitter(int maxLineLength) {
            this.maxLineLength = maxLineLength;
        }

        public boolean parseLine(IoBuffer buf, IoBuffer savedBuf, ParsedBuffer parsedBuf) {
            int msgPos;
            parsedBuf.buffer = null;
            parsedBuf.incomplete = false;
            buf.mark();
            boolean seenNewline = false;
            for (msgPos = savedBuf.position(); !seenNewline && buf.hasRemaining() && msgPos < this.maxLineLength; ++msgPos) {
                byte curByte = buf.get();
                if (curByte != 10) continue;
                seenNewline = true;
            }
            if (seenNewline) {
                int end = buf.position();
                buf.reset();
                int start = buf.position();
                if (savedBuf.position() > 0) {
                    byte[] tmp = new byte[end - start];
                    buf.get(tmp);
                    savedBuf.put(tmp);
                    int len = savedBuf.position() - 1;
                    savedBuf.flip();
                    parsedBuf.buffer = savedBuf.getSlice(len);
                    savedBuf.clear();
                } else {
                    parsedBuf.buffer = buf.getSlice(end - start - 1);
                    buf.get();
                }
                return true;
            }
            if (msgPos == this.maxLineLength) {
                int end = buf.position();
                buf.reset();
                int start = buf.position();
                if (savedBuf.position() > 0) {
                    byte[] tmp = new byte[end - start];
                    buf.get(tmp);
                    savedBuf.put(tmp);
                    savedBuf.flip();
                    parsedBuf.buffer = savedBuf.getSlice(msgPos);
                    savedBuf.clear();
                } else {
                    parsedBuf.buffer = buf.getSlice(msgPos);
                }
                logger.warn("Event size larger than specified event size: {}. Consider increasing the max event size.", (Object)this.maxLineLength);
                parsedBuf.incomplete = true;
                return true;
            }
            if (!buf.hasRemaining()) {
                int end = buf.position();
                buf.reset();
                int start = buf.position();
                byte[] tmp = new byte[end - start];
                buf.get(tmp);
                savedBuf.put(tmp);
                return false;
            }
            throw new IllegalStateException("unexpected buffer state: msgPos=" + msgPos + ", buf.hasRemaining=" + buf.hasRemaining() + ", savedBuf.hasRemaining=" + savedBuf.hasRemaining() + ", seenNewline=" + seenNewline + ", maxLen=" + this.maxLineLength);
        }
    }

    static class MultiportSyslogHandler
    extends IoHandlerAdapter {
        private static final String SAVED_BUF = "savedBuffer";
        private final ChannelProcessor channelProcessor;
        private final int maxEventSize;
        private final int batchSize;
        private final SourceCounter sourceCounter;
        private final String portHeader;
        private final String clientIPHeader;
        private final String clientHostnameHeader;
        private final SyslogParser syslogParser;
        private final LineSplitter lineSplitter;
        private final ThreadSafeDecoder defaultDecoder;
        private final ConcurrentMap<Integer, ThreadSafeDecoder> portCharsets;
        private Set<String> keepFields;

        public MultiportSyslogHandler(int maxEventSize, int batchSize, ChannelProcessor cp, SourceCounter ctr, String portHeader, String clientIPHeader, String clientHostnameHeader, ThreadSafeDecoder defaultDecoder, ConcurrentMap<Integer, ThreadSafeDecoder> portCharsets, Set<String> keepFields) {
            this.channelProcessor = cp;
            this.sourceCounter = ctr;
            this.maxEventSize = maxEventSize;
            this.batchSize = batchSize;
            this.portHeader = portHeader;
            this.clientIPHeader = clientIPHeader;
            this.clientHostnameHeader = clientHostnameHeader;
            this.defaultDecoder = defaultDecoder;
            this.portCharsets = portCharsets;
            this.keepFields = keepFields;
            this.syslogParser = new SyslogParser();
            this.lineSplitter = new LineSplitter(maxEventSize);
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            logger.error("Error in syslog message handler", cause);
            this.sourceCounter.incrementGenericProcessingFail();
            if (cause instanceof Error) {
                Throwables.propagate((Throwable)cause);
            }
        }

        public void sessionCreated(IoSession session) {
            logger.info("Session created: {}", (Object)session);
            session.setAttribute((Object)SAVED_BUF, (Object)IoBuffer.allocate((int)this.maxEventSize, (boolean)false));
        }

        public void sessionOpened(IoSession session) {
            logger.debug("Session opened: {}", (Object)session);
        }

        public void sessionClosed(IoSession session) {
            logger.info("Session closed: {}", (Object)session);
        }

        public void messageReceived(IoSession session, Object message) {
            IoBuffer buf = (IoBuffer)message;
            IoBuffer savedBuf = (IoBuffer)session.getAttribute((Object)SAVED_BUF);
            ParsedBuffer parsedLine = new ParsedBuffer();
            ArrayList events = Lists.newArrayList();
            CharsetDecoder decoder = (CharsetDecoder)this.defaultDecoder.get();
            int port = ((InetSocketAddress)session.getLocalAddress()).getPort();
            if (this.portCharsets.containsKey(port)) {
                decoder = (CharsetDecoder)((ThreadSafeDecoder)this.portCharsets.get(port)).get();
            }
            while (buf.hasRemaining()) {
                events.clear();
                for (int num = 0; num < this.batchSize && buf.hasRemaining(); ++num) {
                    if (this.lineSplitter.parseLine(buf, savedBuf, parsedLine)) {
                        Event event = this.parseEvent(parsedLine, decoder);
                        if (this.portHeader != null) {
                            event.getHeaders().put(this.portHeader, String.valueOf(port));
                        }
                        if (this.clientIPHeader != null) {
                            event.getHeaders().put(this.clientIPHeader, SyslogUtils.getIP(session.getRemoteAddress()));
                        }
                        if (this.clientHostnameHeader != null) {
                            event.getHeaders().put(this.clientHostnameHeader, SyslogUtils.getHostname(session.getRemoteAddress()));
                        }
                        events.add(event);
                        continue;
                    }
                    logger.trace("Parsed null event");
                }
                if (events.isEmpty()) {
                    logger.trace("Empty set!");
                    return;
                }
                int numEvents = events.size();
                this.sourceCounter.addToEventReceivedCount(numEvents);
                try {
                    this.channelProcessor.processEventBatch(events);
                    this.sourceCounter.addToEventAcceptedCount(numEvents);
                }
                catch (Throwable t) {
                    logger.error("Error writing to channel, event dropped", t);
                    this.sourceCounter.incrementEventReadOrChannelFail(t);
                    if (!(t instanceof Error)) continue;
                    Throwables.propagate((Throwable)t);
                }
            }
        }

        Event parseEvent(ParsedBuffer parsedBuf, CharsetDecoder decoder) {
            Event event;
            String msg = null;
            try {
                msg = parsedBuf.buffer.getString(decoder);
            }
            catch (Throwable t) {
                logger.info("Error decoding line with charset (" + decoder.charset() + "). Exception follows.", t);
                this.sourceCounter.incrementEventReadFail();
                if (t instanceof Error) {
                    Throwables.propagate((Throwable)t);
                }
                byte[] bytes = new byte[parsedBuf.buffer.remaining()];
                parsedBuf.buffer.get(bytes);
                Event event2 = EventBuilder.withBody((byte[])bytes);
                event2.getHeaders().put("flume.syslog.status", SyslogUtils.SyslogStatus.INVALID.getSyslogStatus());
                return event2;
            }
            if (logger.isTraceEnabled()) {
                if (LogPrivacyUtil.allowLogRawData()) {
                    logger.trace("Seen raw event: {}", (Object)msg);
                } else {
                    logger.trace("Seen raw event.");
                }
            }
            try {
                event = this.syslogParser.parseMessage(msg, decoder.charset(), this.keepFields);
                if (parsedBuf.incomplete) {
                    event.getHeaders().put("flume.syslog.status", SyslogUtils.SyslogStatus.INCOMPLETE.getSyslogStatus());
                }
            }
            catch (IllegalArgumentException ex) {
                event = EventBuilder.withBody((String)msg, (Charset)decoder.charset());
                event.getHeaders().put("flume.syslog.status", SyslogUtils.SyslogStatus.INVALID.getSyslogStatus());
                logger.debug("Error parsing syslog event", (Throwable)ex);
                this.sourceCounter.incrementEventReadFail();
            }
            return event;
        }
    }
}

