/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.tools;

import org.apache.flume.VersionAnnotation;

public class VersionInfo {
    private static Package myPackage = VersionAnnotation.class.getPackage();
    private static VersionAnnotation version = myPackage.getAnnotation(VersionAnnotation.class);

    static Package getPackage() {
        return myPackage;
    }

    public static String getVersion() {
        return version != null ? version.version() : "Unknown";
    }

    public static String getRevision() {
        if (version != null && version.revision() != null && !version.revision().isEmpty()) {
            return version.revision();
        }
        return "Unknown";
    }

    public static String getBranch() {
        return version != null ? version.branch() : "Unknown";
    }

    public static String getDate() {
        return version != null ? version.date() : "Unknown";
    }

    public static String getUser() {
        return version != null ? version.user() : "Unknown";
    }

    public static String getUrl() {
        return version != null ? version.url() : "Unknown";
    }

    public static String getSrcChecksum() {
        return version != null ? version.srcChecksum() : "Unknown";
    }

    public static String getBuildVersion() {
        return VersionInfo.getVersion() + " from " + VersionInfo.getRevision() + " by " + VersionInfo.getUser() + " on " + VersionInfo.getDate() + " source checksum " + VersionInfo.getSrcChecksum();
    }

    public static void main(String[] args) {
        System.out.println("Flume " + VersionInfo.getVersion());
        System.out.println("Source code repository: https://git.apache.org/repos/asf/flume.git");
        System.out.println("Revision: " + VersionInfo.getRevision());
        System.out.println("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        System.out.println("From source with checksum " + VersionInfo.getSrcChecksum());
    }
}

