/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package org.apache.fluo.recipes.core.map.it;

import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.recipes.core.serialization.SimpleSerializer;

public class TestSerializer implements SimpleSerializer {

  @Override
  public <T> byte[] serialize(T obj) {
    return obj.toString().getBytes();
  }

  @SuppressWarnings("unchecked")
  @Override
  public <T> T deserialize(byte[] serObj, Class<T> clazz) {
    if (clazz.equals(Long.class)) {
      return (T) Long.valueOf(new String(serObj));
    }

    if (clazz.equals(String.class)) {
      return (T) new String(serObj);
    }

    throw new IllegalArgumentException();
  }

  @Override
  public void init(SimpleConfiguration appConfig) {}

}
