/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.hll.HyperLogLogPlus;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.CreateRegionCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.KeyRegistrar;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RegionCreationException;
import org.apache.geode.redis.internal.executor.ExpirationExecutor;
import org.apache.geode.redis.internal.executor.ListQuery;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.set.DeltaSet;
import org.apache.geode.redis.internal.executor.set.GeodeRedisSetWithFunctions;

public class RegionProvider
implements Closeable {
    private final ConcurrentHashMap<ByteArrayWrapper, Region<Object, Object>> regions;
    private final KeyRegistrar keyRegistrar;
    private final Region<ByteArrayWrapper, ByteArrayWrapper> stringsRegion;
    private final Region<ByteArrayWrapper, HyperLogLogPlus> hLLRegion;
    private final Region<ByteArrayWrapper, Map<ByteArrayWrapper, ByteArrayWrapper>> hashRegion;
    private final Region<ByteArrayWrapper, DeltaSet> setRegion;
    private final Cache cache;
    private final QueryService queryService;
    private final ConcurrentMap<ByteArrayWrapper, Map<Enum<?>, Query>> preparedQueries = new ConcurrentHashMap();
    private final ConcurrentMap<ByteArrayWrapper, ScheduledFuture<?>> expirationsMap;
    private final ScheduledExecutorService expirationExecutor;
    private final RegionShortcut defaultRegionType;
    @Immutable
    private static final CreateRegionCommand createRegionCmd = new CreateRegionCommand();
    private final ConcurrentHashMap<String, Lock> locks;

    public RegionProvider(Region<ByteArrayWrapper, ByteArrayWrapper> stringsRegion, Region<ByteArrayWrapper, HyperLogLogPlus> hLLRegion, KeyRegistrar redisMetaRegion, ConcurrentMap<ByteArrayWrapper, ScheduledFuture<?>> expirationsMap, ScheduledExecutorService expirationExecutor, RegionShortcut defaultShortcut, Region<ByteArrayWrapper, Map<ByteArrayWrapper, ByteArrayWrapper>> hashRegion, Region<ByteArrayWrapper, DeltaSet> setRegion) {
        this(stringsRegion, hLLRegion, redisMetaRegion, expirationsMap, expirationExecutor, defaultShortcut, hashRegion, setRegion, (Cache)GemFireCacheImpl.getInstance());
    }

    public RegionProvider(Region<ByteArrayWrapper, ByteArrayWrapper> stringsRegion, Region<ByteArrayWrapper, HyperLogLogPlus> hLLRegion, KeyRegistrar redisMetaRegion, ConcurrentMap<ByteArrayWrapper, ScheduledFuture<?>> expirationsMap, ScheduledExecutorService expirationExecutor, RegionShortcut defaultShortcut, Region<ByteArrayWrapper, Map<ByteArrayWrapper, ByteArrayWrapper>> hashRegion, Region<ByteArrayWrapper, DeltaSet> setRegion, Cache cache) {
        if (stringsRegion == null || hLLRegion == null || redisMetaRegion == null) {
            throw new NullPointerException();
        }
        this.hashRegion = hashRegion;
        this.setRegion = setRegion;
        this.regions = new ConcurrentHashMap();
        this.stringsRegion = stringsRegion;
        this.hLLRegion = hLLRegion;
        this.keyRegistrar = redisMetaRegion;
        this.cache = cache;
        this.queryService = cache.getQueryService();
        this.expirationsMap = expirationsMap;
        this.expirationExecutor = expirationExecutor;
        this.defaultRegionType = defaultShortcut;
        this.locks = new ConcurrentHashMap();
    }

    public Region<?, ?> getRegion(ByteArrayWrapper key) {
        if (key == null) {
            return null;
        }
        return this.regions.get(key);
    }

    public Region<ByteArrayWrapper, ?> getRegionForType(RedisDataType redisDataType) {
        if (redisDataType == null) {
            return null;
        }
        switch (redisDataType) {
            case REDIS_STRING: {
                return this.stringsRegion;
            }
            case REDIS_HASH: {
                return this.hashRegion;
            }
            case REDIS_SET: 
            case REDIS_SORTEDSET: {
                return this.setRegion;
            }
            case REDIS_HLL: {
                return this.hLLRegion;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegionReferenceLocally(ByteArrayWrapper key, RedisDataType type) {
        Lock lock = this.locks.get(key.toString());
        boolean locked = false;
        try {
            if (lock != null) {
                locked = lock.tryLock();
            }
            if (locked) {
                this.cancelKeyExpiration(key);
                this.removeRegionState(key, type);
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    public boolean removeKey(ByteArrayWrapper key) {
        RedisDataType type = this.keyRegistrar.getType(key);
        return this.removeKey(key, type);
    }

    public boolean removeKey(ByteArrayWrapper key, RedisDataType type) {
        return this.removeKey(key, type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(ByteArrayWrapper key, RedisDataType type, boolean cancelExpiration) {
        if (type == RedisDataType.REDIS_PROTECTED) {
            return false;
        }
        Lock lock = this.locks.get(key.toString());
        try {
            boolean geodeRedisSet22;
            block50: {
                block43: {
                    block41: {
                        boolean geodeRedisSet22;
                        block49: {
                            block42: {
                                block39: {
                                    boolean bl;
                                    block48: {
                                        block40: {
                                            block37: {
                                                boolean bl2;
                                                block47: {
                                                    block38: {
                                                        block35: {
                                                            boolean bl3;
                                                            block46: {
                                                                block36: {
                                                                    block33: {
                                                                        boolean bl4;
                                                                        block45: {
                                                                            block34: {
                                                                                if (lock != null) {
                                                                                    lock.lock();
                                                                                }
                                                                                this.keyRegistrar.unregister(key);
                                                                                if (type != RedisDataType.REDIS_STRING) break block33;
                                                                                boolean bl5 = bl4 = this.stringsRegion.remove((Object)key) != null;
                                                                                if (!cancelExpiration) break block34;
                                                                                this.cancelKeyExpiration(key);
                                                                                break block45;
                                                                            }
                                                                            this.removeKeyExpiration(key);
                                                                        }
                                                                        if (lock != null) {
                                                                            this.locks.remove(key.toString());
                                                                        }
                                                                        return bl4;
                                                                    }
                                                                    if (type != RedisDataType.REDIS_HLL) break block35;
                                                                    boolean bl6 = bl3 = this.hLLRegion.remove((Object)key) != null;
                                                                    if (!cancelExpiration) break block36;
                                                                    this.cancelKeyExpiration(key);
                                                                    break block46;
                                                                }
                                                                this.removeKeyExpiration(key);
                                                            }
                                                            if (lock != null) {
                                                                this.locks.remove(key.toString());
                                                            }
                                                            return bl3;
                                                        }
                                                        if (type != RedisDataType.REDIS_LIST && type != RedisDataType.REDIS_SORTEDSET) break block37;
                                                        bl2 = this.destroyRegion(key, type);
                                                        if (!cancelExpiration) break block38;
                                                        this.cancelKeyExpiration(key);
                                                        break block47;
                                                    }
                                                    this.removeKeyExpiration(key);
                                                }
                                                if (lock != null) {
                                                    this.locks.remove(key.toString());
                                                }
                                                return bl2;
                                            }
                                            if (type != RedisDataType.REDIS_SET) break block39;
                                            GeodeRedisSetWithFunctions geodeRedisSet22 = new GeodeRedisSetWithFunctions(key, this.setRegion);
                                            bl = geodeRedisSet22.del();
                                            if (!cancelExpiration) break block40;
                                            this.cancelKeyExpiration(key);
                                            break block48;
                                        }
                                        this.removeKeyExpiration(key);
                                    }
                                    if (lock != null) {
                                        this.locks.remove(key.toString());
                                    }
                                    return bl;
                                }
                                if (type != RedisDataType.REDIS_HASH) break block41;
                                this.hashRegion.remove((Object)key);
                                geodeRedisSet22 = true;
                                if (!cancelExpiration) break block42;
                                this.cancelKeyExpiration(key);
                                break block49;
                            }
                            this.removeKeyExpiration(key);
                        }
                        if (lock != null) {
                            this.locks.remove(key.toString());
                        }
                        return geodeRedisSet22;
                    }
                    try {
                        geodeRedisSet22 = false;
                        if (!cancelExpiration) break block43;
                        this.cancelKeyExpiration(key);
                    }
                    catch (Exception exc) {
                        boolean bl;
                        block51: {
                            block44: {
                                try {
                                    bl = false;
                                    if (!cancelExpiration) break block44;
                                    this.cancelKeyExpiration(key);
                                }
                                catch (Throwable throwable) {
                                    if (cancelExpiration) {
                                        this.cancelKeyExpiration(key);
                                    } else {
                                        this.removeKeyExpiration(key);
                                    }
                                    if (lock != null) {
                                        this.locks.remove(key.toString());
                                    }
                                    throw throwable;
                                }
                                break block51;
                            }
                            this.removeKeyExpiration(key);
                        }
                        if (lock != null) {
                            this.locks.remove(key.toString());
                        }
                        if (lock != null) {
                            lock.unlock();
                        }
                        return bl;
                    }
                    break block50;
                }
                this.removeKeyExpiration(key);
            }
            if (lock != null) {
                this.locks.remove(key.toString());
            }
            return geodeRedisSet22;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public Region<?, ?> getOrCreateRegion(ByteArrayWrapper key, RedisDataType type, ExecutionHandlerContext context) {
        return this.getOrCreateRegion0(key, type, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRemoteRegionReferenceLocally(ByteArrayWrapper key, RedisDataType type) {
        block15: {
            if (type == null || type == RedisDataType.REDIS_STRING || type == RedisDataType.REDIS_HLL) {
                return;
            }
            Region r = this.regions.get(key);
            if (r != null) {
                return;
            }
            if (!this.regions.containsKey(key)) {
                String stringKey = key.toString();
                Lock lock = this.locks.get(stringKey);
                if (lock == null) {
                    this.locks.putIfAbsent(stringKey, new ReentrantLock());
                    lock = this.locks.get(stringKey);
                }
                boolean locked = false;
                try {
                    locked = lock.tryLock();
                    if (!locked) break block15;
                    r = this.cache.getRegion(key.toString());
                    if (r == null) {
                        return;
                    }
                    if (type == RedisDataType.REDIS_LIST) {
                        this.doInitializeList(key, (Region<Object, Object>)r);
                    } else if (type == RedisDataType.REDIS_SORTEDSET) {
                        try {
                            this.doInitializeSortedSet(key, r);
                        }
                        catch (IndexInvalidException | RegionNotFoundException throwable) {
                            // empty catch block
                        }
                    }
                    this.regions.put(key, (Region<Object, Object>)r);
                }
                finally {
                    if (locked) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Region<?, ?> getOrCreateRegion0(ByteArrayWrapper key, RedisDataType type, ExecutionHandlerContext context, boolean addToMeta) {
        String regionName = key.toString();
        this.keyRegistrar.validate(key, type);
        Region<Object, Object> r = this.regions.get(key);
        if (r != null && r.isDestroyed()) {
            this.removeKey(key, type);
            r = null;
        }
        if (r != null) return r;
        String stringKey = key.toString();
        Lock lock = this.locks.get(stringKey);
        if (lock == null) {
            this.locks.putIfAbsent(stringKey, new ReentrantLock());
            lock = this.locks.get(stringKey);
        }
        try {
            lock.lock();
            r = this.regions.get(key);
            if (r != null) return r;
            boolean hasTransaction = context != null && context.hasTransaction();
            CacheTransactionManager txm = null;
            TransactionId transactionId = null;
            try {
                Throwable concurrentCreateDestroyException;
                if (hasTransaction) {
                    txm = this.cache.getCacheTransactionManager();
                    transactionId = txm.suspend();
                }
                do {
                    concurrentCreateDestroyException = null;
                    r = this.createRegionGlobally(regionName);
                    try {
                        if (type == RedisDataType.REDIS_LIST) {
                            this.doInitializeList(key, r);
                            continue;
                        }
                        if (type != RedisDataType.REDIS_SORTEDSET) continue;
                        try {
                            this.doInitializeSortedSet(key, r);
                        }
                        catch (IndexInvalidException | RegionNotFoundException e) {
                            concurrentCreateDestroyException = e;
                        }
                    }
                    catch (QueryInvalidException e) {
                        if (!(e.getCause() instanceof RegionNotFoundException)) continue;
                        concurrentCreateDestroyException = e;
                    }
                } while (concurrentCreateDestroyException != null);
                this.regions.put(key, r);
                if (addToMeta) {
                    this.keyRegistrar.register(key, type);
                }
                if (!hasTransaction) return r;
            }
            catch (Throwable throwable) {
                if (!hasTransaction) throw throwable;
                txm.resume(transactionId);
                throw throwable;
            }
            txm.resume(transactionId);
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyRegion(ByteArrayWrapper key, RedisDataType type) {
        Region<Object, Object> r = this.regions.get(key);
        if (r != null) {
            try {
                r.destroyRegion();
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.removeRegionState(key, type);
            }
        }
        return true;
    }

    private void removeRegionState(ByteArrayWrapper key, RedisDataType type) {
        this.preparedQueries.remove(key);
        this.regions.remove(key);
    }

    private void doInitializeSortedSet(ByteArrayWrapper key, Region<?, ?> r) throws RegionNotFoundException, IndexInvalidException {
        String fullpath = r.getFullPath();
        try {
            this.queryService.createIndex("scoreIndex", "entry.value.score", r.getFullPath() + ".entrySet entry");
            this.queryService.createIndex("scoreIndex2", "value.score", r.getFullPath() + ".values value");
        }
        catch (UnsupportedOperationException | IndexExistsException | IndexNameConflictException throwable) {
            // empty catch block
        }
        HashMap<SortedSetQuery, Query> queryList = new HashMap<SortedSetQuery, Query>();
        for (SortedSetQuery lq : SortedSetQuery.values()) {
            String queryString = lq.getQueryString(fullpath);
            Query query = this.queryService.newQuery(queryString);
            queryList.put(lq, query);
        }
        this.preparedQueries.put(key, queryList);
    }

    private void doInitializeList(ByteArrayWrapper key, Region<Object, Object> r) {
        r.put((Object)"head", (Object)0);
        r.put((Object)"tail", (Object)0);
        String fullpath = r.getFullPath();
        HashMap<ListQuery, Query> queryList = new HashMap<ListQuery, Query>();
        for (ListQuery lq : ListQuery.values()) {
            String queryString = lq.getQueryString(fullpath);
            Query query = this.queryService.newQuery(queryString);
            queryList.put(lq, query);
        }
        this.preparedQueries.put(key, queryList);
    }

    private Region<Object, Object> createRegionGlobally(String regionPath) {
        Region r = this.cache.getRegion(regionPath);
        if (r != null) {
            return r;
        }
        do {
            createRegionCmd.setCache(this.cache);
            ResultModel resultModel = createRegionCmd.createRegion(regionPath, this.defaultRegionType, null, null, true, null, null, null, null, null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, null);
            r = this.cache.getRegion(regionPath);
            if (resultModel.getStatus() != Result.Status.ERROR || r != null) continue;
            String err = "Unable to create region named \"" + regionPath + "\":\n";
            throw new RegionCreationException(err + resultModel.toJson());
        } while (r == null);
        return r;
    }

    public Query getQuery(ByteArrayWrapper key, Enum<?> query) {
        return (Query)((Map)this.preparedQueries.get(key)).get(query);
    }

    public boolean regionExists(ByteArrayWrapper key) {
        return this.regions.containsKey(key);
    }

    public Region<ByteArrayWrapper, ByteArrayWrapper> getStringsRegion() {
        return this.stringsRegion;
    }

    public Region<ByteArrayWrapper, Map<ByteArrayWrapper, ByteArrayWrapper>> getHashRegion() {
        return this.hashRegion;
    }

    public Region<ByteArrayWrapper, DeltaSet> getSetRegion() {
        return this.setRegion;
    }

    public Region<ByteArrayWrapper, HyperLogLogPlus> gethLLRegion() {
        return this.hLLRegion;
    }

    public boolean setExpiration(ByteArrayWrapper key, long delay) {
        RedisDataType type = this.keyRegistrar.getType(key);
        if (type == null) {
            return false;
        }
        ScheduledFuture<?> future = this.expirationExecutor.schedule(new ExpirationExecutor(key, type, this), delay, TimeUnit.MILLISECONDS);
        this.expirationsMap.put(key, future);
        return true;
    }

    public boolean modifyExpiration(ByteArrayWrapper key, long delay) {
        boolean canceled = this.cancelKeyExpiration(key);
        if (!canceled) {
            return false;
        }
        RedisDataType type = this.keyRegistrar.getType(key);
        if (type == null) {
            return false;
        }
        ScheduledFuture<?> future = this.expirationExecutor.schedule(new ExpirationExecutor(key, type, this), delay, TimeUnit.MILLISECONDS);
        this.expirationsMap.put(key, future);
        return true;
    }

    public boolean cancelKeyExpiration(ByteArrayWrapper key) {
        ScheduledFuture future = (ScheduledFuture)this.expirationsMap.remove(key);
        if (future == null) {
            return false;
        }
        return future.cancel(false);
    }

    private boolean removeKeyExpiration(ByteArrayWrapper key) {
        return this.expirationsMap.remove(key) != null;
    }

    public boolean hasExpiration(ByteArrayWrapper key) {
        return this.expirationsMap.containsKey(key);
    }

    public long getExpirationDelayMillis(ByteArrayWrapper key) {
        ScheduledFuture future = (ScheduledFuture)this.expirationsMap.get(key);
        return future != null ? future.getDelay(TimeUnit.MILLISECONDS) : 0L;
    }

    @Override
    public void close() {
        this.preparedQueries.clear();
    }

    public String dumpRegionsCache() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<ByteArrayWrapper, Region<Object, Object>> e : this.regions.entrySet()) {
            builder.append(e.getKey()).append(" --> {").append(e.getValue()).append("}\n");
        }
        return builder.toString();
    }
}

