/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class ExpireAtExecutor
extends AbstractExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long currentTimeMillis;
        long timestamp;
        List<byte[]> commandElems = command.getProcessedCommand();
        int SET = 1;
        int NOT_SET = 0;
        int TIMESTAMP_INDEX = 2;
        if (commandElems.size() != 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        RegionProvider regionProvider = context.getRegionProvider();
        ByteArrayWrapper wKey = command.getKey();
        byte[] timestampByteArray = commandElems.get(TIMESTAMP_INDEX);
        try {
            timestamp = Coder.bytesToLong(timestampByteArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "value is not an integer or out of range"));
            return;
        }
        if (!this.timeUnitMillis()) {
            timestamp *= 1000L;
        }
        if (timestamp <= (currentTimeMillis = System.currentTimeMillis())) {
            int result = NOT_SET;
            RedisDataType redisDataType = context.getKeyRegistrar().getType(wKey);
            if (redisDataType != null) {
                regionProvider.getRegionForType(redisDataType).remove((Object)wKey);
                result = SET;
            }
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), result));
            return;
        }
        long delayMillis = timestamp - currentTimeMillis;
        boolean expirationSet = regionProvider.hasExpiration(wKey) ? regionProvider.modifyExpiration(wKey, delayMillis) : regionProvider.setExpiration(wKey, delayMillis);
        if (expirationSet) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), SET));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), NOT_SET));
        }
    }

    protected boolean timeUnitMillis() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the EXPIREAT command is \"EXPIREAT key timestamp\"";
    }
}

