/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import java.util.Map;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HGetExecutor
extends HashExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HGET command is \"HGET key field\""));
            return;
        }
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        ByteArrayWrapper key = command.getKey();
        Map<ByteArrayWrapper, ByteArrayWrapper> entry = this.getMap(context, key);
        if (entry == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        ByteArrayWrapper valueWrapper = entry.get(field);
        try {
            if (valueWrapper != null) {
                command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), valueWrapper.toBytes()));
            } else {
                command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            }
        }
        catch (CoderException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The server had an internal error please try again"));
        }
    }
}

