/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.executor.set.DeltaSet;
import org.apache.geode.redis.internal.executor.set.RedisSet;
import org.apache.geode.redis.internal.executor.set.SaddFunction;
import org.apache.geode.redis.internal.executor.set.SdelFunction;
import org.apache.geode.redis.internal.executor.set.SmembersFunction;
import org.apache.geode.redis.internal.executor.set.SremFunction;

public class GeodeRedisSetWithFunctions
implements RedisSet {
    private final ByteArrayWrapper key;
    private final Region<ByteArrayWrapper, DeltaSet> region;

    public GeodeRedisSetWithFunctions(ByteArrayWrapper key, Region<ByteArrayWrapper, DeltaSet> region) {
        this.key = key;
        this.region = region;
    }

    public static void registerFunctions() {
        FunctionService.registerFunction((Function)new SaddFunction());
        FunctionService.registerFunction((Function)new SremFunction());
        FunctionService.registerFunction((Function)new SmembersFunction());
        FunctionService.registerFunction((Function)new SdelFunction());
    }

    @Override
    public long sadd(ArrayList<ByteArrayWrapper> membersToAdd) {
        ResultCollector results = FunctionService.onRegion(this.region).withFilter(Collections.singleton(this.key)).setArguments(membersToAdd).execute("SADD_FUNCTION");
        return (Long)((List)results.getResult()).get(0);
    }

    @Override
    public long srem(ArrayList<ByteArrayWrapper> membersToRemove, AtomicBoolean setWasDeleted) {
        ResultCollector results = FunctionService.onRegion(this.region).withFilter(Collections.singleton(this.key)).setArguments(membersToRemove).execute("SREM_FUNCTION");
        List resultList = (List)results.getResult();
        long membersRemoved = (Long)resultList.get(0);
        long wasDeleted = (Long)resultList.get(1);
        if (wasDeleted != 0L) {
            setWasDeleted.set(true);
        }
        return membersRemoved;
    }

    @Override
    public Set<ByteArrayWrapper> members() {
        ResultCollector results = FunctionService.onRegion(this.region).withFilter(Collections.singleton(this.key)).execute("SMEMBERS_FUNCTION");
        return (Set)((List)results.getResult()).get(0);
    }

    @Override
    public boolean del() {
        ResultCollector results = FunctionService.onRegion(this.region).withFilter(Collections.singleton(this.key)).execute("SDEL_FUNCTION");
        return (Boolean)((List)results.getResult()).get(0);
    }
}

