/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import com.github.davidmoten.geo.LatLong;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.GeoCoder;
import org.apache.geode.redis.internal.MemberNotFoundException;
import org.apache.geode.redis.internal.RedisCommandParserException;

public class GeoRadiusParameters {
    final double lon;
    final double lat;
    final double radius;
    final String unit;
    final String member;
    final boolean withDist;
    final boolean withCoord;
    final boolean withHash;
    final Integer count;
    final SortOrder order;
    final Double distScale;
    final String centerHashPrecise;

    public GeoRadiusParameters(Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion, List<byte[]> commandElems, CommandType cmdType) throws IllegalArgumentException, RedisCommandParserException, MemberNotFoundException {
        String elem;
        int i;
        byte[] radArray;
        switch (cmdType) {
            case GEORADIUS: {
                byte[] lonArray = commandElems.get(2);
                byte[] latArray = commandElems.get(3);
                radArray = commandElems.get(4);
                this.unit = new String(commandElems.get(5));
                this.centerHashPrecise = GeoCoder.geohash(lonArray, latArray);
                this.lon = Coder.bytesToDouble(lonArray);
                this.lat = Coder.bytesToDouble(latArray);
                this.member = null;
                break;
            }
            default: {
                byte[] memberArray = commandElems.get(2);
                radArray = commandElems.get(3);
                this.unit = new String(commandElems.get(4));
                this.member = new String(memberArray);
                ByteArrayWrapper hashWrapper = (ByteArrayWrapper)keyRegion.get((Object)new ByteArrayWrapper(memberArray));
                if (hashWrapper == null) {
                    throw new MemberNotFoundException();
                }
                this.centerHashPrecise = hashWrapper.toString();
                LatLong pos = GeoCoder.geoPos(this.centerHashPrecise);
                this.lon = pos.getLon();
                this.lat = pos.getLat();
            }
        }
        this.distScale = GeoCoder.parseUnitScale(this.unit);
        this.radius = Coder.bytesToDouble(radArray) / this.distScale;
        boolean showDist = false;
        boolean showCoord = false;
        boolean showHash = false;
        for (i = cmdType == CommandType.GEORADIUS ? 6 : 5; i < commandElems.size() && new String(commandElems.get(i)).contains("with"); ++i) {
            elem = new String(commandElems.get(i));
            if (elem.equals("withdist")) {
                showDist = true;
            }
            if (elem.equals("withcoord")) {
                showCoord = true;
            }
            if (!elem.equals("withhash")) continue;
            showHash = true;
        }
        this.withDist = showDist;
        this.withCoord = showCoord;
        this.withHash = showHash;
        if (i < commandElems.size() && new String(commandElems.get(i)).equals("count")) {
            this.count = Coder.bytesToInt(commandElems.get(++i));
            ++i;
        } else {
            this.count = null;
        }
        this.order = i < commandElems.size() && new String(commandElems.get(i)).contains("sc") ? ((elem = new String(commandElems.get(i++))).equals("asc") ? SortOrder.ASC : (elem.equals("desc") ? SortOrder.DESC : SortOrder.UNSORTED)) : SortOrder.UNSORTED;
        if (i < commandElems.size()) {
            throw new RedisCommandParserException();
        }
    }

    public static enum SortOrder {
        ASC,
        DESC,
        UNSORTED;

    }

    public static enum CommandType {
        GEORADIUS,
        GEORADIUSBYMEMBER;

    }
}

