/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.LocatorAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.state.TerminateConnection;

@Experimental
public class GetServerOperationHandler
implements ProtobufOperationHandler<LocatorAPI.GetServerRequest, LocatorAPI.GetServerResponse> {
    @Override
    public Result<LocatorAPI.GetServerResponse> process(ProtobufSerializationService serializationService, LocatorAPI.GetServerRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        HashSet<ServerLocation> excludedServers = new HashSet<ServerLocation>();
        List<BasicTypes.Server> excludedServersList = request.getExcludedServersList();
        for (BasicTypes.Server server : excludedServersList) {
            excludedServers.add(new ServerLocation(server.getHostname(), server.getPort()));
        }
        String serverGroup = request.getServerGroup();
        messageExecutionContext.setState(new TerminateConnection());
        ServerLocation serverLocation = messageExecutionContext.getSecureLocator().findServer(excludedServers, serverGroup);
        if (serverLocation == null) {
            StringBuilder builder = new StringBuilder("Unable to find a server");
            if (!Objects.isNull(serverGroup) && !serverGroup.isEmpty()) {
                builder.append(" in server group ");
                builder.append(serverGroup);
            }
            return Failure.of(BasicTypes.ErrorCode.NO_AVAILABLE_SERVER, builder.toString());
        }
        LocatorAPI.GetServerResponse.Builder builder = LocatorAPI.GetServerResponse.newBuilder();
        BasicTypes.Server.Builder serverBuilder = BasicTypes.Server.newBuilder();
        serverBuilder.setHostname(serverLocation.getHostName()).setPort(serverLocation.getPort());
        BasicTypes.Server server = serverBuilder.build();
        builder.setServer(server);
        return Success.of(builder.build());
    }
}

