/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.HasMemberID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;

public class RemoveMemberMessage<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID>
implements HasMemberID<ID> {
    private ID memberID;
    private String reason;

    public RemoveMemberMessage(ID recipient, ID id, String reason) {
        this.setRecipient(recipient);
        this.memberID = id;
        this.reason = reason;
    }

    public RemoveMemberMessage(List<ID> recipients, ID id, String reason) {
        this.setRecipients(recipients);
        this.memberID = id;
        this.reason = reason;
    }

    public RemoveMemberMessage() {
    }

    public int getDSFID() {
        return -153;
    }

    @Override
    public ID getMemberID() {
        return this.memberID;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + "; reason=" + this.reason + ")";
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        context.getSerializer().writeObject(this.memberID, out);
        StaticSerialization.writeString((String)this.reason, (DataOutput)out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.memberID = (MemberIdentifier)context.getDeserializer().readObject(in);
        this.reason = StaticSerialization.readString((DataInput)in);
    }
}

