/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledComparison;
import org.apache.geode.cache.query.internal.CompiledJunction;
import org.apache.geode.cache.query.internal.CompiledLiteral;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.cache.query.types.ObjectType;

public class DerivedInfo {
    public Map<String, SelectResults> derivedResults;
    public List<Object[]> newDerivatives;
    public List successfulOps = new LinkedList();
    public List originalOps;
    public CompiledValue currentOp;
    private List expansionList;

    public DerivedInfo() {
        this.derivedResults = new HashMap<String, SelectResults>();
        this.newDerivatives = new ArrayList<Object[]>();
    }

    public List getExpansionList() {
        return this.expansionList;
    }

    public void setExpansionList(List expansionList) {
        this.expansionList = expansionList;
    }

    public void setOriginalOps(List opsList) {
        this.originalOps = new LinkedList(opsList);
    }

    public List getRemainingOps() {
        LinkedList remainingOps = new LinkedList(this.originalOps);
        remainingOps.removeAll(this.successfulOps);
        return remainingOps;
    }

    public void addDerivedResults(IndexInfo indexInfo, SelectResults selectResults) {
        IndexProtocol index = indexInfo._index;
        String key = QueryUtils.getCompiledIdFromPath(indexInfo._path).getId() + ":" + index.getCanonicalizedIteratorDefinitions()[0];
        if (this.derivedResults.containsKey(key)) {
            for (Object result : selectResults) {
                if (this.derivedResults.get(key).contains(result)) continue;
                this.derivedResults.get(key).add(result);
            }
        } else {
            this.derivedResults.put(key, selectResults);
        }
        this.newDerivatives.add(new Object[]{QueryUtils.getCompiledIdFromPath(indexInfo._path).getId(), selectResults});
        this.successfulOps.add(this.currentOp);
    }

    public void addDerivedResults(IndexInfo indexInfo, SelectResults[] srs) {
        this.addDerivedResults(indexInfo, srs[0]);
    }

    public void computeDerivedJoinResults(IndexInfo theCallingIndex, ExecutionContext context, CompiledValue iterOps) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (theCallingIndex != null && iterOps != null) {
            if (iterOps instanceof CompiledJunction) {
                List opsList = ((CompiledJunction)iterOps).getOperands();
                this.setOriginalOps(opsList);
                this.createDerivedJoinResultsFromOpsList(QueryUtils.getCompiledIdFromPath(theCallingIndex._path).getId(), context, opsList);
            } else if (iterOps.getType() == -1) {
                this.createDerivedJoinResultsFromCC(QueryUtils.getCompiledIdFromPath(theCallingIndex._path).getId(), (CompiledComparison)iterOps, context);
            }
        }
    }

    private void createDerivedJoinResultsFromOpsList(String theCallingIndexId, ExecutionContext context, List opsList) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Iterator iter = opsList.iterator();
        while (iter.hasNext()) {
            CompiledValue cv;
            this.currentOp = cv = (CompiledValue)iter.next();
            if (cv.getType() != -1) continue;
            this.createDerivedJoinResultsFromCC(theCallingIndexId, (CompiledComparison)cv, context);
        }
        ArrayList<Object[]> newDerivatives = new ArrayList<Object[]>(this.newDerivatives);
        this.newDerivatives.clear();
        if (newDerivatives.size() > 0) {
            for (Object[] idDerivedAndResults : newDerivatives) {
                this.derivedDerivative(idDerivedAndResults, context, this.getExpansionList());
            }
        }
    }

    private void derivedDerivative(Object[] idDerivedAndResults, ExecutionContext context, List expansionList) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        String idDerived = (String)idDerivedAndResults[0];
        SelectResults results = (SelectResults)idDerivedAndResults[1];
        RuntimeIterator ritr = this.getMatchingRuntimeIterator(idDerived, expansionList);
        List remainingOps = this.getRemainingOps();
        for (Object val : results) {
            ritr.setCurrent(val);
            this.createDerivedJoinResultsFromOpsList(idDerived, context, remainingOps);
        }
    }

    private RuntimeIterator getMatchingRuntimeIterator(String receiverId, List expansionList) throws QueryInvocationTargetException {
        for (RuntimeIterator ritr : expansionList) {
            if (!ritr.getCmpIteratorDefn().getName().equals(receiverId)) continue;
            return ritr;
        }
        throw new QueryInvocationTargetException("Unable to locate correct iterator for " + receiverId);
    }

    private void createDerivedJoinResultsFromCC(String theCallingIndexReceiverId, CompiledComparison cc, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.isCompiledPath(cc._right) && this.matchingPathIds(theCallingIndexReceiverId, cc._left)) {
            this.evaluateDerivedJoin(context, cc._right, new CompiledLiteral(cc._left.evaluate(context)), cc.getOperator());
        } else if (this.isCompiledPath(cc._left) && this.matchingPathIds(theCallingIndexReceiverId, cc._right)) {
            this.evaluateDerivedJoin(context, cc._left, new CompiledLiteral(cc._right.evaluate(context)), cc.getOperator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateDerivedJoin(ExecutionContext context, CompiledValue newLeftSide, CompiledValue newRightSide, int operator) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        CompiledComparison dcc = this.createDerivedJoin(context, newLeftSide, newRightSide, operator);
        IndexInfo[] indexInfos = dcc.getIndexInfo(context);
        try {
            if (indexInfos != null && this.isValidIndexTypeToDerive(indexInfos[0]._getIndex())) {
                this.populateDerivedResultsFromDerivedJoin(context, dcc, indexInfos[0]);
            }
        }
        finally {
            if (indexInfos != null) {
                IndexProtocol index = indexInfos[0]._index;
                Index prIndex = ((AbstractIndex)index).getPRIndex();
                if (prIndex != null) {
                    ((PartitionedIndex)prIndex).releaseIndexReadLockForRemove();
                } else {
                    ((AbstractIndex)index).releaseIndexReadLockForRemove();
                }
            }
        }
    }

    private void populateDerivedResultsFromDerivedJoin(ExecutionContext context, CompiledComparison dcc, IndexInfo indexInfo) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Boolean originalCanApplyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index");
        context.cachePut("can_apply_limit_at_index", Boolean.FALSE);
        Boolean originalCanApplyOrderBy = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        context.cachePut("can_apply_orderby_at_index", Boolean.FALSE);
        SelectResults sr = dcc.filterEvaluate(context, null, false, null, null, false, false, false);
        context.cachePut("can_apply_limit_at_index", originalCanApplyLimit);
        context.cachePut("can_apply_orderby_at_index", originalCanApplyOrderBy);
        ObjectType ot = indexInfo._index.getResultSetType();
        if (!(ot.isStructType() || ot.isMapType() || ot.isCollectionType())) {
            this.addDerivedResults(dcc.getIndexInfo(context)[0], sr);
        }
    }

    private boolean isValidIndexTypeToDerive(IndexProtocol index) {
        ObjectType type = index.getResultSetType();
        return !type.isCollectionType() && !type.isMapType() && !type.isStructType();
    }

    private CompiledComparison createDerivedJoin(ExecutionContext context, CompiledValue newLeft, CompiledValue newRight, int op) throws TypeMismatchException, NameResolutionException {
        CompiledComparison cc = new CompiledComparison(newLeft, newRight, op);
        cc.computeDependencies(context);
        return cc;
    }

    private boolean matchingPathIds(String receiverId, CompiledValue cv) {
        if (this.isCompiledPath(cv)) {
            CompiledPath path = (CompiledPath)cv;
            return receiverId.equals(QueryUtils.getCompiledIdFromPath(path).getId());
        }
        return false;
    }

    private boolean isCompiledPath(CompiledValue cv) {
        return cv.getType() == -5;
    }
}

