/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.FunctionExecutionPooledExecutor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.OperationExecutors;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.distributed.internal.ThrottlingMemLinkedQueueWithDMStats;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.logging.CoreLoggingExecutors;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.ThreadsMonitoringImpl;
import org.apache.geode.internal.monitoring.ThreadsMonitoringImplDummy;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClusterOperationExecutors
implements OperationExecutors {
    private static final Logger logger = LogService.getLogger();
    static final int MAX_STOP_TIME = 20000;
    static final int STOP_PAUSE_TIME = 1000;
    private static final boolean MULTI_SERIAL_EXECUTORS = !Boolean.getBoolean("DistributionManager.singleSerialExecutor");
    private static final int MAX_WAITING_THREADS = Integer.getInteger("DistributionManager.MAX_WAITING_THREADS", Integer.MAX_VALUE);
    private static final int MAX_PR_META_DATA_CLEANUP_THREADS = Integer.getInteger("DistributionManager.MAX_PR_META_DATA_CLEANUP_THREADS", 1);
    private static final int MAX_PR_THREADS = Integer.getInteger("DistributionManager.MAX_PR_THREADS", Math.max(Runtime.getRuntime().availableProcessors() * 32, 200));
    private static final int INCOMING_QUEUE_LIMIT = Integer.getInteger("DistributionManager.INCOMING_QUEUE_LIMIT", 80000);
    private static final double THROTTLE_PERCENT = (double)Integer.getInteger("DistributionManager.SERIAL_QUEUE_THROTTLE_PERCENT", 75).intValue() / 100.0;
    private static final int SERIAL_QUEUE_BYTE_LIMIT = Integer.getInteger("DistributionManager.SERIAL_QUEUE_BYTE_LIMIT", 0x2800000);
    private static final int SERIAL_QUEUE_THROTTLE = Integer.getInteger("DistributionManager.SERIAL_QUEUE_THROTTLE", (int)((double)SERIAL_QUEUE_BYTE_LIMIT * THROTTLE_PERCENT));
    private static final int TOTAL_SERIAL_QUEUE_BYTE_LIMIT = Integer.getInteger("DistributionManager.TOTAL_SERIAL_QUEUE_BYTE_LIMIT", 0x5000000);
    private static final int TOTAL_SERIAL_QUEUE_THROTTLE = Integer.getInteger("DistributionManager.TOTAL_SERIAL_QUEUE_THROTTLE", (int)((double)SERIAL_QUEUE_BYTE_LIMIT * THROTTLE_PERCENT));
    private static final int SERIAL_QUEUE_SIZE_LIMIT = Integer.getInteger("DistributionManager.SERIAL_QUEUE_SIZE_LIMIT", 20000);
    private static final int SERIAL_QUEUE_SIZE_THROTTLE = Integer.getInteger("DistributionManager.SERIAL_QUEUE_SIZE_THROTTLE", (int)((double)SERIAL_QUEUE_SIZE_LIMIT * THROTTLE_PERCENT));
    private static final int MAX_SERIAL_QUEUE_THREAD = Integer.getInteger("DistributionManager.MAX_SERIAL_QUEUE_THREAD", 20);
    public static final int VIEW_EXECUTOR = 79;
    private InternalDistributedSystem system;
    private DistributionStats stats;
    private ExecutorService threadPool;
    private ExecutorService highPriorityPool;
    private ExecutorService waitingPool;
    private ExecutorService prMetaDataCleanupThreadPool;
    private ExecutorService partitionedRegionThread;
    private ExecutorService partitionedRegionPool;
    private ExecutorService functionExecutionThread;
    private ExecutorService functionExecutionPool;
    private ExecutorService serialThread;
    private ThrottlingMemLinkedQueueWithDMStats<Runnable> serialQueue;
    private ThreadsMonitoring threadMonitor;
    private SerialQueuedExecutorPool serialQueuedExecutorPool;

    ClusterOperationExecutors(DistributionStats stats, InternalDistributedSystem system) {
        AbstractQueue poolQueue;
        this.stats = stats;
        this.system = system;
        DistributionConfig config = system.getConfig();
        ThreadsMonitoring threadsMonitoring = this.threadMonitor = config.getThreadMonitorEnabled() ? new ThreadsMonitoringImpl(system) : new ThreadsMonitoringImplDummy();
        if (MULTI_SERIAL_EXECUTORS) {
            if (logger.isInfoEnabled(LogMarker.DM_MARKER)) {
                logger.info(LogMarker.DM_MARKER, "Serial Queue info : THROTTLE_PERCENT: " + THROTTLE_PERCENT + " SERIAL_QUEUE_BYTE_LIMIT :" + SERIAL_QUEUE_BYTE_LIMIT + " SERIAL_QUEUE_THROTTLE :" + SERIAL_QUEUE_THROTTLE + " TOTAL_SERIAL_QUEUE_BYTE_LIMIT :" + TOTAL_SERIAL_QUEUE_BYTE_LIMIT + " TOTAL_SERIAL_QUEUE_THROTTLE :" + TOTAL_SERIAL_QUEUE_THROTTLE + " SERIAL_QUEUE_SIZE_LIMIT :" + SERIAL_QUEUE_SIZE_LIMIT + " SERIAL_QUEUE_SIZE_THROTTLE :" + SERIAL_QUEUE_SIZE_THROTTLE);
            }
            boolean throttlingDisabled = system.getConfig().getDisableTcp();
            this.serialQueuedExecutorPool = new SerialQueuedExecutorPool(stats, throttlingDisabled, this.threadMonitor);
        }
        if (SERIAL_QUEUE_BYTE_LIMIT == 0) {
            poolQueue = new OverflowQueueWithDMStats<Runnable>(stats.getSerialQueueHelper());
        } else {
            this.serialQueue = new ThrottlingMemLinkedQueueWithDMStats(TOTAL_SERIAL_QUEUE_BYTE_LIMIT, TOTAL_SERIAL_QUEUE_THROTTLE, SERIAL_QUEUE_SIZE_LIMIT, SERIAL_QUEUE_SIZE_THROTTLE, stats.getSerialQueueHelper());
            poolQueue = this.serialQueue;
        }
        this.serialThread = CoreLoggingExecutors.newSerialThreadPool("Serial Message Processor", thread -> stats.incSerialThreadStarts(), this::doSerialThread, stats.getSerialProcessorHelper(), this.threadMonitor, poolQueue);
        this.threadPool = CoreLoggingExecutors.newThreadPoolWithFeedStatistics("Pooled Message Processor ", thread -> stats.incProcessingThreadStarts(), this::doProcessingThread, MAX_THREADS, stats.getNormalPoolHelper(), this.threadMonitor, INCOMING_QUEUE_LIMIT, stats.getOverflowQueueHelper());
        this.highPriorityPool = CoreLoggingExecutors.newThreadPoolWithFeedStatistics("Pooled High Priority Message Processor ", thread -> stats.incHighPriorityThreadStarts(), this::doHighPriorityThread, MAX_THREADS, stats.getHighPriorityPoolHelper(), this.threadMonitor, INCOMING_QUEUE_LIMIT, stats.getHighPriorityQueueHelper());
        poolQueue = MAX_WAITING_THREADS == Integer.MAX_VALUE ? new SynchronousQueue() : new OverflowQueueWithDMStats(stats.getWaitingQueueHelper());
        this.waitingPool = CoreLoggingExecutors.newThreadPool("Pooled Waiting Message Processor ", thread -> stats.incWaitingThreadStarts(), this::doWaitingThread, MAX_WAITING_THREADS, stats.getWaitingPoolHelper(), this.threadMonitor, poolQueue);
        this.prMetaDataCleanupThreadPool = CoreLoggingExecutors.newThreadPoolWithFeedStatistics("PrMetaData cleanup Message Processor ", thread -> stats.incWaitingThreadStarts(), this::doWaitingThread, MAX_PR_META_DATA_CLEANUP_THREADS, stats.getWaitingPoolHelper(), this.threadMonitor, 0, stats.getWaitingQueueHelper());
        if (MAX_PR_THREADS > 1) {
            this.partitionedRegionPool = CoreLoggingExecutors.newThreadPoolWithFeedStatistics("PartitionedRegion Message Processor", thread -> stats.incPartitionedRegionThreadStarts(), this::doPartitionRegionThread, MAX_PR_THREADS, stats.getPartitionedRegionPoolHelper(), this.threadMonitor, INCOMING_QUEUE_LIMIT, stats.getPartitionedRegionQueueHelper());
        } else {
            this.partitionedRegionThread = CoreLoggingExecutors.newSerialThreadPoolWithFeedStatistics("PartitionedRegion Message Processor", thread -> stats.incPartitionedRegionThreadStarts(), this::doPartitionRegionThread, stats.getPartitionedRegionPoolHelper(), this.threadMonitor, INCOMING_QUEUE_LIMIT, stats.getPartitionedRegionQueueHelper());
        }
        if (MAX_FE_THREADS > 1) {
            this.functionExecutionPool = CoreLoggingExecutors.newFunctionThreadPoolWithFeedStatistics("Function Execution Processor", thread -> stats.incFunctionExecutionThreadStarts(), this::doFunctionExecutionThread, MAX_FE_THREADS, stats.getFunctionExecutionPoolHelper(), this.threadMonitor, INCOMING_QUEUE_LIMIT, stats.getFunctionExecutionQueueHelper());
        } else {
            this.functionExecutionThread = CoreLoggingExecutors.newSerialThreadPoolWithFeedStatistics("Function Execution Processor", thread -> stats.incFunctionExecutionThreadStarts(), this::doFunctionExecutionThread, stats.getFunctionExecutionPoolHelper(), this.threadMonitor, INCOMING_QUEUE_LIMIT, stats.getFunctionExecutionQueueHelper());
        }
    }

    @Override
    public Executor getExecutor(int processorType, InternalDistributedMember sender) {
        switch (processorType) {
            case 73: {
                return this.getThreadPool();
            }
            case 74: {
                return this.getSerialExecutor(sender);
            }
            case 75: {
                return this.getHighPriorityThreadPool();
            }
            case 77: {
                return this.getWaitingThreadPool();
            }
            case 78: {
                return this.getPartitionedRegionExcecutor();
            }
            case 80: {
                return this.getFunctionExecutor();
            }
        }
        throw new InternalGemFireError(String.format("unknown processor type %s", processorType));
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Override
    public ExecutorService getHighPriorityThreadPool() {
        return this.highPriorityPool;
    }

    @Override
    public ExecutorService getWaitingThreadPool() {
        return this.waitingPool;
    }

    @Override
    public ExecutorService getPrMetaDataCleanupThreadPool() {
        return this.prMetaDataCleanupThreadPool;
    }

    private Executor getPartitionedRegionExcecutor() {
        if (this.partitionedRegionThread != null) {
            return this.partitionedRegionThread;
        }
        return this.partitionedRegionPool;
    }

    @Override
    public Executor getFunctionExecutor() {
        if (this.functionExecutionThread != null) {
            return this.functionExecutionThread;
        }
        return this.functionExecutionPool;
    }

    private Executor getSerialExecutor(InternalDistributedMember sender) {
        if (MULTI_SERIAL_EXECUTORS) {
            return this.serialQueuedExecutorPool.getThrottledSerialExecutor(sender);
        }
        return this.serialThread;
    }

    @Override
    public OverflowQueueWithDMStats<Runnable> getSerialQueue(InternalDistributedMember sender) {
        if (MULTI_SERIAL_EXECUTORS) {
            return this.serialQueuedExecutorPool.getSerialQueue(sender);
        }
        return this.serialQueue;
    }

    public ThreadsMonitoring getThreadMonitoring() {
        return this.threadMonitor;
    }

    private void doFunctionExecutionThread(Runnable command) {
        this.stats.incFunctionExecutionThreads(1);
        FunctionExecutionPooledExecutor.setIsFunctionExecutionThread(Boolean.TRUE);
        try {
            ConnectionTable.threadWantsSharedResources();
            this.runUntilShutdown(command);
        }
        finally {
            ConnectionTable.releaseThreadsSockets();
            this.stats.incFunctionExecutionThreads(-1);
            FunctionExecutionPooledExecutor.setIsFunctionExecutionThread(Boolean.FALSE);
        }
    }

    private void doProcessingThread(Runnable command) {
        this.stats.incNumProcessingThreads(1);
        try {
            ConnectionTable.threadWantsSharedResources();
            this.runUntilShutdown(command);
        }
        finally {
            ConnectionTable.releaseThreadsSockets();
            this.stats.incNumProcessingThreads(-1);
        }
    }

    private void doHighPriorityThread(Runnable command) {
        this.stats.incHighPriorityThreads(1);
        try {
            ConnectionTable.threadWantsSharedResources();
            this.runUntilShutdown(command);
        }
        finally {
            ConnectionTable.releaseThreadsSockets();
            this.stats.incHighPriorityThreads(-1);
        }
    }

    private void doWaitingThread(Runnable command) {
        this.stats.incWaitingThreads(1);
        try {
            ConnectionTable.threadWantsSharedResources();
            this.runUntilShutdown(command);
        }
        finally {
            ConnectionTable.releaseThreadsSockets();
            this.stats.incWaitingThreads(-1);
        }
    }

    private void doPartitionRegionThread(Runnable command) {
        this.stats.incPartitionedRegionThreads(1);
        try {
            ConnectionTable.threadWantsSharedResources();
            this.runUntilShutdown(command);
        }
        finally {
            ConnectionTable.releaseThreadsSockets();
            this.stats.incPartitionedRegionThreads(-1);
        }
    }

    private void doSerialThread(Runnable command) {
        this.stats.incNumSerialThreads(1);
        try {
            ConnectionTable.threadWantsSharedResources();
            this.runUntilShutdown(command);
        }
        finally {
            ConnectionTable.releaseThreadsSockets();
            this.stats.incNumSerialThreads(-1);
        }
    }

    private void runUntilShutdown(Runnable r) {
        try {
            r.run();
        }
        catch (CancelException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Caught shutdown exception", (Throwable)e);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (!this.system.isDisconnecting()) {
                logger.debug("Caught unusual exception during shutdown: {}", (Object)t.getMessage(), (Object)t);
            }
            logger.warn("Task failed with exception", t);
        }
    }

    void askThreadsToStop() {
        this.threadMonitor.close();
        ExecutorService es = this.serialThread;
        if (es != null) {
            es.shutdown();
        }
        if (this.serialQueuedExecutorPool != null) {
            this.serialQueuedExecutorPool.shutdown();
        }
        if ((es = this.functionExecutionThread) != null) {
            es.shutdown();
        }
        if ((es = this.functionExecutionPool) != null) {
            es.shutdown();
        }
        if ((es = this.partitionedRegionThread) != null) {
            es.shutdown();
        }
        if ((es = this.partitionedRegionPool) != null) {
            es.shutdown();
        }
        if ((es = this.highPriorityPool) != null) {
            es.shutdown();
        }
        if ((es = this.waitingPool) != null) {
            es.shutdown();
        }
        if ((es = this.prMetaDataCleanupThreadPool) != null) {
            es.shutdown();
        }
        if ((es = this.threadPool) != null) {
            es.shutdown();
        }
    }

    void waitForThreadsToStop(long timeInMillis) throws InterruptedException {
        ExecutorService[] allExecutors;
        long start = System.currentTimeMillis();
        long remaining = timeInMillis;
        for (ExecutorService es : allExecutors = new ExecutorService[]{this.serialThread, this.functionExecutionThread, this.functionExecutionPool, this.partitionedRegionThread, this.partitionedRegionPool, this.highPriorityPool, this.waitingPool, this.prMetaDataCleanupThreadPool, this.threadPool}) {
            if (es != null) {
                es.awaitTermination(remaining, TimeUnit.MILLISECONDS);
            }
            if ((remaining = timeInMillis - (System.currentTimeMillis() - start)) > 0L) continue;
            return;
        }
        this.serialQueuedExecutorPool.awaitTermination(remaining, TimeUnit.MILLISECONDS);
    }

    private boolean executorAlive(ExecutorService tpe, String name) {
        if (tpe == null) {
            return false;
        }
        int ac = ((ThreadPoolExecutor)tpe).getActiveCount();
        if (ac > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Still waiting for {} threads in '{}' pool to exit", (Object)ac, (Object)name);
            }
            return true;
        }
        return false;
    }

    void forceThreadsToStop() {
        StringBuilder culprits;
        long endTime = System.currentTimeMillis() + 20000L;
        while (true) {
            boolean stillAlive = false;
            culprits = new StringBuilder();
            if (this.executorAlive(this.serialThread, "serial thread")) {
                stillAlive = true;
                culprits.append(" serial thread;");
            }
            if (this.executorAlive(this.partitionedRegionThread, "partitioned region thread")) {
                stillAlive = true;
                culprits.append(" partitioned region thread;");
            }
            if (this.executorAlive(this.partitionedRegionPool, "partitioned region pool")) {
                stillAlive = true;
                culprits.append(" partitioned region pool;");
            }
            if (this.executorAlive(this.highPriorityPool, "high priority pool")) {
                stillAlive = true;
                culprits.append(" high priority pool;");
            }
            if (this.executorAlive(this.waitingPool, "waiting pool")) {
                stillAlive = true;
                culprits.append(" waiting pool;");
            }
            if (this.executorAlive(this.prMetaDataCleanupThreadPool, "prMetaDataCleanupThreadPool")) {
                stillAlive = true;
                culprits.append(" special waiting pool;");
            }
            if (this.executorAlive(this.threadPool, "thread pool")) {
                stillAlive = true;
                culprits.append(" thread pool;");
            }
            if (!stillAlive) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now >= endTime) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted during shutdown", (Throwable)e);
                break;
            }
        }
        logger.warn("Daemon threads are slow to stop; culprits include: {}", (Object)culprits);
        if (this.serialThread != null) {
            this.serialThread.shutdownNow();
        }
        if (this.functionExecutionThread != null) {
            this.functionExecutionThread.shutdownNow();
        }
        if (this.functionExecutionPool != null) {
            this.functionExecutionPool.shutdownNow();
        }
        if (this.partitionedRegionThread != null) {
            this.partitionedRegionThread.shutdownNow();
        }
        if (this.partitionedRegionPool != null) {
            this.partitionedRegionPool.shutdownNow();
        }
        if (this.highPriorityPool != null) {
            this.highPriorityPool.shutdownNow();
        }
        if (this.waitingPool != null) {
            this.waitingPool.shutdownNow();
        }
        if (this.prMetaDataCleanupThreadPool != null) {
            this.prMetaDataCleanupThreadPool.shutdownNow();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }

    public void handleManagerDeparture(InternalDistributedMember theId) {
        if (this.serialQueuedExecutorPool != null) {
            this.serialQueuedExecutorPool.handleMemberDeparture(theId);
        }
    }

    private static class SerialQueuedExecutorPool {
        final ConcurrentMap<Integer, ExecutorService> serialQueuedExecutorMap = new ConcurrentHashMap<Integer, ExecutorService>(ClusterOperationExecutors.access$300());
        final Map<Integer, OverflowQueueWithDMStats<Runnable>> serialQueuedMap = new HashMap<Integer, OverflowQueueWithDMStats<Runnable>>(ClusterOperationExecutors.access$300());
        final Map<InternalDistributedMember, Integer> senderToSerialQueueIdMap = new HashMap<InternalDistributedMember, Integer>();
        final ArrayList<Integer> threadMarkedForUse = new ArrayList();
        final DistributionStats stats;
        final boolean throttlingDisabled;
        final ThreadsMonitoring threadMonitoring;

        SerialQueuedExecutorPool(DistributionStats stats, boolean throttlingDisabled, ThreadsMonitoring tMonitoring) {
            this.stats = stats;
            this.throttlingDisabled = throttlingDisabled;
            this.threadMonitoring = tMonitoring;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer getQueueId(InternalDistributedMember sender, boolean createNew) {
            Integer queueId;
            Map<InternalDistributedMember, Integer> map = this.senderToSerialQueueIdMap;
            synchronized (map) {
                queueId = this.senderToSerialQueueIdMap.get(sender);
                if (!createNew || queueId != null) {
                    return queueId;
                }
                if (!this.threadMarkedForUse.isEmpty()) {
                    queueId = this.threadMarkedForUse.remove(0);
                }
                if (queueId == null) {
                    queueId = (this.serialQueuedExecutorMap.size() + 1) % MAX_SERIAL_QUEUE_THREAD;
                }
                this.senderToSerialQueueIdMap.put(sender, queueId);
            }
            return queueId;
        }

        OverflowQueueWithDMStats<Runnable> getSerialQueue(InternalDistributedMember sender) {
            Integer queueId = this.getQueueId(sender, false);
            if (queueId == null) {
                return null;
            }
            return this.serialQueuedMap.get(queueId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExecutorService getThrottledSerialExecutor(InternalDistributedMember sender) {
            ExecutorService executor = this.getSerialExecutor(sender);
            long totalSerialQueueMemSize = this.stats.getInternalSerialQueueBytes();
            if (this.stats.getInternalSerialQueueBytes() > (long)TOTAL_SERIAL_QUEUE_THROTTLE && !DistributionMessage.isMembershipMessengerThread()) {
                do {
                    boolean interrupted = Thread.interrupted();
                    try {
                        float throttlePercent = (float)(totalSerialQueueMemSize - (long)TOTAL_SERIAL_QUEUE_THROTTLE) / (float)(TOTAL_SERIAL_QUEUE_BYTE_LIMIT - TOTAL_SERIAL_QUEUE_THROTTLE);
                        int sleep = (int)(100.0 * (double)throttlePercent);
                        sleep = Math.max(sleep, 1);
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.stats.getSerialQueueHelper().incThrottleCount();
                } while (this.stats.getInternalSerialQueueBytes() >= (long)TOTAL_SERIAL_QUEUE_BYTE_LIMIT);
            }
            return executor;
        }

        ExecutorService getSerialExecutor(InternalDistributedMember sender) {
            Integer queueId = this.getQueueId(sender, true);
            ExecutorService executor = (ExecutorService)this.serialQueuedExecutorMap.get(queueId);
            if (executor != null) {
                return executor;
            }
            executor = this.createSerialExecutor(queueId);
            this.serialQueuedExecutorMap.put(queueId, executor);
            if (logger.isDebugEnabled()) {
                logger.debug("Created Serial Queued Executor With queueId {}. Total number of live Serial Threads :{}", (Object)queueId, (Object)this.serialQueuedExecutorMap.size());
            }
            this.stats.incSerialPooledThread();
            return executor;
        }

        private ExecutorService createSerialExecutor(Integer id) {
            OverflowQueueWithDMStats<Runnable> poolQueue = SERIAL_QUEUE_BYTE_LIMIT == 0 || this.throttlingDisabled ? new OverflowQueueWithDMStats<Runnable>(this.stats.getSerialQueueHelper()) : new ThrottlingMemLinkedQueueWithDMStats(SERIAL_QUEUE_BYTE_LIMIT, SERIAL_QUEUE_THROTTLE, SERIAL_QUEUE_SIZE_LIMIT, SERIAL_QUEUE_SIZE_THROTTLE, this.stats.getSerialQueueHelper());
            this.serialQueuedMap.put(id, poolQueue);
            return CoreLoggingExecutors.newSerialThreadPool("Pooled Serial Message Processor" + id + "-", thread -> this.stats.incSerialPooledThreadStarts(), this::doSerialPooledThread, this.stats.getSerialPooledProcessorHelper(), this.threadMonitoring, poolQueue);
        }

        private void doSerialPooledThread(Runnable command) {
            ConnectionTable.threadWantsSharedResources();
            try {
                command.run();
            }
            finally {
                ConnectionTable.releaseThreadsSockets();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMemberDeparture(InternalDistributedMember member) {
            Integer queueId = this.getQueueId(member, false);
            if (queueId == null) {
                return;
            }
            boolean isUsed = false;
            Map<InternalDistributedMember, Integer> map = this.senderToSerialQueueIdMap;
            synchronized (map) {
                this.senderToSerialQueueIdMap.remove(member);
                for (Integer value : this.senderToSerialQueueIdMap.values()) {
                    if (!value.equals(queueId)) continue;
                    isUsed = true;
                    break;
                }
                if (!isUsed) {
                    if (logger.isInfoEnabled(LogMarker.DM_MARKER)) {
                        logger.info(LogMarker.DM_MARKER, "Marking the SerialQueuedExecutor with id : {} used by the member {} to be unused.", new Object[]{queueId, member});
                    }
                    this.threadMarkedForUse.add(queueId);
                }
            }
        }

        private void awaitTermination(long time, TimeUnit unit) throws InterruptedException {
            long remainingNanos = unit.toNanos(time);
            long start = System.nanoTime();
            for (ExecutorService executor : this.serialQueuedExecutorMap.values()) {
                executor.awaitTermination(remainingNanos, TimeUnit.NANOSECONDS);
                remainingNanos = System.nanoTime() - start;
                if (remainingNanos > 0L) continue;
                return;
            }
        }

        private void shutdown() {
            for (ExecutorService executor : this.serialQueuedExecutorMap.values()) {
                executor.shutdown();
            }
        }
    }
}

