/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.SystemConnectException;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.StartupMessageData;
import org.apache.geode.distributed.internal.StartupResponseWithVersionMessage;
import org.apache.geode.distributed.internal.membership.api.StopShunningMarker;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class StartupMessage
extends DistributionMessage
implements AdminMessageType,
StopShunningMarker {
    private static final Logger logger = LogService.getLogger();
    private String version = GemFireVersion.getGemFireVersion();
    private int replyProcessorId;
    private boolean isMcastEnabled;
    private boolean isTcpDisabled;
    private Set<InetAddress> interfaces;
    private int distributedSystemId;
    private String redundancyZone;
    private boolean enforceUniqueZone;
    private Collection<String> hostedLocatorsAll;
    boolean isSharedConfigurationEnabled;
    private int mcastPort;
    private String mcastHostAddress;
    private transient StringBuffer fromDataProblems;

    public static Set<InetAddress> getMyAddresses(ClusterDistributionManager dm) {
        try {
            return LocalHostUtil.getMyAddresses();
        }
        catch (IllegalArgumentException e) {
            logger.fatal(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public StartupMessage() {
    }

    StartupMessage(Collection<String> hostedLocators, boolean isSharedConfigurationEnabled) {
        this.hostedLocatorsAll = hostedLocators;
        this.isSharedConfigurationEnabled = isSharedConfigurationEnabled;
    }

    void setReplyProcessorId(int proc) {
        this.replyProcessorId = proc;
    }

    void setMcastEnabled(boolean flag) {
        this.isMcastEnabled = flag;
    }

    int getMcastPort() {
        return this.mcastPort;
    }

    void setMcastPort(int port) {
        this.mcastPort = port;
    }

    String getMcastHostAddress() {
        return this.mcastHostAddress;
    }

    void setMcastHostAddress(InetAddress addr) {
        String hostAddr = null;
        if (addr != null) {
            hostAddr = addr.getHostAddress();
        }
        this.mcastHostAddress = hostAddr;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    void setTcpDisabled(boolean flag) {
        this.isTcpDisabled = flag;
    }

    void setInterfaces(Set<InetAddress> interfaces) {
        this.interfaces = interfaces;
        if (interfaces == null || interfaces.size() == 0) {
            throw new SystemConnectException("Unable to examine network card");
        }
    }

    public void setDistributedSystemId(int distributedSystemId) {
        this.distributedSystemId = distributedSystemId;
    }

    public void setRedundancyZone(String redundancyZone) {
        this.redundancyZone = redundancyZone;
    }

    public void setEnforceUniqueZone(boolean enforceUniqueZone) {
        this.enforceUniqueZone = enforceUniqueZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        String rejectionMessage = null;
        boolean isAdminDM = false;
        boolean replySent = false;
        try {
            boolean bl = isAdminDM = dm.getId().getVmKind() == 12 || dm.getId().getVmKind() == 11;
            if (dm.getTransport().isMcastEnabled() != this.isMcastEnabled) {
                rejectionMessage = String.format("Rejected new system node %s because mcast was %s which does not match the distributed system it is attempting to join. To fix this make sure the mcast-port gemfire property is set the same on all members of the same distributed system.", this.getSender(), this.isMcastEnabled ? "enabled" : "disabled");
            } else if (this.isMcastEnabled && dm.getSystem().getOriginalConfig().getMcastPort() != this.getMcastPort()) {
                rejectionMessage = String.format("Rejected new system node %s because its mcast-port %s does not match the mcast-port %s of the distributed system it is attempting to join. To fix this make sure the mcast-port gemfire property is set the same on all members of the same distributed system.", this.getSender(), this.getMcastPort(), dm.getSystem().getOriginalConfig().getMcastPort());
            } else if (this.isMcastEnabled && !StartupMessage.checkMcastAddress(dm.getSystem().getOriginalConfig().getMcastAddress(), this.getMcastHostAddress())) {
                rejectionMessage = String.format("Rejected new system node %s because its mcast-address %s does not match the mcast-address %s of the distributed system it is attempting to join. To fix this make sure the mcast-address gemfire property is set the same on all members of the same distributed system.", this.getSender(), this.getMcastHostAddress(), dm.getSystem().getOriginalConfig().getMcastAddress());
            } else if (dm.getTransport().isTcpDisabled() != this.isTcpDisabled) {
                rejectionMessage = String.format("Rejected new system node %s because isTcpDisabled=%s does not match the distributed system it is attempting to join.", this.getSender(), this.isTcpDisabled);
            } else if (dm.getDistributedSystemId() != -1 && this.distributedSystemId != -1 && this.distributedSystemId != dm.getDistributedSystemId()) {
                String distributedSystemListener = System.getProperty("gemfire.DistributedSystemListener");
                if (distributedSystemListener != null) {
                    if (-this.distributedSystemId != dm.getDistributedSystemId()) {
                        rejectionMessage = String.format("Rejected new system node %s because distributed-system-id=%s does not match the distributed system %s it is attempting to join.", this.getSender(), this.distributedSystemId, dm.getDistributedSystemId());
                    }
                } else {
                    rejectionMessage = String.format("Rejected new system node %s because distributed-system-id=%s does not match the distributed system %s it is attempting to join.", this.getSender(), this.distributedSystemId, dm.getDistributedSystemId());
                }
            }
            if (this.fromDataProblems != null && logger.isDebugEnabled()) {
                logger.debug((CharSequence)this.fromDataProblems);
            }
            if (rejectionMessage == null) {
                if (this.interfaces == null || this.interfaces.size() == 0) {
                    String msg = "Rejected new system node %s because peer has no network interfaces";
                    rejectionMessage = String.format(msg, this.getSender());
                } else {
                    dm.setEquivalentHosts(this.interfaces);
                }
            }
            if (rejectionMessage != null) {
                logger.warn(rejectionMessage);
            }
            if (rejectionMessage == null) {
                dm.setRedundancyZone(this.getSender(), this.redundancyZone);
                dm.setEnforceUniqueZone(this.enforceUniqueZone);
                if (this.hostedLocatorsAll != null) {
                    dm.addHostedLocators(this.getSender(), this.hostedLocatorsAll, this.isSharedConfigurationEnabled);
                }
            }
            StartupResponseWithVersionMessage m = new StartupResponseWithVersionMessage(dm, this.replyProcessorId, this.getSender(), rejectionMessage, isAdminDM);
            if (logger.isDebugEnabled()) {
                logger.debug("Received StartupMessage from a member with version: {}, my version is:{}", (Object)this.version, (Object)GemFireVersion.getGemFireVersion());
            }
            dm.putOutgoing(m);
            replySent = true;
            if (rejectionMessage != null) {
                dm.getDistribution().startupMessageFailed(this.getSender(), rejectionMessage);
            }
            if (rejectionMessage != null) {
                dm.handleManagerDeparture(this.getSender(), false, rejectionMessage);
            }
        }
        catch (RuntimeException e) {
            ReplyMessage.send(this.getSender(), this.replyProcessorId, new ReplyException(e), (ReplySender)dm);
            replySent = true;
        }
        finally {
            if (!replySent && !dm.shutdownInProgress()) {
                ReplyMessage.send(this.getSender(), this.replyProcessorId, new ReplyException(new IllegalStateException("Unknown cause for response not being sent")), (ReplySender)dm);
            }
        }
    }

    private static boolean checkMcastAddress(InetAddress myMcastAddr, String otherMcastHostAddr) {
        String myMcastHostAddr = null;
        if (myMcastAddr != null) {
            myMcastHostAddr = myMcastAddr.getHostAddress();
        }
        if (StringUtils.equals((CharSequence)myMcastHostAddr, (CharSequence)otherMcastHostAddr)) {
            return true;
        }
        if (myMcastHostAddr == null) {
            return false;
        }
        return myMcastHostAddr.equals(otherMcastHostAddr);
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    public int getDSFID() {
        return 96;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.version, out);
        out.writeInt(this.replyProcessorId);
        out.writeBoolean(this.isMcastEnabled);
        out.writeBoolean(this.isTcpDisabled);
        InternalDataSerializer.SerializerAttributesHolder[] sahs = InternalDataSerializer.getSerializersForDistribution();
        out.writeInt(sahs.length);
        for (int i = 0; i < sahs.length; ++i) {
            DataSerializer.writeNonPrimitiveClassName(sahs[i].getClassName(), out);
            out.writeInt(sahs[i].getId());
        }
        Object[] insts = InternalInstantiator.getInstantiatorsForSerialization();
        out.writeInt(insts.length);
        for (int i = 0; i < insts.length; ++i) {
            int id;
            String instantiatedClassName;
            String instantiatorClassName;
            if (insts[i] instanceof Instantiator) {
                instantiatorClassName = ((Instantiator)insts[i]).getClass().getName();
                instantiatedClassName = ((Instantiator)insts[i]).getInstantiatedClass().getName();
                id = ((Instantiator)insts[i]).getId();
            } else {
                instantiatorClassName = ((InternalInstantiator.InstantiatorAttributesHolder)insts[i]).getInstantiatorClassName();
                instantiatedClassName = ((InternalInstantiator.InstantiatorAttributesHolder)insts[i]).getInstantiatedClassName();
                id = ((InternalInstantiator.InstantiatorAttributesHolder)insts[i]).getId();
            }
            DataSerializer.writeNonPrimitiveClassName(instantiatorClassName, out);
            DataSerializer.writeNonPrimitiveClassName(instantiatedClassName, out);
            out.writeInt(id);
        }
        context.getSerializer().writeObject(this.interfaces, out);
        out.writeInt(this.distributedSystemId);
        DataSerializer.writeString(this.redundancyZone, out);
        out.writeBoolean(this.enforceUniqueZone);
        StartupMessageData data = new StartupMessageData();
        data.writeHostedLocators(this.hostedLocatorsAll);
        data.writeIsSharedConfigurationEnabled(this.isSharedConfigurationEnabled);
        data.writeMcastPort(this.mcastPort);
        data.writeMcastHostAddress(this.mcastHostAddress);
        data.writeTo(out);
    }

    private void recordFromDataProblem(String s) {
        if (this.fromDataProblems == null) {
            this.fromDataProblems = new StringBuffer();
        }
        this.fromDataProblems.append(s);
        this.fromDataProblems.append("\n\n");
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.version = DataSerializer.readString(in);
        this.replyProcessorId = in.readInt();
        this.isMcastEnabled = in.readBoolean();
        this.isTcpDisabled = in.readBoolean();
        int serializerCount = in.readInt();
        for (int i = 0; i < serializerCount; ++i) {
            String cName = DataSerializer.readNonPrimitiveClassName(in);
            int id = in.readInt();
            try {
                if (cName == null) continue;
                InternalDataSerializer.register(cName, false, null, null, id);
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.recordFromDataProblem(String.format("IllegalArgumentException while registering a DataSerializer: %s", ex));
            }
        }
        int instantiatorCount = in.readInt();
        for (int i = 0; i < instantiatorCount; ++i) {
            String instantiatorClassName = DataSerializer.readNonPrimitiveClassName(in);
            String instantiatedClassName = DataSerializer.readNonPrimitiveClassName(in);
            int id = in.readInt();
            try {
                if (instantiatorClassName == null || instantiatedClassName == null) continue;
                InternalInstantiator.register(instantiatorClassName, instantiatedClassName, id, false);
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.recordFromDataProblem(String.format("IllegalArgumentException while registering an Instantiator: %s", ex));
            }
        }
        this.interfaces = (Set)context.getDeserializer().readObject(in);
        this.distributedSystemId = in.readInt();
        this.redundancyZone = DataSerializer.readString(in);
        this.enforceUniqueZone = in.readBoolean();
        StartupMessageData data = new StartupMessageData();
        data.readFrom(in);
        this.hostedLocatorsAll = data.readHostedLocators();
        this.isSharedConfigurationEnabled = data.readIsSharedConfigurationEnabled();
        this.mcastPort = data.readMcastPort();
        this.mcastHostAddress = data.readMcastHostAddress();
    }

    @Override
    public String toString() {
        return String.format("StartupMessage DM %s has started. processor, %s. with distributed system id : %s", this.getSender(), this.replyProcessorId, this.distributedSystemId);
    }
}

