/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import org.apache.geode.cache.snapshot.SnapshotFilter;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.cache.snapshot.ParallelSnapshotFileMapper;
import org.apache.geode.internal.cache.snapshot.RegionSnapshotServiceImpl;
import org.apache.geode.internal.cache.snapshot.SnapshotFileMapper;

public class SnapshotOptionsImpl<K, V>
implements SnapshotOptions<K, V> {
    private static final long serialVersionUID = 1L;
    private volatile SnapshotFilter<K, V> filter = null;
    private volatile boolean invokeCallbacks = false;
    private volatile boolean parallel;
    private volatile SnapshotFileMapper mapper;

    @Override
    public SnapshotOptions<K, V> setFilter(SnapshotFilter<K, V> filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public SnapshotFilter<K, V> getFilter() {
        return this.filter;
    }

    @Override
    public SnapshotOptions<K, V> invokeCallbacks(boolean invokeCallbacks) {
        this.invokeCallbacks = invokeCallbacks;
        return this;
    }

    @Override
    public boolean shouldInvokeCallbacks() {
        return this.invokeCallbacks;
    }

    @Override
    public SnapshotOptions<K, V> setParallelMode(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    @Override
    public boolean isParallelMode() {
        return this.parallel;
    }

    public SnapshotOptions<K, V> setMapper(SnapshotFileMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public SnapshotFileMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = this.isParallelMode() ? new ParallelSnapshotFileMapper() : RegionSnapshotServiceImpl.LOCAL_MAPPER;
        }
        return this.mapper;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SnapshotOptionsImpl@").append(System.identityHashCode(this)).append(": ").append("parallel=").append(this.parallel).append("; invokeCallbacks=").append(this.invokeCallbacks).append("; filter=").append(this.filter).append("; mapper=").append(this.mapper);
        return buf.toString();
    }
}

