/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

public class GetPDXTypeById
extends BaseCommand {
    @Immutable
    private static final GetPDXTypeById singleton = new GetPDXTypeById();

    public static Command getCommand() {
        return singleton;
    }

    private GetPDXTypeById() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException {
        PdxType type;
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx type by id request ({} parts) from {}", (Object)serverConnection.getName(), (Object)clientMessage.getNumberOfParts(), (Object)serverConnection.getSocketString());
        }
        if (!ServerConnection.allowInternalMessagesWithoutCredentials) {
            serverConnection.getAuthzRequest();
        }
        int pdxId = clientMessage.getPart(0).getInt();
        try {
            InternalCache cache = serverConnection.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            type = registry.getType(pdxId);
        }
        catch (Exception e) {
            GetPDXTypeById.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Message responseMsg = serverConnection.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(clientMessage.getTransactionId());
        responseMsg.addObjPart(type);
        responseMsg.send(serverConnection);
        serverConnection.setAsTrue(1);
    }
}

