/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.monitoring;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.ThreadsMonitoringProcess;
import org.apache.geode.internal.monitoring.executor.AbstractExecutor;
import org.apache.geode.internal.monitoring.executor.FunctionExecutionPooledExecutorGroup;
import org.apache.geode.internal.monitoring.executor.GatewaySenderEventProcessorGroup;
import org.apache.geode.internal.monitoring.executor.OneTaskOnlyExecutorGroup;
import org.apache.geode.internal.monitoring.executor.PooledExecutorGroup;
import org.apache.geode.internal.monitoring.executor.ScheduledThreadPoolExecutorWKAGroup;
import org.apache.geode.internal.monitoring.executor.SerialQueuedExecutorGroup;

public class ThreadsMonitoringImpl
implements ThreadsMonitoring {
    private final ConcurrentMap<Long, AbstractExecutor> monitorMap;
    private ThreadsMonitoringProcess tmProcess = null;
    private final Properties nonDefault = new Properties();
    private final DistributionConfigImpl distributionConfigImpl = new DistributionConfigImpl(this.nonDefault);
    private final Timer timer = new Timer("ThreadsMonitor", true);
    private boolean isClosed = false;

    public ThreadsMonitoringImpl(InternalDistributedSystem iDistributedSystem) {
        this.monitorMap = new ConcurrentHashMap<Long, AbstractExecutor>();
        this.setThreadsMonitoringProcess(iDistributedSystem);
    }

    public ConcurrentMap<Long, AbstractExecutor> getMonitorMap() {
        return this.monitorMap;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.tmProcess != null) {
            this.timer.cancel();
            this.tmProcess = null;
        }
        this.monitorMap.clear();
    }

    private void setThreadsMonitoringProcess(InternalDistributedSystem iDistributedSystem) {
        this.tmProcess = new ThreadsMonitoringProcess(this, iDistributedSystem);
        this.timer.schedule((TimerTask)this.tmProcess, 0L, (long)this.distributionConfigImpl.getThreadMonitorInterval());
    }

    public ThreadsMonitoringProcess getThreadsMonitoringProcess() {
        return this.tmProcess;
    }

    @Override
    public void updateThreadStatus() {
        AbstractExecutor executor = (AbstractExecutor)this.monitorMap.get(Thread.currentThread().getId());
        if (executor != null) {
            executor.setStartTime(System.currentTimeMillis());
        }
    }

    @Override
    public boolean startMonitor(ThreadsMonitoring.Mode mode) {
        AbstractExecutor absExtgroup;
        switch (mode) {
            case FunctionExecutor: {
                absExtgroup = new FunctionExecutionPooledExecutorGroup(this);
                break;
            }
            case PooledExecutor: {
                absExtgroup = new PooledExecutorGroup(this);
                break;
            }
            case SerialQueuedExecutor: {
                absExtgroup = new SerialQueuedExecutorGroup(this);
                break;
            }
            case OneTaskOnlyExecutor: {
                absExtgroup = new OneTaskOnlyExecutorGroup(this);
                break;
            }
            case ScheduledThreadExecutor: {
                absExtgroup = new ScheduledThreadPoolExecutorWKAGroup(this);
                break;
            }
            case AGSExecutor: {
                absExtgroup = new GatewaySenderEventProcessorGroup(this);
                break;
            }
            default: {
                return false;
            }
        }
        this.monitorMap.put(Thread.currentThread().getId(), absExtgroup);
        return true;
    }

    @Override
    public void endMonitor() {
        this.monitorMap.remove(Thread.currentThread().getId());
    }

    public Timer getTimer() {
        return this.timer;
    }
}

