/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.size;

import org.apache.geode.internal.size.ReflectionSingleObjectSizer;

public class WellKnownClassSizer {
    private static final int BYTE_ARRAY_OVERHEAD;
    private static final int STRING_OVERHEAD;

    public static int sizeof(Object o) {
        int size = 0;
        if (o instanceof byte[]) {
            size = BYTE_ARRAY_OVERHEAD + ((byte[])o).length;
        } else if (o instanceof String) {
            size = STRING_OVERHEAD + ((String)o).length() * 2;
        } else {
            return 0;
        }
        size = (int)ReflectionSingleObjectSizer.roundUpSize(size);
        return size;
    }

    static {
        try {
            ReflectionSingleObjectSizer objSizer = new ReflectionSingleObjectSizer();
            BYTE_ARRAY_OVERHEAD = (int)objSizer.sizeof(new byte[0], false);
            STRING_OVERHEAD = (int)(ReflectionSingleObjectSizer.sizeof(String.class) + objSizer.sizeof(new char[0], false));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

