/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import org.apache.geode.StatisticDescriptor;

public class StatisticDescriptorImpl
implements StatisticDescriptor {
    static final byte LONG = 6;
    static final byte DOUBLE = 8;
    private int INVALID_OFFSET;
    private final String name;
    private final byte typeCode;
    private final String description;
    private final String unit;
    private final boolean isCounter;
    private final boolean isLargerBetter;
    private int id;

    public static String getTypeCodeName(int code) {
        switch (code) {
            case 6: {
                return "long";
            }
            case 8: {
                return "double";
            }
        }
        throw new IllegalArgumentException(String.format("Unknown type code: %s", code));
    }

    public static Class<?> getTypeCodeClass(byte code) {
        switch (code) {
            case 6: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown type code: %s", code));
    }

    public static StatisticDescriptor createIntCounter(String name, String description, String units, boolean isLargerBetter) {
        return StatisticDescriptorImpl.createLongCounter(name, description, units, isLargerBetter);
    }

    public static StatisticDescriptor createLongCounter(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 6, description, units, true, isLargerBetter);
    }

    public static StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 8, description, units, true, isLargerBetter);
    }

    public static StatisticDescriptor createIntGauge(String name, String description, String units, boolean isLargerBetter) {
        return StatisticDescriptorImpl.createLongGauge(name, description, units, isLargerBetter);
    }

    public static StatisticDescriptor createLongGauge(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 6, description, units, false, isLargerBetter);
    }

    public static StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 8, description, units, false, isLargerBetter);
    }

    private StatisticDescriptorImpl(String name, byte typeCode, String description, String unit, boolean isCounter, boolean isLargerBetter) {
        this.id = this.INVALID_OFFSET = -1;
        this.name = name;
        this.typeCode = typeCode;
        this.description = description == null ? "" : description;
        this.unit = unit == null ? "" : unit;
        this.isCounter = isCounter;
        this.isLargerBetter = isLargerBetter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<?> getType() {
        return StatisticDescriptorImpl.getTypeCodeClass(this.typeCode);
    }

    @Override
    public boolean isCounter() {
        return this.isCounter;
    }

    @Override
    public boolean isLargerBetter() {
        return this.isLargerBetter;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public Number getNumberForRawBits(long bits) {
        switch (this.typeCode) {
            case 6: {
                return bits;
            }
            case 8: {
                return Double.longBitsToDouble(bits);
            }
        }
        throw new RuntimeException(String.format("unexpected stat descriptor type code: %s", this.typeCode));
    }

    public byte getTypeCode() {
        return this.typeCode;
    }

    void setId(int id) {
        this.id = id;
    }

    @Override
    public int compareTo(StatisticDescriptor o) {
        return this.getName().compareTo(o.getName());
    }

    public int checkLong() {
        if (this.typeCode != 6) {
            StringBuffer sb = new StringBuffer();
            sb.append("The statistic " + this.getName() + " with id ");
            sb.append(this.getId());
            sb.append(" is of type ");
            sb.append(StatisticDescriptorImpl.getTypeCodeName(this.getTypeCode()));
            sb.append(" and it was expected to be a long");
            throw new IllegalArgumentException(sb.toString());
        }
        return this.id;
    }

    public int checkDouble() {
        if (this.typeCode != 8) {
            throw new IllegalArgumentException(String.format("The statistic %s with id %s is of type %s and it was expected to be a double.", this.getName(), this.getId(), StatisticDescriptorImpl.getTypeCodeName(this.getTypeCode())));
        }
        return this.id;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof StatisticDescriptorImpl)) {
            return false;
        }
        StatisticDescriptorImpl other = (StatisticDescriptorImpl)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.isCounter() != other.isCounter()) {
            return false;
        }
        if (this.isLargerBetter() != other.isLargerBetter()) {
            return false;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (!this.getUnit().equals(other.getUnit())) {
            return false;
        }
        return this.getDescription().equals(other.getDescription());
    }
}

