/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.beans.stats.StatsAggregator;

public class GatewayReceiverClusterStatsMonitor {
    private static final String CREATE_REQUEST_RATE = "CreateRequestsRate";
    private static final String DESTROY_REQUEST_RATE = "DestroyRequestsRate";
    private static final String UPDATE_REQUEST_RATE = "UpdateRequestsRate";
    private static final String EVENTS_RECEIVED_RATE = "EventsReceivedRate";
    private StatsAggregator aggregator;
    private Map<String, Class<?>> typeMap = new HashMap();

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.aggregator.aggregate(newState, oldState);
    }

    public GatewayReceiverClusterStatsMonitor() {
        this.intTypeMap();
        this.aggregator = new StatsAggregator(this.typeMap);
    }

    private void intTypeMap() {
        this.typeMap.put(CREATE_REQUEST_RATE, Float.TYPE);
        this.typeMap.put(DESTROY_REQUEST_RATE, Float.TYPE);
        this.typeMap.put(UPDATE_REQUEST_RATE, Float.TYPE);
        this.typeMap.put(EVENTS_RECEIVED_RATE, Float.TYPE);
    }

    public float getGatewayReceiverCreateRequestsRate() {
        return this.aggregator.getFloatValue(CREATE_REQUEST_RATE).floatValue();
    }

    public float getGatewayReceiverDestroyRequestsRate() {
        return this.aggregator.getFloatValue(DESTROY_REQUEST_RATE).floatValue();
    }

    public float getGatewayReceiverUpdateRequestsRate() {
        return this.aggregator.getFloatValue(UPDATE_REQUEST_RATE).floatValue();
    }

    public float getGatewayReceiverEventsReceivedRate() {
        return this.aggregator.getFloatValue(EVENTS_RECEIVED_RATE).floatValue();
    }
}

