/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal;

import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqServiceStatistics;
import org.apache.geode.cache.query.cq.internal.CqServiceImpl;
import org.apache.geode.cache.query.internal.DefaultQueryService;

public class CqServiceStatisticsImpl
implements CqServiceStatistics {
    private CqServiceImpl cqService;

    CqServiceStatisticsImpl(CqServiceImpl cqs) {
        this.cqService = cqs;
    }

    @Override
    public long numCqsActive() {
        return this.cqService.getCqServiceVsdStats().getNumCqsActive();
    }

    @Override
    public long numCqsCreated() {
        return this.cqService.getCqServiceVsdStats().getNumCqsCreated();
    }

    @Override
    public long numCqsClosed() {
        return this.cqService.getCqServiceVsdStats().getNumCqsClosed();
    }

    @Override
    public long numCqsStopped() {
        return this.cqService.getCqServiceVsdStats().getNumCqsStopped();
    }

    @Override
    public long numCqsOnClient() {
        return this.cqService.getCqServiceVsdStats().getNumCqsOnClient();
    }

    @Override
    public long numCqsOnRegion(String regionName) {
        DefaultQueryService queryService = (DefaultQueryService)this.cqService.getInternalCache().getLocalQueryService();
        try {
            CqQuery[] cqs = queryService.getCqs(regionName);
            if (cqs != null) {
                return cqs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }
}

