/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementServiceTransport;
import org.apache.geode.management.api.CommandType;
import org.apache.geode.management.api.ConnectionConfig;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.HasFile;
import org.apache.geode.management.internal.RestTemplateResponseErrorHandler;
import org.apache.geode.management.runtime.OperationResult;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.apache.geode.util.internal.GeodeJsonMapper;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

@Experimental
public class RestTemplateClusterManagementServiceTransport
implements ClusterManagementServiceTransport {
    static final ResponseErrorHandler DEFAULT_ERROR_HANDLER = new RestTemplateResponseErrorHandler();
    private final RestTemplate restTemplate;
    private final ScheduledExecutorService longRunningStatusPollingThreadPool = Executors.newScheduledThreadPool(1);

    public RestTemplateClusterManagementServiceTransport(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.restTemplate.setErrorHandler(DEFAULT_ERROR_HANDLER);
        List<HttpMessageConverter<?>> messageConverters = restTemplate.getMessageConverters();
        MappingJackson2HttpMessageConverter jackson2HttpMessageConverter = messageConverters.stream().filter(MappingJackson2HttpMessageConverter.class::isInstance).map(MappingJackson2HttpMessageConverter.class::cast).findFirst().orElse(null);
        if (jackson2HttpMessageConverter == null) {
            jackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
            messageConverters.add(jackson2HttpMessageConverter);
        }
        jackson2HttpMessageConverter.setPrettyPrint(false);
        jackson2HttpMessageConverter.setObjectMapper(GeodeJsonMapper.getMapperIgnoringUnknownProperties());
        jackson2HttpMessageConverter.setDefaultCharset(StandardCharsets.UTF_8);
    }

    public RestTemplateClusterManagementServiceTransport(ConnectionConfig connectionConfig) {
        this(new RestTemplate(), connectionConfig);
    }

    public RestTemplateClusterManagementServiceTransport(RestTemplate restTemplate, ConnectionConfig connectionConfig) {
        this(restTemplate);
        this.configureConnection(connectionConfig);
    }

    @Override
    public void configureConnection(ConnectionConfig connectionConfig) {
        if (connectionConfig == null) {
            throw new IllegalStateException("ConnectionConfig cannot be null. Please use setConnectionConfig()");
        }
        if (connectionConfig.getHost() == null || connectionConfig.getPort() <= 0) {
            throw new IllegalArgumentException("host and port needs to be specified in order to build the service.");
        }
        String schema = connectionConfig.getSslContext() == null ? "http" : "https";
        DefaultUriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory(schema + "://" + connectionConfig.getHost() + ":" + connectionConfig.getPort() + "/management");
        this.restTemplate.setUriTemplateHandler(uriBuilderFactory);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (connectionConfig.getFollowRedirects()) {
            clientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        }
        if (connectionConfig.getAuthToken() != null) {
            List<BasicHeader> defaultHeaders = Collections.singletonList(new BasicHeader("Authorization", "Bearer " + connectionConfig.getAuthToken()));
            clientBuilder.setDefaultHeaders(defaultHeaders);
        } else if (connectionConfig.getUsername() != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(connectionConfig.getHost(), connectionConfig.getPort()), (Credentials)new UsernamePasswordCredentials(connectionConfig.getUsername(), connectionConfig.getPassword()));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        clientBuilder.setSSLContext(connectionConfig.getSslContext());
        clientBuilder.setSSLHostnameVerifier(connectionConfig.getHostnameVerifier());
        requestFactory.setHttpClient((HttpClient)clientBuilder.build());
        this.restTemplate.setRequestFactory(requestFactory);
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult submitMessage(T configMessage, CommandType command) {
        switch (command) {
            case CREATE: {
                return this.create(configMessage, HttpMethod.POST);
            }
            case CREATE_OR_UPDATE: {
                return this.create(configMessage, HttpMethod.PUT);
            }
            case DELETE: {
                return this.delete(configMessage);
            }
        }
        throw new IllegalArgumentException("Unable to process command " + (Object)((Object)command) + ". Perhaps you need to use a different method in ClusterManagementServiceTransport.");
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementGetResult<T, R> submitMessageForGet(T config) {
        return (ClusterManagementGetResult)this.restTemplate.exchange(RestTemplateClusterManagementServiceTransport.getIdentityEndpoint(config), HttpMethod.GET, RestTemplateClusterManagementServiceTransport.makeEntity(config), ClusterManagementGetResult.class, new Object[0]).getBody();
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementListResult<T, R> submitMessageForList(T config) {
        String endPoint = "/v1" + config.getLinks().getList();
        return (ClusterManagementListResult)this.restTemplate.exchange(endPoint + "?id={id}&group={group}", HttpMethod.GET, RestTemplateClusterManagementServiceTransport.makeEntity(config), ClusterManagementListResult.class, config.getId(), config.getGroup()).getBody();
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementListOperationsResult<A, V> submitMessageForListOperation(A opType) {
        return (ClusterManagementListOperationsResult)this.restTemplate.exchange("/v1" + opType.getEndpoint(), HttpMethod.GET, RestTemplateClusterManagementServiceTransport.makeEntity(null), ClusterManagementListOperationsResult.class, new Object[0]).getBody();
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<A, V> submitMessageForGetOperation(A op, String operationId) {
        String uri = "/v1" + op.getEndpoint() + "/" + operationId;
        return (ClusterManagementOperationResult)this.restTemplate.exchange(uri, HttpMethod.GET, RestTemplateClusterManagementServiceTransport.makeEntity(null), ClusterManagementOperationResult.class, new Object[0]).getBody();
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<A, V> submitMessageForStart(A op) {
        return (ClusterManagementOperationResult)this.restTemplate.exchange("/v1" + op.getEndpoint(), HttpMethod.POST, RestTemplateClusterManagementServiceTransport.makeEntity(op), ClusterManagementOperationResult.class, new Object[0]).getBody();
    }

    @Override
    public boolean isConnected() {
        try {
            return "pong".equals(this.restTemplate.getForEntity("/v1/ping", String.class, new Object[0]).getBody());
        }
        catch (RestClientException e) {
            return false;
        }
    }

    @Override
    public void close() {
        this.longRunningStatusPollingThreadPool.shutdownNow();
    }

    private <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult create(T config, HttpMethod method) {
        String endPoint = "/v1" + config.getLinks().getList();
        return (ClusterManagementRealizationResult)this.restTemplate.exchange(endPoint, method, RestTemplateClusterManagementServiceTransport.makeEntity(config), ClusterManagementRealizationResult.class, new Object[0]).getBody();
    }

    private <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult delete(T config) {
        String uri = RestTemplateClusterManagementServiceTransport.getIdentityEndpoint(config);
        return (ClusterManagementRealizationResult)this.restTemplate.exchange(uri + "?group={group}", HttpMethod.DELETE, RestTemplateClusterManagementServiceTransport.makeEntity(null), ClusterManagementRealizationResult.class, config.getGroup()).getBody();
    }

    private static <T> HttpEntity<?> makeEntity(T config) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Include-Class", "true");
        if (config instanceof HasFile) {
            LinkedMultiValueMap content = new LinkedMultiValueMap();
            File file = ((HasFile)config).getFile();
            if (file != null) {
                content.add((Object)"file", (Object)new FileSystemResource(file));
                content.add((Object)"config", config);
                return new HttpEntity<LinkedMultiValueMap>(content, headers);
            }
        }
        return new HttpEntity<T>(config, headers);
    }

    private static String getIdentityEndpoint(AbstractConfiguration<?> config) {
        String uri = config.getLinks().getSelf();
        if (uri == null) {
            throw new IllegalArgumentException("Unable to construct the URI with the current configuration.");
        }
        return "/v1" + uri;
    }
}

