/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.util.Objects;
import org.apache.geode.management.api.CommandType;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.HasFile;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.runtime.DeploymentInfo;

public class Deployment
extends GroupableConfiguration<DeploymentInfo>
implements HasFile {
    private static final long serialVersionUID = 6992732279452865384L;
    public static final String DEPLOYMENT_ENDPOINT = "/deployments";
    private String jarFileName;
    @ApiModelProperty(accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String deployedTime;
    @ApiModelProperty(accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String deployedBy;
    private transient File file;

    public Deployment() {
    }

    public Deployment(String jarFileName, String deployedBy, String deployedTime) {
        this.jarFileName = jarFileName;
        this.deployedBy = deployedBy;
        this.deployedTime = deployedTime;
    }

    @Override
    @JsonIgnore
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.setFileName(file.getName());
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getFileName();
    }

    @Override
    public String getFileName() {
        return this.jarFileName;
    }

    public void setFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public String getDeployedTime() {
        return this.deployedTime;
    }

    public void setDeployedTime(String deployedTime) {
        this.deployedTime = deployedTime;
    }

    public String getDeployedBy() {
        return this.deployedBy;
    }

    public void setDeployedBy(String deployedBy) {
        this.deployedBy = deployedBy;
    }

    @Override
    public Links getLinks() {
        return new Links(this.getId(), DEPLOYMENT_ENDPOINT);
    }

    public String toString() {
        return "Deployment{jarFileName='" + this.jarFileName + '\'' + ", deployedTime='" + this.deployedTime + '\'' + ", deployedBy='" + this.deployedBy + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deployment that = (Deployment)o;
        return Objects.equals(this.jarFileName, that.jarFileName) && Objects.equals(this.deployedTime, that.deployedTime) && Objects.equals(this.deployedBy, that.deployedBy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.jarFileName, this.deployedTime, this.deployedBy);
    }

    @Override
    public CommandType getCreationCommandType() {
        return CommandType.CREATE_OR_UPDATE;
    }
}

