/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.SerializerUtil;
import org.apache.geode.internal.lang.JavaWorkarounds;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;

public class FlatFormatSerializer
implements LuceneSerializer {
    private final ConcurrentMap<String, List<String>> tokenizedFieldCache = new ConcurrentHashMap<String, List<String>>();
    private static final Logger logger = LogService.getLogger();

    public Collection<Document> toDocuments(LuceneIndex index, Object value) {
        String[] fields = index.getFieldNames();
        Document doc = new Document();
        for (String indexedFieldName : fields) {
            List<String> tokenizedFields = this.tokenizeField(indexedFieldName);
            this.addFieldValue(doc, indexedFieldName, value, tokenizedFields);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("FlatFormatSerializer.toDocuments: " + doc);
        }
        return Collections.singleton(doc);
    }

    private List<String> tokenizeField(String indexedFieldName) {
        List tokenizedFields = (List)JavaWorkarounds.computeIfAbsent(this.tokenizedFieldCache, (Object)indexedFieldName, field -> Arrays.asList(indexedFieldName.split("\\.")));
        return tokenizedFields;
    }

    private void addFieldValue(Document doc, String indexedFieldName, Object value, List<String> tokenizedFields) {
        String currentLevelField = tokenizedFields.get(0);
        Object fieldValue = this.getFieldValue(value, currentLevelField);
        if (fieldValue == null) {
            return;
        }
        if (fieldValue.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(fieldValue); ++i) {
                Object item = Array.get(fieldValue, i);
                this.addFieldValueForNonCollectionObject(doc, indexedFieldName, item, tokenizedFields);
            }
        } else if (fieldValue instanceof Collection) {
            Collection collection = (Collection)fieldValue;
            for (Object item : collection) {
                this.addFieldValueForNonCollectionObject(doc, indexedFieldName, item, tokenizedFields);
            }
        } else {
            this.addFieldValueForNonCollectionObject(doc, indexedFieldName, fieldValue, tokenizedFields);
        }
    }

    private void addFieldValueForNonCollectionObject(Document doc, String indexedFieldName, Object fieldValue, List<String> tokenizedFields) {
        if (tokenizedFields.size() == 1) {
            SerializerUtil.addField(doc, indexedFieldName, fieldValue);
        } else {
            this.addFieldValue(doc, indexedFieldName, fieldValue, tokenizedFields.subList(1, tokenizedFields.size()));
        }
    }

    private Object getFieldValue(Object value, String fieldName) {
        if (value instanceof PdxInstance) {
            PdxInstance pdx = (PdxInstance)value;
            Object fieldValue = null;
            if (pdx.hasField(fieldName)) {
                fieldValue = pdx.getField(fieldName);
            }
            return fieldValue;
        }
        Class<?> clazz = value.getClass();
        if (fieldName.equals("__REGION_VALUE_FIELD") && SerializerUtil.supportedPrimitiveTypes().contains(clazz)) {
            return value;
        }
        while (true) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(value);
            }
            catch (Exception e) {
                if ((clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) continue;
                return null;
            }
            break;
        }
    }
}

