/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.xml;

import java.util.Stack;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.cache.query.internal.xml.QueryConfigurationServiceCreation;
import org.apache.geode.cache.query.internal.xml.QueryMethodAuthorizerCreation;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.xml.sax.Attributes;

public enum ElementType {
    QUERY_CONFIG_SERVICE("query-config-service"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof CacheCreation)) {
                throw new CacheXmlException("<query-config-service:query-config-service> elements must occur within <cache> elements");
            }
            QueryConfigurationServiceCreation queryConfigurationServiceCreation = new QueryConfigurationServiceCreation();
            stack.push(queryConfigurationServiceCreation);
        }

        @Override
        void endElement(Stack<Object> stack) {
            QueryConfigurationServiceCreation queryConfigurationServiceCreation = (QueryConfigurationServiceCreation)stack.pop();
            CacheCreation cacheCreation = (CacheCreation)stack.peek();
            cacheCreation.setQueryConfigurationServiceCreation(queryConfigurationServiceCreation);
        }
    }
    ,
    METHOD_AUTHORIZER("method-authorizer"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof QueryConfigurationServiceCreation)) {
                throw new CacheXmlException("<query-config-service:method-authorizer> elements must occur within <query-config-service:query-config-service> elements");
            }
            String className = attributes.getValue("class-name");
            QueryMethodAuthorizerCreation methodAuthorizer = new QueryMethodAuthorizerCreation();
            if (className != null) {
                methodAuthorizer.setClassName(className);
            }
            stack.push(methodAuthorizer);
        }

        @Override
        void endElement(Stack<Object> stack) {
            QueryMethodAuthorizerCreation methodAuthorizer = (QueryMethodAuthorizerCreation)stack.pop();
            QueryConfigurationServiceCreation queryConfigurationServiceCreation = (QueryConfigurationServiceCreation)stack.peek();
            queryConfigurationServiceCreation.setMethodAuthorizerCreation(methodAuthorizer);
        }
    }
    ,
    PARAMETER("parameter"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof QueryMethodAuthorizerCreation)) {
                throw new CacheXmlException("<query-config-service:parameter> elements must occur within <query-config-service:method-authorizer> elements");
            }
            QueryMethodAuthorizerCreation methodAuthorizer = (QueryMethodAuthorizerCreation)stack.peek();
            String parameter = attributes.getValue("parameter-value");
            if (parameter != null) {
                methodAuthorizer.addSingleParameter(parameter);
            }
        }

        @Override
        void endElement(Stack<Object> stack) {
        }
    };

    private String typeName;

    private ElementType(String typeName) {
        this.typeName = typeName;
    }

    static ElementType getTypeFromName(String typeName) {
        for (ElementType type : ElementType.values()) {
            if (!type.typeName.equals(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid type '" + typeName + "'");
    }

    public String getTypeName() {
        return this.typeName;
    }

    abstract void startElement(Stack<Object> var1, Attributes var2);

    abstract void endElement(Stack<Object> var1);
}

