/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Set;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.IdentityArrayList;
import org.apache.geode.internal.cache.TXRegionLockRequestImpl;
import org.apache.geode.internal.cache.TXReservationMgr;
import org.apache.geode.internal.cache.locks.TXLockId;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.locks.TXRegionLockRequest;

public class TXLockRequest {
    private boolean localLockHeld = false;
    private TXLockId distLockId = null;
    private IdentityArrayList localLocks = null;
    private ArrayList<TXRegionLockRequest> distLocks = null;
    private Set otherMembers = null;
    @MakeNotStatic
    private static final TXReservationMgr resMgr = new TXReservationMgr(true);

    void setOtherMembers(Set s) {
        this.otherMembers = s;
    }

    public void addLocalRequest(TXRegionLockRequest req) {
        if (this.localLocks == null) {
            this.localLocks = new IdentityArrayList();
        }
        this.localLocks.add(req);
    }

    public TXRegionLockRequest getRegionLockRequest(String regionFullPath) {
        if (this.localLocks == null || regionFullPath == null) {
            return null;
        }
        ObjectListIterator it = this.localLocks.iterator();
        while (it.hasNext()) {
            TXRegionLockRequestImpl rlr = (TXRegionLockRequestImpl)it.next();
            if (!rlr.getRegionFullPath().equals(regionFullPath)) continue;
            return rlr;
        }
        return null;
    }

    void addDistributedRequest(TXRegionLockRequest req) {
        if (this.distLocks == null) {
            this.distLocks = new ArrayList();
        }
        this.distLocks.add(req);
    }

    public void obtain(InternalDistributedSystem system) throws CommitConflictException {
        if (this.localLocks != null && !this.localLocks.isEmpty()) {
            TXLockRequest.txLocalLock(this.localLocks);
            this.localLockHeld = true;
        }
        if (this.distLocks != null && !this.distLocks.isEmpty()) {
            this.distLockId = TXLockService.createDTLS(system).txLock(this.distLocks, this.otherMembers);
        }
    }

    public void releaseLocal() {
        if (this.localLockHeld) {
            TXLockRequest.txLocalRelease(this.localLocks);
            this.localLockHeld = false;
        }
    }

    public void releaseDistributed(InternalDistributedSystem system) {
        if (this.distLockId != null) {
            try {
                TXLockService txls = TXLockService.createDTLS(system);
                txls.release(this.distLockId);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.distLockId = null;
        }
    }

    public TXLockId getDistributedLockId() {
        return this.distLockId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getCanonicalName()).append("@").append(System.identityHashCode(this));
        sb.append(" RegionLockRequests:");
        if (this.localLocks != null) {
            ObjectListIterator it = this.localLocks.iterator();
            while (it.hasNext()) {
                TXRegionLockRequest rlr = (TXRegionLockRequest)it.next();
                sb.append(" TXRegionLockRequest:");
                sb.append(rlr.getRegionFullPath()).append(" keys:").append(rlr.getKeys());
            }
        }
        return sb.toString();
    }

    public void cleanup(InternalDistributedSystem system) {
        this.releaseLocal();
        this.releaseDistributed(system);
    }

    private static void txLocalLock(IdentityArrayList localLocks) throws CommitConflictException {
        resMgr.makeReservation(localLocks);
    }

    private static void txLocalRelease(IdentityArrayList localLocks) {
        resMgr.releaseReservation(localLocks);
    }
}

