/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.Operation;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXRmtEvent;
import org.apache.geode.internal.cache.TxCallbackEventFactory;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TxCallbackEventFactoryImpl
implements TxCallbackEventFactory {
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryEventImpl createCallbackEvent(InternalRegion internalRegion, Operation op, Object key, Object newValue, TransactionId txId, TXRmtEvent txEvent, EventID eventId, Object aCallbackArgument, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        Assert.assertTrue(txId != null);
        DistributedMember originator = txId.getMemberId();
        InternalRegion eventRegion = internalRegion;
        if (eventRegion.isUsedForPartitionedRegionBucket()) {
            eventRegion = internalRegion.getPartitionedRegion();
        }
        EntryEventImpl retVal = EntryEventImpl.create(internalRegion, op, key, newValue, aCallbackArgument, txEntryState == null, originator);
        boolean returnedRetVal = false;
        try {
            if (bridgeContext != null) {
                retVal.setContext(bridgeContext);
            }
            if (eventRegion.generateEventID()) {
                retVal.setEventId(eventId);
            }
            if (versionTag != null) {
                retVal.setVersionTag(versionTag);
            }
            retVal.setTailKey(tailKey);
            FilterRoutingInfo.FilterInfo localRouting = null;
            boolean computeFilterInfo = false;
            if (filterRoutingInfo != null) {
                localRouting = filterRoutingInfo.getLocalFilterInfo();
                if (localRouting != null) {
                    computeFilterInfo = !filterRoutingInfo.hasLocalInterestBeenComputed() && !localRouting.filterProcessedLocally;
                } else {
                    localRouting = filterRoutingInfo.getFilterInfo(internalRegion.getMyId());
                }
                if (localRouting != null && !computeFilterInfo) {
                    retVal.setLocalFilterInfo(localRouting);
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("createCBEvent filterRouting={} computeFilterInfo={} local routing={}", (Object)filterRoutingInfo, (Object)computeFilterInfo, (Object)localRouting);
            }
            if (internalRegion.isUsedForPartitionedRegionBucket()) {
                BucketRegion bucket = (BucketRegion)internalRegion;
                if (BucketRegion.FORCE_LOCAL_LISTENERS_INVOCATION || bucket.getBucketAdvisor().isPrimary()) {
                    retVal.setInvokePRCallbacks(true);
                } else {
                    retVal.setInvokePRCallbacks(false);
                }
            }
            retVal.setTransactionId(txId);
            returnedRetVal = true;
            EntryEventImpl entryEventImpl = retVal;
            return entryEventImpl;
        }
        finally {
            if (!returnedRetVal) {
                retVal.release();
            }
        }
    }
}

