/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.BucketDump;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.internal.util.ObjectIntProcedure;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FetchEntriesMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;

    public FetchEntriesMessage() {
    }

    private FetchEntriesMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
    }

    public static FetchEntriesResponse send(InternalDistributedMember recipient, PartitionedRegion r, int bucketId) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "FetchEntriesMessage NULL reply message");
        FetchEntriesResponse p = new FetchEntriesResponse(r.getSystem(), r, recipient, bucketId);
        FetchEntriesMessage m = new FetchEntriesMessage(recipient, r.getPRId(), p, bucketId);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(String.format("Failed sending < %s >", m));
        }
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, ForceReattemptException {
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "FetchEntriesMessage operateOnRegion: {}", (Object)pr.getFullPath());
        }
        PartitionedRegionDataStore ds = pr.getDataStore();
        BucketRegion entries = null;
        if (ds != null) {
            entries = ds.handleRemoteGetEntries(this.bucketId);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "FetchKeysMessage send keys back using processorId: {}", (Object)this.getProcessorId());
            }
        } else {
            logger.warn("FetchKeysMessage: data store not configured for this member");
        }
        pr.getPrStats().endPartitionMessagesProcessing(startTime);
        FetchEntriesReplyMessage.send(this.getSender(), this.getProcessorId(), dm, this.bucketId, entries);
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; recipient=").append(this.getRecipient());
    }

    public int getDSFID() {
        return 46;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.bucketId);
    }

    public static class FetchEntriesResponse
    extends ReplyProcessor21 {
        private final PartitionedRegion pr;
        protected volatile RegionVersionVector returnRVV;
        protected final HashMap<Object, Object> returnValue;
        protected final HashMap<Object, VersionTag> returnVersions = new HashMap();
        private final Map<VersionSource, VersionSource> canonicalMembers = new ConcurrentHashMap<VersionSource, VersionSource>();
        private final Object endLock = new Object();
        private volatile int chunksProcessed;
        private volatile int chunksExpected;
        private volatile boolean lastChunkReceived;
        private int bucketId;
        private InternalDistributedMember recipient;

        public FetchEntriesResponse(InternalDistributedSystem ds, PartitionedRegion pr, final InternalDistributedMember recipient, final int bucketId) {
            super(ds, Collections.singleton(recipient));
            this.pr = pr;
            this.bucketId = bucketId;
            this.recipient = recipient;
            this.returnValue = new HashMap<Object, Object>(){
                private static final long serialVersionUID = 0L;

                @Override
                public String toString() {
                    return "Bucket id = " + bucketId + " from member = " + recipient + ": " + super.toString();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            ReplyMessage reply;
            Object returnValue;
            if (msg instanceof ReplyMessage && (returnValue = (reply = (ReplyMessage)msg).getReturnValue()) instanceof RegionVersionVector) {
                this.returnRVV = (RegionVersionVector)returnValue;
                Object object = this.endLock;
                synchronized (object) {
                    if (this.allMessagesReceived(true)) {
                        super.process(msg);
                    }
                }
                return;
            }
            super.process(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processChunk(FetchEntriesReplyMessage msg) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM_VERBOSE);
            boolean doneProcessing = false;
            if (msg.getException() != null) {
                this.process(msg);
            } else {
                boolean deserializingKey = true;
                try {
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(msg.chunk);
                    DataInputStream in = new DataInputStream(byteStream);
                    while (in.available() > 0) {
                        deserializingKey = true;
                        Object key = DataSerializer.readObject(in);
                        if (key != null) {
                            Object id;
                            deserializingKey = false;
                            Object value = DataSerializer.readObject(in);
                            VersionTag versionTag = (VersionTag)DataSerializer.readObject(in);
                            Object v = id = versionTag == null ? null : (Object)versionTag.getMemberID();
                            if (id != null) {
                                if (this.canonicalMembers.containsKey(id)) {
                                    versionTag.setMemberID(this.canonicalMembers.get(id));
                                } else {
                                    this.canonicalMembers.put((VersionSource)id, (VersionSource)id);
                                }
                            }
                            HashMap<Object, Object> hashMap = this.returnValue;
                            synchronized (hashMap) {
                                this.returnValue.put(key, value);
                                this.returnVersions.put(key, versionTag);
                                continue;
                            }
                        }
                        Assert.assertTrue(in.available() == 0);
                    }
                    Object object = this.endLock;
                    synchronized (object) {
                        ++this.chunksProcessed;
                        if (msg.seriesNum + 1 == msg.numSeries && msg.lastInSeries) {
                            this.chunksExpected = msg.msgNum + 1;
                            this.lastChunkReceived = true;
                        }
                        if (this.allMessagesReceived(msg.hasRVV)) {
                            doneProcessing = true;
                        }
                        if (isDebugEnabled) {
                            logger.trace(LogMarker.DM_VERBOSE, "{} chunksProcessed={},lastChunkReceived={},chunksExpected={},done={}", (Object)this, (Object)this.chunksProcessed, (Object)this.lastChunkReceived, (Object)this.chunksExpected, (Object)doneProcessing);
                        }
                    }
                }
                catch (Exception e) {
                    if (deserializingKey) {
                        this.processException(new ReplyException("Error deserializing keys", e));
                    } else {
                        this.processException(new ReplyException("Error deserializing values", e));
                    }
                    this.checkIfDone();
                }
                if (doneProcessing) {
                    this.process(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allMessagesReceived(boolean hasRVV) {
            Object object = this.endLock;
            synchronized (object) {
                return this.lastChunkReceived && this.chunksExpected == this.chunksProcessed && (!hasRVV || this.returnRVV != null);
            }
        }

        public BucketDump waitForEntries() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("FetchKeysResponse got remote cancellation; forcing reattempt. {}", (Object)t.getMessage(), (Object)t);
                    throw new ForceReattemptException("FetchKeysResponse got remote cancellation; forcing reattempt.", t);
                }
                if (t instanceof ForceReattemptException) {
                    throw new ForceReattemptException("Peer requests reattempt", t);
                }
                e.handleCause();
            }
            if (!this.lastChunkReceived) {
                throw new ForceReattemptException("No replies received");
            }
            for (Map.Entry<Object, Object> entry : this.returnValue.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof CachedDeserializable)) continue;
                entry.setValue(((CachedDeserializable)value).getDeserializedValue(null, null));
            }
            return new BucketDump(this.bucketId, this.recipient, this.returnRVV, this.returnValue, this.returnVersions);
        }
    }

    public static class FetchEntriesReplyMessage
    extends ReplyMessage {
        int bucketId;
        int seriesNum;
        int msgNum;
        int numSeries;
        boolean lastInSeries;
        transient byte[] chunk;
        transient HeapDataOutputStream chunkStream;
        private boolean hasRVV;
        @Immutable
        private static final KnownVersion[] dsfidVersions = null;

        @Override
        public KnownVersion[] getSerializationVersions() {
            return dsfidVersions;
        }

        public FetchEntriesReplyMessage() {
        }

        protected FetchEntriesReplyMessage(InternalDistributedMember dest, int processorId, int buckId, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries, boolean hasRVV) {
            this.setRecipient(dest);
            this.setProcessorId(processorId);
            this.bucketId = buckId;
            this.seriesNum = seriesNum;
            this.msgNum = msgNum;
            this.numSeries = numSeries;
            this.lastInSeries = lastInSeries;
            this.chunkStream = chunk;
            this.hasRVV = hasRVV;
        }

        public static void send(final InternalDistributedMember recipient, final int processorId, final DistributionManager dm, final int bucketId, BucketRegion keys) throws ForceReattemptException {
            Assert.assertTrue(recipient != null, "FetchEntriesReplyMessage NULL reply message");
            boolean numSeries = true;
            boolean seriesNum = false;
            final RegionVersionVector rvv = keys.getVersionVector();
            if (rvv != null) {
                RegionVersionVector clone = rvv.getCloneForTransmission();
                ReplyMessage.send(recipient, processorId, clone, (ReplySender)dm);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Starting PR entries chunking for {} entries", (Object)keys.size());
            }
            try {
                boolean finished = FetchEntriesReplyMessage.chunkMap(recipient, keys, InitialImageOperation.CHUNK_SIZE_IN_BYTES, false, new ObjectIntProcedure(){
                    int msgNum = 0;
                    boolean last = false;

                    @Override
                    public boolean executeWith(Object a, int b) {
                        HeapDataOutputStream chunk = (HeapDataOutputStream)a;
                        this.last = b > 0;
                        try {
                            boolean okay = FetchEntriesReplyMessage.sendChunk(recipient, processorId, bucketId, dm, chunk, 0, this.msgNum++, 1, this.last, rvv != null);
                            return okay;
                        }
                        catch (CancelException e) {
                            return false;
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("{} PR entries chunking", (Object)(finished ? "Finished" : "DID NOT complete"));
                }
            }
            catch (IOException io) {
                throw new ForceReattemptException("Unable to send response to fetch-entries request", io);
            }
        }

        static boolean sendChunk(InternalDistributedMember recipient, int processorId, int bucketId, DistributionManager dm, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries, boolean hasRVV) {
            FetchEntriesReplyMessage reply = new FetchEntriesReplyMessage(recipient, processorId, bucketId, chunk, seriesNum, msgNum, numSeries, lastInSeries, hasRVV);
            Set<InternalDistributedMember> failures = dm.putOutgoing(reply);
            return failures == null || failures.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean chunkMap(InternalDistributedMember receiver, BucketRegion map, int CHUNK_SIZE_IN_BYTES, boolean includeValues, ObjectIntProcedure proc) throws IOException {
            Iterator it = map.entrySet().iterator();
            boolean keepGoing = true;
            boolean sentLastChunk = false;
            try (HeapDataOutputStream mos = new HeapDataOutputStream(InitialImageOperation.CHUNK_SIZE_IN_BYTES + 2048, Versioning.getKnownVersionOrDefault((Version)receiver.getVersion(), (KnownVersion)KnownVersion.CURRENT));){
                do {
                    mos.reset();
                    int avgItemSize = 0;
                    int itemCount = 0;
                    while (mos.size() + avgItemSize < InitialImageOperation.CHUNK_SIZE_IN_BYTES && it.hasNext()) {
                        RegionEntry re;
                        NonTXEntry entry = (NonTXEntry)it.next();
                        RegionEntry regionEntry = re = entry.getRegionEntry();
                        synchronized (regionEntry) {
                            Object value = re.getValueRetain(map, true);
                            try {
                                if (value == null) {
                                    value = re.getSerializedValueOnDisk((LocalRegion)entry.getRegion());
                                }
                                if (!Token.isRemoved(value)) {
                                    VersionStamp stamp;
                                    VersionTag versionTag;
                                    DataSerializer.writeObject(re.getKey(), mos);
                                    if (Token.isInvalid(value)) {
                                        value = null;
                                    }
                                    VersionTag versionTag2 = versionTag = (stamp = re.getVersionStamp()) != null ? stamp.asVersionTag() : null;
                                    if (versionTag != null) {
                                        versionTag.replaceNullIDs(map.getVersionMember());
                                    }
                                    DataSerializer.writeObject(value, mos);
                                    DataSerializer.writeObject(versionTag, mos);
                                    avgItemSize = mos.size() / ++itemCount;
                                }
                            }
                            finally {
                                OffHeapHelper.release(value);
                            }
                        }
                    }
                    DataSerializer.writeObject(null, mos);
                    int lastMsg = it.hasNext() ? 0 : 1;
                    keepGoing = proc.executeWith(mos, lastMsg);
                    boolean bl = sentLastChunk = lastMsg == 1 && keepGoing;
                } while (keepGoing && it.hasNext());
            }
            return sentLastChunk;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 p) {
            long startTime = this.getTimestamp();
            FetchEntriesResponse processor = (FetchEntriesResponse)p;
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "FetchEntriesReplyMessage processor not found");
                }
                return;
            }
            processor.processChunk(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.bucketId);
            out.writeInt(this.seriesNum);
            out.writeInt(this.msgNum);
            out.writeInt(this.numSeries);
            out.writeBoolean(this.lastInSeries);
            DataSerializer.writeObjectAsByteArray(this.chunkStream, out);
            out.writeBoolean(this.hasRVV);
        }

        @Override
        public int getDSFID() {
            return 65;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.bucketId = in.readInt();
            this.seriesNum = in.readInt();
            this.msgNum = in.readInt();
            this.numSeries = in.readInt();
            this.lastInSeries = in.readBoolean();
            this.chunk = DataSerializer.readByteArray(in);
            this.hasRVV = in.readBoolean();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FetchEntriesReplyMessage ").append("processorid=").append(this.processorId).append(",bucketId=").append(this.bucketId);
            if (this.getSender() != null) {
                sb.append(",sender=").append(this.getSender());
            }
            sb.append(",seriesNum=").append(this.seriesNum).append(",msgNum=").append(this.msgNum).append(",numSeries=").append(this.numSeries).append(",lastInSeries=").append(this.lastInSeries);
            if (this.chunk != null) {
                sb.append(",size=").append(this.chunk.length);
            } else if (this.chunkStream != null) {
                sb.append(",size=").append(this.chunkStream.size());
            }
            if (this.getException() != null) {
                sb.append(",exception=").append(this.getException());
            }
            return sb.toString();
        }
    }
}

