/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.versions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.versions.DiskVersionTag;
import org.apache.geode.internal.cache.versions.VMVersionTag;
import org.apache.geode.internal.cache.versions.VersionHolder;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.size.ReflectionSingleObjectSizer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class VersionTag<T extends VersionSource>
implements DataSerializableFixedID,
Serializable,
VersionHolder<T> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 9098338414308465271L;
    public static final int TAG_SIZE = ReflectionSingleObjectSizer.OBJECT_SIZE + ReflectionSingleObjectSizer.REFERENCE_SIZE * 2 + 23;
    public static final long ILLEGAL_VERSION_TIMESTAMP = Long.MIN_VALUE;
    static final int HAS_MEMBER_ID = 1;
    static final int HAS_PREVIOUS_MEMBER_ID = 2;
    static final int VERSION_TWO_BYTES = 4;
    static final int DUPLICATE_MEMBER_IDS = 8;
    static final int HAS_RVV_HIGH_BYTE = 16;
    private static final int BITS_POSDUP = 1;
    private static final int BITS_RECORDED = 2;
    private static final int BITS_HAS_PREVIOUS_ID = 4;
    private static final int BITS_GATEWAY_TAG = 8;
    private static final int BITS_IS_REMOTE_TAG = 16;
    private static final int BITS_TIMESTAMP_APPLIED = 32;
    private static final int BITS_ALLOWED_BY_RESOLVER = 64;
    private int entryVersion;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private long timeStamp;
    private byte distributedSystemId;
    private static final AtomicIntegerFieldUpdater<VersionTag> bitsUpdater = AtomicIntegerFieldUpdater.newUpdater(VersionTag.class, "bits");
    private volatile int bits;
    private T memberID;
    private T previousMemberID;

    public boolean isFromOtherMember() {
        return (this.bits & 0x10) != 0;
    }

    public boolean isTimeStampUpdated() {
        return (this.bits & 0x20) != 0;
    }

    public void setTimeStampApplied(boolean isTimeStampUpdated) {
        if (isTimeStampUpdated) {
            this.setBits(32);
        } else {
            this.clearBits(-33);
        }
    }

    public boolean isGatewayTag() {
        return (this.bits & 8) != 0;
    }

    public void setEntryVersion(int version) {
        this.entryVersion = version;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersion;
    }

    public void setVersionTimeStamp(long timems) {
        this.timeStamp = timems;
    }

    public void setIsGatewayTag(boolean isGateway) {
        if (isGateway) {
            this.setBits(8);
        } else {
            this.clearBits(-9);
        }
    }

    public void setRegionVersion(long version) {
        this.regionVersionHighBytes = (short)((version & 0xFFFF00000000L) >> 32);
        this.regionVersionLowBytes = (int)(version & 0xFFFFFFFFL);
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    public void setRegionVersion(short highBytes, int lowBytes) {
        this.regionVersionHighBytes = highBytes;
        this.regionVersionLowBytes = lowBytes;
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    public void setRecorded() {
        this.setBits(2);
    }

    public boolean isRecorded() {
        return (this.bits & 2) != 0;
    }

    public void setCanonicalIDs(DistributionManager distributionManager) {
    }

    @Override
    public T getMemberID() {
        return this.memberID;
    }

    public void setMemberID(T memberID) {
        this.memberID = memberID;
    }

    public T getPreviousMemberID() {
        return this.previousMemberID;
    }

    public void setPreviousMemberID(T previousMemberID) {
        this.setBits(4);
        this.previousMemberID = previousMemberID;
    }

    public VersionTag setPosDup(boolean flag) {
        if (flag) {
            this.setBits(1);
        } else {
            this.clearBits(-2);
        }
        return this;
    }

    public boolean isPosDup() {
        return (this.bits & 1) != 0;
    }

    public VersionTag setAllowedByResolver(boolean flag) {
        if (flag) {
            this.setBits(64);
        } else {
            this.clearBits(-65);
        }
        return this;
    }

    public boolean isAllowedByResolver() {
        return (this.bits & 0x40) != 0;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setDistributedSystemId(int id) {
        this.distributedSystemId = (byte)(id & 0xFF);
    }

    public void replaceNullIDs(VersionSource id) {
        if (this.memberID == null) {
            this.memberID = id;
        }
        if (this.previousMemberID == null && this.hasPreviousMemberID() && this.entryVersion > 1) {
            this.previousMemberID = id;
        }
    }

    public boolean hasPreviousMemberID() {
        return (this.bits & 4) != 0;
    }

    public boolean hasValidVersion() {
        return this.entryVersion != 0 || this.regionVersionHighBytes != 0 || this.regionVersionLowBytes != 0;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        this.toData(out, true);
    }

    public void toData(DataOutput out, boolean includeMember) throws IOException {
        int flags = 0;
        boolean versionIsShort = false;
        if (this.entryVersion < 65536) {
            versionIsShort = true;
            flags |= 4;
        }
        if (this.regionVersionHighBytes != 0) {
            flags |= 0x10;
        }
        if (this.memberID != null && includeMember) {
            flags |= 1;
        }
        boolean writePreviousMemberID = false;
        if (this.previousMemberID != null && includeMember) {
            flags |= 2;
            if (Objects.equals(this.previousMemberID, this.memberID)) {
                flags |= 8;
            } else {
                writePreviousMemberID = true;
            }
        }
        if (logger.isTraceEnabled(LogMarker.VERSION_TAG_VERBOSE)) {
            logger.trace(LogMarker.VERSION_TAG_VERBOSE, "serializing {} with flags 0x{}", this.getClass(), (Object)Integer.toHexString(flags));
        }
        out.writeShort(flags);
        out.writeShort(this.bits);
        out.write(this.distributedSystemId);
        if (versionIsShort) {
            out.writeShort(this.entryVersion & 0xFFFF);
        } else {
            out.writeInt(this.entryVersion);
        }
        if (this.regionVersionHighBytes != 0) {
            out.writeShort(this.regionVersionHighBytes);
        }
        out.writeInt(this.regionVersionLowBytes);
        InternalDataSerializer.writeUnsignedVL(this.timeStamp, out);
        if (this.memberID != null && includeMember) {
            this.writeMember(this.memberID, out);
        }
        if (writePreviousMemberID) {
            this.writeMember(this.previousMemberID, out);
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int flags = in.readUnsignedShort();
        if (logger.isTraceEnabled(LogMarker.VERSION_TAG_VERBOSE)) {
            logger.trace(LogMarker.VERSION_TAG_VERBOSE, "deserializing {} with flags 0x{}", this.getClass(), (Object)Integer.toHexString(flags));
        }
        bitsUpdater.set(this, in.readUnsignedShort());
        this.distributedSystemId = in.readByte();
        this.entryVersion = (flags & 4) != 0 ? in.readShort() & 0xFFFF : in.readInt() & 0xFFFFFFFF;
        if ((flags & 0x10) != 0) {
            this.regionVersionHighBytes = in.readShort();
        }
        this.regionVersionLowBytes = in.readInt();
        this.timeStamp = InternalDataSerializer.readUnsignedVL(in);
        if ((flags & 1) != 0) {
            this.memberID = this.readMember(in);
        }
        if ((flags & 2) != 0) {
            if ((flags & 8) != 0) {
                this.previousMemberID = this.memberID;
            } else {
                try {
                    this.previousMemberID = this.readMember(in);
                }
                catch (BufferUnderflowException e) {
                    if (context.getSerializationVersion().isOlderThan((Version)KnownVersion.GEODE_1_11_0)) {
                        logger.info("Buffer underflow encountered while reading a version tag - ignoring");
                    }
                    throw e;
                }
            }
        }
        this.setBits(16);
    }

    public void setIsRemoteForTesting() {
        this.setBits(16);
    }

    public abstract T readMember(DataInput var1) throws IOException, ClassNotFoundException;

    public abstract void writeMember(T var1, DataOutput var2) throws IOException;

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.isGatewayTag()) {
            s.append("{ds=").append(this.distributedSystemId).append("; time=").append(this.getVersionTimeStamp()).append("}");
        } else {
            s.append("{v").append(this.entryVersion);
            s.append("; rv").append(this.getRegionVersion());
            if (this.memberID != null) {
                s.append("; mbr=").append(this.memberID);
            }
            if (this.hasPreviousMemberID()) {
                s.append("; prev=").append(this.previousMemberID);
            }
            if (this.distributedSystemId >= 0) {
                s.append("; ds=").append(this.distributedSystemId);
            }
            s.append("; time=").append(this.getVersionTimeStamp());
            if (this.isFromOtherMember()) {
                s.append("; remote");
            }
            if (this.isAllowedByResolver()) {
                s.append("; allowed");
            }
            s.append("}");
        }
        return s.toString();
    }

    @Override
    public long getVersionTimeStamp() {
        return this.timeStamp;
    }

    public static VersionTag create(VersionSource memberId) {
        VersionTag tag = memberId instanceof DiskStoreID ? new DiskVersionTag() : new VMVersionTag();
        tag.setMemberID(memberId);
        return tag;
    }

    public static VersionTag create(boolean persistent, DataInput in) throws IOException, ClassNotFoundException {
        VersionTag tag = persistent ? new DiskVersionTag() : new VMVersionTag();
        InternalDataSerializer.invokeFromData(tag, in);
        return tag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entryVersion;
        result = 31 * result + (this.memberID == null ? 0 : this.memberID.hashCode());
        result = 31 * result + this.regionVersionHighBytes;
        result = 31 * result + this.regionVersionLowBytes;
        if (this.isGatewayTag()) {
            result = 31 * result + (int)this.timeStamp;
            result = 31 * result + (int)(this.timeStamp >>> 32);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionTag other = (VersionTag)obj;
        if (this.entryVersion != other.entryVersion) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        if (this.regionVersionHighBytes != other.regionVersionHighBytes) {
            return false;
        }
        if (this.regionVersionLowBytes != other.regionVersionLowBytes) {
            return false;
        }
        if (this.isGatewayTag() != other.isGatewayTag()) {
            return false;
        }
        if (this.isGatewayTag()) {
            if (this.timeStamp != other.timeStamp) {
                return false;
            }
            if (this.distributedSystemId != other.distributedSystemId) {
                return false;
            }
        }
        return true;
    }

    private void setBits(int bitMask) {
        int newBits;
        int oldBits;
        while (!bitsUpdater.compareAndSet(this, oldBits = this.bits, newBits = oldBits | bitMask)) {
        }
    }

    private void clearBits(int bitMask) {
        int newBits;
        int oldBits;
        while (!bitsUpdater.compareAndSet(this, oldBits = this.bits, newBits = oldBits & bitMask)) {
        }
    }
}

