/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.net.SSLConfig;

public class SSLUtil {
    protected static final String[] DEFAULT_ALGORITMS = new String[]{"TLSv1.3", "TLSv1.2"};

    public static SSLContext getSSLContextInstance(SSLConfig sslConfig) throws NoSuchAlgorithmException {
        String[] protocols = sslConfig.getProtocolsAsStringArray();
        return SSLUtil.findSSLContextForProtocols(protocols, DEFAULT_ALGORITMS);
    }

    @VisibleForTesting
    protected static SSLContext findSSLContextForProtocols(String[] protocols, String[] protocolsForAny) throws NoSuchAlgorithmException {
        for (String protocol : protocols) {
            if (protocol.equalsIgnoreCase("any")) {
                try {
                    return SSLUtil.findSSLContextForProtocols(protocolsForAny, new String[0]);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            try {
                return SSLContext.getInstance(protocol);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        throw new NoSuchAlgorithmException();
    }

    public static String[] readArray(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        return text.split("[\\s,]+");
    }

    public static SSLContext createAndConfigureSSLContext(SSLConfig sslConfig, boolean skipSslVerification) {
        try {
            if (sslConfig.useDefaultSSLContext()) {
                return SSLContext.getDefault();
            }
            SSLContext ssl = SSLUtil.getSSLContextInstance(sslConfig);
            KeyManager[] keyManagers = SSLUtil.getKeyManagers(sslConfig);
            TrustManager[] trustManagers = SSLUtil.getTrustManagers(sslConfig, skipSslVerification);
            ssl.init(keyManagers, trustManagers, new SecureRandom());
            return ssl;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyManager[] getKeyManagers(SSLConfig sslConfig) throws Exception {
        KeyManagerFactory keyManagerFactory = null;
        try (FileInputStream keyStoreStream = null;){
            if (StringUtils.isNotBlank((CharSequence)sslConfig.getKeystore())) {
                String keyStoreType = Objects.toString(sslConfig.getKeystoreType(), "JKS");
                KeyStore clientKeys = KeyStore.getInstance(keyStoreType);
                keyStoreStream = new FileInputStream(sslConfig.getKeystore());
                clientKeys.load(keyStoreStream, sslConfig.getKeystorePassword().toCharArray());
                keyManagerFactory = SSLUtil.getDefaultKeyManagerFactory();
                keyManagerFactory.init(clientKeys, sslConfig.getKeystorePassword().toCharArray());
            }
        }
        return keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null;
    }

    static KeyManagerFactory getDefaultKeyManagerFactory() throws NoSuchAlgorithmException {
        return KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrustManager[] getTrustManagers(SSLConfig sslConfig, boolean skipSslVerification) throws Exception {
        FileInputStream trustStoreStream = null;
        TrustManagerFactory trustManagerFactory = null;
        if (skipSslVerification) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            return trustAllCerts;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)sslConfig.getTruststore())) {
                String trustStoreType = Objects.toString(sslConfig.getTruststoreType(), "JKS");
                KeyStore serverPub = KeyStore.getInstance(trustStoreType);
                trustStoreStream = new FileInputStream(sslConfig.getTruststore());
                serverPub.load(trustStoreStream, sslConfig.getTruststorePassword().toCharArray());
                trustManagerFactory = SSLUtil.getDefaultTrustManagerFactory();
                trustManagerFactory.init(serverPub);
            }
        }
        finally {
            if (trustStoreStream != null) {
                trustStoreStream.close();
            }
        }
        return trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null;
    }

    static TrustManagerFactory getDefaultTrustManagerFactory() throws NoSuchAlgorithmException {
        return TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
    }
}

