/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import org.apache.geode.management.internal.beans.MetricsCalculator;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;

public class StatsLatency {
    private int prevIntNumberCounter = 0;
    private long prevLongNumberCounter = 0L;
    private long prevTimeCounter = 0L;
    private String numberKey;
    private String timeKey;
    private StatType numKeyType;
    private MBeanStatsMonitor monitor;

    public StatsLatency(String numberKey, StatType numKeyType, String timeKey, MBeanStatsMonitor monitor) {
        this.numberKey = numberKey;
        this.numKeyType = numKeyType;
        this.timeKey = timeKey;
        this.monitor = monitor;
    }

    public long getLatency() {
        if (this.numKeyType.equals((Object)StatType.INT_TYPE)) {
            int latestNumberCounter = this.monitor.getStatistic(this.numberKey).intValue();
            long latestTimeCounter = this.monitor.getStatistic(this.timeKey).longValue();
            long latency = MetricsCalculator.getLatency(this.prevIntNumberCounter, latestNumberCounter, this.prevTimeCounter, latestTimeCounter);
            this.prevTimeCounter = latestTimeCounter;
            this.prevIntNumberCounter = latestNumberCounter;
            return latency;
        }
        long latestNumberCounter = this.monitor.getStatistic(this.numberKey).longValue();
        long latestTimeCounter = this.monitor.getStatistic(this.timeKey).longValue();
        long latency = MetricsCalculator.getLatency(this.prevLongNumberCounter, latestNumberCounter, this.prevTimeCounter, latestTimeCounter);
        this.prevLongNumberCounter = latestNumberCounter;
        this.prevTimeCounter = latestTimeCounter;
        return latency;
    }
}

