/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.functions.NetstatFunction;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class NetstatCommand
extends GfshCommand {
    private static final String NETSTAT_FILE_REQUIRED_EXTENSION = ".txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"netstat"}, help="Report network information and statistics via the \"netstat\" operating system command.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.NetstatCommand$Interceptor", relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel netstat(@CliOption(key={"member", "members"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member(s) on which to run the netstat command.") String[] members, @CliOption(key={"group"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members on which to run the netstat command.") String group, @CliOption(key={"file"}, help="Text file to which output from the netstat command will be written. A \".txt\" extension will be added if it's not already a part of the specified name.") String saveAs, @CliOption(key={"with-lsof"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether lsof (list open files) command output should also be displayed. Not applicable for \"Microsoft Windows(TM)\" hosts.") boolean withlsof) {
        ResultModel result = new ResultModel();
        HashMap<String, DistributedMember> hostMemberMap = new HashMap<String, DistributedMember>();
        HashMap<String, List<String>> hostMemberListMap = new HashMap<String, List<String>>();
        try {
            String lineSeparatorToUse;
            if (members != null && members.length > 0 && group != null) {
                throw new IllegalArgumentException("Only one of --group or --member should be specified.");
            }
            StringBuilder resultInfo = new StringBuilder();
            InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
            if (members != null) {
                HashSet<Object> notFoundMembers = new HashSet<Object>();
                for (String memberIdOrName : members) {
                    Set membersToExecuteOn = ManagementUtils.getAllMembers((InternalDistributedSystem)system);
                    boolean memberFound = false;
                    for (DistributedMember distributedMember : membersToExecuteOn) {
                        String memberName = distributedMember.getName();
                        String memberId = distributedMember.getId();
                        if (!memberName.equals(memberIdOrName) && !memberId.equals(memberIdOrName)) continue;
                        this.buildMaps(hostMemberMap, hostMemberListMap, memberIdOrName, distributedMember);
                        memberFound = true;
                        break;
                    }
                    if (memberFound) continue;
                    notFoundMembers.add(memberIdOrName);
                }
                if (!notFoundMembers.isEmpty()) {
                    throw new IllegalArgumentException(CliStrings.format((String)"Could not find member(s) with Id(s) or name(s): {0}.", (Object[])new Object[]{this.collectionToString(notFoundMembers, -1)}));
                }
            } else {
                Set membersToExecuteOn = group != null ? system.getGroupMembers(group) : ManagementUtils.getAllMembers((InternalDistributedSystem)system);
                for (DistributedMember distributedMember : membersToExecuteOn) {
                    String memberName = distributedMember.getName();
                    String memberId = distributedMember.getId();
                    String memberIdOrName = memberName != null && !memberName.isEmpty() ? memberName : memberId;
                    this.buildMaps(hostMemberMap, hostMemberListMap, memberIdOrName, distributedMember);
                }
            }
            if ((lineSeparatorToUse = CommandExecutionContext.getShellLineSeparator()) == null) {
                lineSeparatorToUse = GfshParser.LINE_SEPARATOR;
            }
            NetstatFunction.NetstatFunctionArgument nfa = new NetstatFunction.NetstatFunctionArgument(lineSeparatorToUse, withlsof);
            if (!hostMemberMap.isEmpty()) {
                HashSet membersToExecuteOn = new HashSet(hostMemberMap.values());
                ResultCollector netstatResult = ManagementUtils.executeFunction((Function)NetstatFunction.INSTANCE, (Object)nfa, membersToExecuteOn);
                List resultList = (List)netstatResult.getResult();
                for (Object aResultList : resultList) {
                    NetstatFunction.NetstatFunctionResult netstatFunctionResult = (NetstatFunction.NetstatFunctionResult)aResultList;
                    CliUtil.DeflaterInflaterData deflaterInflaterData = netstatFunctionResult.getCompressedBytes();
                    try {
                        String remoteHost = netstatFunctionResult.getHost();
                        List membersList = (List)hostMemberListMap.get(remoteHost);
                        resultInfo.append(MessageFormat.format(netstatFunctionResult.getHeaderInfo(), this.collectionToString(membersList, 120)));
                        CliUtil.DeflaterInflaterData uncompressedBytes = CliUtil.uncompressBytes(deflaterInflaterData.getData(), deflaterInflaterData.getDataLength());
                        resultInfo.append(new String(uncompressedBytes.getData()));
                    }
                    catch (DataFormatException e) {
                        resultInfo.append("Error in some data. Reason : ").append(e.getMessage());
                    }
                }
            }
            if (saveAs != null && !saveAs.isEmpty()) {
                String saveToFile = saveAs;
                if (!saveAs.endsWith(NETSTAT_FILE_REQUIRED_EXTENSION)) {
                    saveToFile = saveAs + NETSTAT_FILE_REQUIRED_EXTENSION;
                }
                result.addFile(FilenameUtils.getName((String)saveToFile), resultInfo.toString());
            } else {
                result.addInfo().addLine(resultInfo.toString());
            }
        }
        finally {
            hostMemberMap.clear();
            hostMemberListMap.clear();
        }
        return result;
    }

    String collectionToString(Collection<?> col, int newlineAfter) {
        if (col != null) {
            StringBuilder builder = new StringBuilder();
            int lastNewlineAt = 0;
            Iterator<?> it = col.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                builder.append(String.valueOf(object));
                if (it.hasNext()) {
                    builder.append(", ");
                }
                if (newlineAfter <= 0 || (builder.length() - lastNewlineAt) / newlineAfter < 1) continue;
                builder.append(GfshParser.LINE_SEPARATOR);
            }
            return builder.toString();
        }
        return "" + null;
    }

    private void buildMaps(Map<String, DistributedMember> hostMemberMap, Map<String, List<String>> hostMemberListMap, String memberIdOrName, DistributedMember distributedMember) {
        List<Object> list;
        String host = distributedMember.getHost();
        if (!hostMemberMap.containsKey(host)) {
            hostMemberMap.put(host, distributedMember);
        }
        if (!hostMemberListMap.containsKey(host)) {
            list = new ArrayList();
            hostMemberListMap.put(host, list);
        } else {
            list = hostMemberListMap.get(host);
        }
        list.add(memberIdOrName);
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String saveAs = parseResult.getParamValueAsString("file");
            if (saveAs != null && StringUtils.isEmpty((CharSequence)FilenameUtils.getName((String)saveAs))) {
                return ResultModel.createError("Invalid file name: " + saveAs);
            }
            return ResultModel.createInfo("");
        }

        @Override
        public ResultModel postExecution(GfshParseResult parseResult, ResultModel result, Path tempFile) throws IOException {
            String saveAs = parseResult.getParamValueAsString("file");
            if (saveAs == null) {
                return result;
            }
            File file = new File(saveAs).getAbsoluteFile();
            result.saveFileTo(file.getParentFile());
            return result;
        }
    }
}

