/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.List;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class ConnectionEndpointConverter
implements Converter<ConnectionEndpoint> {
    static final String DEFAULT_JMX_HOST = "localhost";
    static final int DEFAULT_JMX_PORT = 1099;
    static final String DEFAULT_JMX_ENDPOINTS = "localhost[1099]";
    public static final String DEFAULT_LOCATOR_HOST = "localhost";
    public static final int DEFAULT_LOCATOR_PORT = 10334;
    public static final String DEFAULT_LOCATOR_ENDPOINTS = "localhost[10334]";

    @Override
    public boolean supports(Class<?> type, String optionContext) {
        return ConnectionEndpoint.class == type;
    }

    @Override
    public ConnectionEndpoint convertFromText(String value, Class<?> targetType, String optionContext) {
        String endpointStr = value.trim();
        String hostStr = "localhost";
        String portStr = "";
        int port = 1099;
        if (!endpointStr.isEmpty()) {
            int openIndex = endpointStr.indexOf("[");
            int closeIndex = endpointStr.indexOf("]");
            if (openIndex != -1) {
                if (closeIndex == -1) {
                    throw new IllegalArgumentException("Expected input: host[port] or host. Invalid value specified endpoints : " + value);
                }
                hostStr = endpointStr.substring(0, openIndex);
                portStr = endpointStr.substring(openIndex + 1, closeIndex);
                if (portStr.isEmpty()) {
                    throw new IllegalArgumentException("Expected input: host[port] or host. Invalid value specified endpoints : " + value);
                }
                try {
                    port = Integer.valueOf(portStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Expected input: host[port], Port should be a valid number between 1024-65536. Invalid value specified endpoints : " + value);
                }
            } else {
                if (closeIndex != -1) {
                    throw new IllegalArgumentException("Expected input: host[port] or host. Invalid value specified endpoints : " + value);
                }
                hostStr = endpointStr;
            }
        }
        return new ConnectionEndpoint(hostStr, port);
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if ("__jmx-manager__".equals(optionContext)) {
            completions.add(new Completion(DEFAULT_JMX_ENDPOINTS));
        } else if ("__locator__".equals(optionContext)) {
            completions.add(new Completion(DEFAULT_LOCATOR_ENDPOINTS));
        }
        return completions.size() > 0;
    }
}

