/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.util.function.Function;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ExceptionWithErrorCode;

@Experimental
public class Failure<SuccessType>
implements Result<SuccessType> {
    private final ClientProtocol.ErrorResponse failureType;

    private Failure(ClientProtocol.ErrorResponse failureType) {
        this.failureType = failureType;
    }

    public static <T> Failure<T> of(BasicTypes.ErrorCode errorCode, String errorMessage) {
        return new Failure(ClientProtocol.ErrorResponse.newBuilder().setError(BasicTypes.Error.newBuilder().setErrorCode(errorCode).setMessage(errorMessage)).build());
    }

    public static <T> Failure<T> of(Throwable exception) {
        BasicTypes.ErrorCode errorCode = Failure.getErrorCode(exception);
        return Failure.of(errorCode, Failure.getErrorMessage(exception));
    }

    private static BasicTypes.ErrorCode getErrorCode(Throwable exception) {
        BasicTypes.ErrorCode errorCode = BasicTypes.ErrorCode.SERVER_ERROR;
        if (exception instanceof ExceptionWithErrorCode) {
            errorCode = ((ExceptionWithErrorCode)((Object)exception)).getErrorCode();
        }
        return errorCode;
    }

    private static String getErrorMessage(Throwable exception) {
        StringBuilder message = new StringBuilder(exception.toString());
        while (exception.getCause() != null) {
            message.append(" Caused by: " + exception.getCause());
            exception = exception.getCause();
        }
        return message.toString();
    }

    @Override
    public <T> T map(Function<SuccessType, T> successFunction, Function<ClientProtocol.ErrorResponse, T> errorFunction) {
        return errorFunction.apply(this.failureType);
    }

    @Override
    public SuccessType getMessage() {
        throw new RuntimeException("This is not a Success result");
    }

    @Override
    public ClientProtocol.ErrorResponse getErrorMessage() {
        return this.failureType;
    }
}

