/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import org.apache.geode.redis.internal.ParameterRequirements.EvenParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.ExactParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.MaximumParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.MinimumParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.OddParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.ParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.SlowlogParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.SpopParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.UnspecifiedParameterRequirements;
import org.apache.geode.redis.internal.RedisCommandSupportLevel;
import org.apache.geode.redis.internal.executor.Executor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.UnknownExecutor;
import org.apache.geode.redis.internal.executor.connection.AuthExecutor;
import org.apache.geode.redis.internal.executor.connection.EchoExecutor;
import org.apache.geode.redis.internal.executor.connection.PingExecutor;
import org.apache.geode.redis.internal.executor.connection.QuitExecutor;
import org.apache.geode.redis.internal.executor.connection.SelectExecutor;
import org.apache.geode.redis.internal.executor.hash.HDelExecutor;
import org.apache.geode.redis.internal.executor.hash.HExistsExecutor;
import org.apache.geode.redis.internal.executor.hash.HGetAllExecutor;
import org.apache.geode.redis.internal.executor.hash.HGetExecutor;
import org.apache.geode.redis.internal.executor.hash.HIncrByExecutor;
import org.apache.geode.redis.internal.executor.hash.HIncrByFloatExecutor;
import org.apache.geode.redis.internal.executor.hash.HKeysExecutor;
import org.apache.geode.redis.internal.executor.hash.HLenExecutor;
import org.apache.geode.redis.internal.executor.hash.HMGetExecutor;
import org.apache.geode.redis.internal.executor.hash.HMSetExecutor;
import org.apache.geode.redis.internal.executor.hash.HScanExecutor;
import org.apache.geode.redis.internal.executor.hash.HSetExecutor;
import org.apache.geode.redis.internal.executor.hash.HSetNXExecutor;
import org.apache.geode.redis.internal.executor.hash.HStrLenExecutor;
import org.apache.geode.redis.internal.executor.hash.HValsExecutor;
import org.apache.geode.redis.internal.executor.key.DelExecutor;
import org.apache.geode.redis.internal.executor.key.ExistsExecutor;
import org.apache.geode.redis.internal.executor.key.ExpireAtExecutor;
import org.apache.geode.redis.internal.executor.key.ExpireExecutor;
import org.apache.geode.redis.internal.executor.key.KeysExecutor;
import org.apache.geode.redis.internal.executor.key.PExpireAtExecutor;
import org.apache.geode.redis.internal.executor.key.PExpireExecutor;
import org.apache.geode.redis.internal.executor.key.PTTLExecutor;
import org.apache.geode.redis.internal.executor.key.PersistExecutor;
import org.apache.geode.redis.internal.executor.key.RenameExecutor;
import org.apache.geode.redis.internal.executor.key.ScanExecutor;
import org.apache.geode.redis.internal.executor.key.TTLExecutor;
import org.apache.geode.redis.internal.executor.key.TypeExecutor;
import org.apache.geode.redis.internal.executor.pubsub.PsubscribeExecutor;
import org.apache.geode.redis.internal.executor.pubsub.PublishExecutor;
import org.apache.geode.redis.internal.executor.pubsub.PunsubscribeExecutor;
import org.apache.geode.redis.internal.executor.pubsub.SubscribeExecutor;
import org.apache.geode.redis.internal.executor.pubsub.UnsubscribeExecutor;
import org.apache.geode.redis.internal.executor.server.DBSizeExecutor;
import org.apache.geode.redis.internal.executor.server.FlushAllExecutor;
import org.apache.geode.redis.internal.executor.server.InfoExecutor;
import org.apache.geode.redis.internal.executor.server.ShutDownExecutor;
import org.apache.geode.redis.internal.executor.server.SlowlogExecutor;
import org.apache.geode.redis.internal.executor.server.TimeExecutor;
import org.apache.geode.redis.internal.executor.set.SAddExecutor;
import org.apache.geode.redis.internal.executor.set.SCardExecutor;
import org.apache.geode.redis.internal.executor.set.SDiffExecutor;
import org.apache.geode.redis.internal.executor.set.SDiffStoreExecutor;
import org.apache.geode.redis.internal.executor.set.SInterExecutor;
import org.apache.geode.redis.internal.executor.set.SInterStoreExecutor;
import org.apache.geode.redis.internal.executor.set.SIsMemberExecutor;
import org.apache.geode.redis.internal.executor.set.SMembersExecutor;
import org.apache.geode.redis.internal.executor.set.SMoveExecutor;
import org.apache.geode.redis.internal.executor.set.SPopExecutor;
import org.apache.geode.redis.internal.executor.set.SRandMemberExecutor;
import org.apache.geode.redis.internal.executor.set.SRemExecutor;
import org.apache.geode.redis.internal.executor.set.SScanExecutor;
import org.apache.geode.redis.internal.executor.set.SUnionExecutor;
import org.apache.geode.redis.internal.executor.set.SUnionStoreExecutor;
import org.apache.geode.redis.internal.executor.string.AppendExecutor;
import org.apache.geode.redis.internal.executor.string.BitCountExecutor;
import org.apache.geode.redis.internal.executor.string.BitOpExecutor;
import org.apache.geode.redis.internal.executor.string.BitPosExecutor;
import org.apache.geode.redis.internal.executor.string.DecrByExecutor;
import org.apache.geode.redis.internal.executor.string.DecrExecutor;
import org.apache.geode.redis.internal.executor.string.GetBitExecutor;
import org.apache.geode.redis.internal.executor.string.GetExecutor;
import org.apache.geode.redis.internal.executor.string.GetRangeExecutor;
import org.apache.geode.redis.internal.executor.string.GetSetExecutor;
import org.apache.geode.redis.internal.executor.string.IncrByExecutor;
import org.apache.geode.redis.internal.executor.string.IncrByFloatExecutor;
import org.apache.geode.redis.internal.executor.string.IncrExecutor;
import org.apache.geode.redis.internal.executor.string.MGetExecutor;
import org.apache.geode.redis.internal.executor.string.MSetExecutor;
import org.apache.geode.redis.internal.executor.string.MSetNXExecutor;
import org.apache.geode.redis.internal.executor.string.PSetEXExecutor;
import org.apache.geode.redis.internal.executor.string.SetBitExecutor;
import org.apache.geode.redis.internal.executor.string.SetEXExecutor;
import org.apache.geode.redis.internal.executor.string.SetExecutor;
import org.apache.geode.redis.internal.executor.string.SetNXExecutor;
import org.apache.geode.redis.internal.executor.string.SetRangeExecutor;
import org.apache.geode.redis.internal.executor.string.StrlenExecutor;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public enum RedisCommandType {
    AUTH(new AuthExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    PING(new PingExecutor(), RedisCommandSupportLevel.SUPPORTED, new MaximumParameterRequirements(2)),
    QUIT(new QuitExecutor(), RedisCommandSupportLevel.SUPPORTED),
    DEL(new DelExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(2)),
    EXISTS(new ExistsExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(2)),
    EXPIRE(new ExpireExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    EXPIREAT(new ExpireAtExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    KEYS(new KeysExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    PERSIST(new PersistExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    PEXPIRE(new PExpireExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    PEXPIREAT(new PExpireAtExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    PTTL(new PTTLExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    RENAME(new RenameExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    TTL(new TTLExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    TYPE(new TypeExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    APPEND(new AppendExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    DECR(new DecrExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    DECRBY(new DecrByExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    GET(new GetExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    INCR(new IncrExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    INCRBY(new IncrByExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    GETRANGE(new GetRangeExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(4)),
    INCRBYFLOAT(new IncrByFloatExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    MGET(new MGetExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(2)),
    SET(new SetExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(3)),
    SETNX(new SetNXExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    STRLEN(new StrlenExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    HDEL(new HDelExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(3)),
    HGET(new HGetExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    HGETALL(new HGetAllExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    HINCRBYFLOAT(new HIncrByFloatExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(4)),
    HLEN(new HLenExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    HMGET(new HMGetExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(3)),
    HMSET(new HMSetExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(4).and(new EvenParameterRequirements())),
    HSET(new HSetExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(4).and(new EvenParameterRequirements())),
    HSETNX(new HSetNXExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(4)),
    HSTRLEN(new HStrLenExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    HINCRBY(new HIncrByExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(4)),
    HVALS(new HValsExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    HSCAN(new HScanExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(3), new OddParameterRequirements("syntax error")),
    HEXISTS(new HExistsExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    HKEYS(new HKeysExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    SADD(new SAddExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(3)),
    SMEMBERS(new SMembersExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(2)),
    SREM(new SRemExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(3)),
    SLOWLOG(new SlowlogExecutor(), RedisCommandSupportLevel.SUPPORTED, new SlowlogParameterRequirements()),
    INFO(new InfoExecutor(), RedisCommandSupportLevel.SUPPORTED, new MaximumParameterRequirements(2, "syntax error")),
    SUBSCRIBE(new SubscribeExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(2)),
    PUBLISH(new PublishExecutor(), RedisCommandSupportLevel.SUPPORTED, new ExactParameterRequirements(3)),
    PSUBSCRIBE(new PsubscribeExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(2)),
    PUNSUBSCRIBE(new PunsubscribeExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(1)),
    UNSUBSCRIBE(new UnsubscribeExecutor(), RedisCommandSupportLevel.SUPPORTED, new MinimumParameterRequirements(1)),
    INTERNALPTTL(new UnknownExecutor(), RedisCommandSupportLevel.INTERNAL, new ExactParameterRequirements(2)),
    INTERNALTYPE(new UnknownExecutor(), RedisCommandSupportLevel.INTERNAL, new ExactParameterRequirements(2)),
    INTERNALSMEMBERS(new UnknownExecutor(), RedisCommandSupportLevel.INTERNAL, new ExactParameterRequirements(3)),
    ECHO(new EchoExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(2)),
    SELECT(new SelectExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(2)),
    SCAN(new ScanExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new EvenParameterRequirements("syntax error").and(new MinimumParameterRequirements(2))),
    UNLINK(new DelExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(2)),
    BITCOUNT(new BitCountExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(2)),
    BITOP(new BitOpExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(4)),
    BITPOS(new BitPosExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(3)),
    GETBIT(new GetBitExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(3)),
    GETSET(new GetSetExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(3)),
    MSET(new MSetExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(3).and(new OddParameterRequirements())),
    MSETNX(new MSetNXExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(3).and(new OddParameterRequirements())),
    PSETEX(new PSetEXExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(4)),
    SETBIT(new SetBitExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(4)),
    SETEX(new SetEXExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(4)),
    SETRANGE(new SetRangeExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(4)),
    SCARD(new SCardExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(2)),
    SDIFF(new SDiffExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(2)),
    SDIFFSTORE(new SDiffStoreExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(3)),
    SINTER(new SInterExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(2)),
    SINTERSTORE(new SInterStoreExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(3)),
    SISMEMBER(new SIsMemberExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(3)),
    SMOVE(new SMoveExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(4)),
    SPOP(new SPopExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(2).and(new MaximumParameterRequirements(3, "syntax error")).and(new SpopParameterRequirements())),
    SRANDMEMBER(new SRandMemberExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(2)),
    SSCAN(new SScanExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(3), new OddParameterRequirements("syntax error")),
    SUNION(new SUnionExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(2)),
    SUNIONSTORE(new SUnionStoreExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MinimumParameterRequirements(3)),
    DBSIZE(new DBSizeExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(1)),
    FLUSHALL(new FlushAllExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MaximumParameterRequirements(2, "syntax error")),
    FLUSHDB(new FlushAllExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MaximumParameterRequirements(2, "syntax error")),
    SHUTDOWN(new ShutDownExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new MaximumParameterRequirements(2, "syntax error")),
    TIME(new TimeExecutor(), RedisCommandSupportLevel.UNSUPPORTED, new ExactParameterRequirements(1)),
    UNKNOWN(new UnknownExecutor(), RedisCommandSupportLevel.UNKNOWN);

    private final Executor executor;
    private final ParameterRequirements parameterRequirements;
    private final ParameterRequirements deferredParameterRequirements;
    private final RedisCommandSupportLevel supportLevel;

    private RedisCommandType(Executor executor, RedisCommandSupportLevel supportLevel) {
        this(executor, supportLevel, new UnspecifiedParameterRequirements());
    }

    private RedisCommandType(Executor executor, RedisCommandSupportLevel supportLevel, ParameterRequirements parameterRequirements) {
        this(executor, supportLevel, parameterRequirements, new UnspecifiedParameterRequirements());
    }

    private RedisCommandType(Executor executor, RedisCommandSupportLevel supportLevel, ParameterRequirements parameterRequirements, ParameterRequirements deferredParameterRequirements) {
        this.executor = executor;
        this.supportLevel = supportLevel;
        this.parameterRequirements = parameterRequirements;
        this.deferredParameterRequirements = deferredParameterRequirements;
    }

    public boolean isSupported() {
        return this.supportLevel == RedisCommandSupportLevel.SUPPORTED;
    }

    public boolean isUnsupported() {
        return this.supportLevel == RedisCommandSupportLevel.UNSUPPORTED;
    }

    public boolean isInternal() {
        return this.supportLevel == RedisCommandSupportLevel.INTERNAL;
    }

    public boolean isUnknown() {
        return this.supportLevel == RedisCommandSupportLevel.UNKNOWN;
    }

    public boolean isAllowedWhileSubscribed() {
        switch (this) {
            case SUBSCRIBE: 
            case PSUBSCRIBE: 
            case UNSUBSCRIBE: 
            case PUNSUBSCRIBE: 
            case PING: 
            case QUIT: {
                return true;
            }
        }
        return false;
    }

    public void checkDeferredParameters(Command command, ExecutionHandlerContext executionHandlerContext) {
        this.deferredParameterRequirements.checkParameters(command, executionHandlerContext);
    }

    public RedisResponse executeCommand(Command command, ExecutionHandlerContext executionHandlerContext) {
        this.parameterRequirements.checkParameters(command, executionHandlerContext);
        return this.executor.executeCommand(command, executionHandlerContext);
    }
}

