/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.redis.internal.data.AbstractRedisData;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisDataType;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.delta.AddsDeltaInfo;
import org.apache.geode.redis.internal.delta.DeltaInfo;
import org.apache.geode.redis.internal.delta.RemsDeltaInfo;
import org.apache.geode.redis.internal.netty.Coder;

public class RedisHash
extends AbstractRedisData {
    private HashMap<ByteArrayWrapper, ByteArrayWrapper> hash = new HashMap();
    private ConcurrentHashMap<UUID, List<ByteArrayWrapper>> hScanSnapShots = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Long> hScanSnapShotCreationTimes = new ConcurrentHashMap();
    private ScheduledExecutorService HSCANSnapshotExpirationExecutor = null;
    private static int defaultHscanSnapshotsExpireCheckFrequency = Integer.getInteger("redis.hscan-snapshot-cleanup-interval", 30000);
    private static int defaultHscanSnapshotsMillisecondsToLive = Integer.getInteger("redis.hscan-snapshot-expiry", 30000);
    private int HSCAN_SNAPSHOTS_EXPIRE_CHECK_FREQUENCY_MILLISECONDS = defaultHscanSnapshotsExpireCheckFrequency;
    private int MINIMUM_MILLISECONDS_FOR_HSCAN_SNAPSHOTS_TO_LIVE = defaultHscanSnapshotsMillisecondsToLive;

    @VisibleForTesting
    public RedisHash(List<ByteArrayWrapper> fieldsToSet, int hscanSnapShotExpirationCheckFrequency, int minimumLifeForHscanSnaphot) {
        this();
        this.HSCAN_SNAPSHOTS_EXPIRE_CHECK_FREQUENCY_MILLISECONDS = hscanSnapShotExpirationCheckFrequency;
        this.MINIMUM_MILLISECONDS_FOR_HSCAN_SNAPSHOTS_TO_LIVE = minimumLifeForHscanSnaphot;
        Iterator<ByteArrayWrapper> iterator = fieldsToSet.iterator();
        while (iterator.hasNext()) {
            this.hashPut(iterator.next(), iterator.next());
        }
    }

    public RedisHash(List<ByteArrayWrapper> fieldsToSet) {
        this(fieldsToSet, defaultHscanSnapshotsExpireCheckFrequency, defaultHscanSnapshotsMillisecondsToLive);
    }

    public RedisHash() {
    }

    private void expireHScanSnapshots() {
        this.hScanSnapShotCreationTimes.entrySet().forEach(entry -> {
            Long creationTime = (Long)entry.getValue();
            long millisecondsSinceCreation = System.currentTimeMillis() - creationTime;
            if (millisecondsSinceCreation >= (long)this.MINIMUM_MILLISECONDS_FOR_HSCAN_SNAPSHOTS_TO_LIVE) {
                UUID client = (UUID)entry.getKey();
                this.removeHSCANSnapshot(client);
            }
        });
    }

    @VisibleForTesting
    public ConcurrentHashMap<UUID, List<ByteArrayWrapper>> getHscanSnapShots() {
        return this.hScanSnapShots;
    }

    private void startHscanSnapshotScheduledRemoval() {
        int DELAY = this.HSCAN_SNAPSHOTS_EXPIRE_CHECK_FREQUENCY_MILLISECONDS;
        this.HSCANSnapshotExpirationExecutor = LoggingExecutors.newSingleThreadScheduledExecutor((String)"GemFireRedis-HSCANSnapshotRemoval-");
        this.HSCANSnapshotExpirationExecutor.scheduleWithFixedDelay(this::expireHScanSnapshots, DELAY, DELAY, TimeUnit.MILLISECONDS);
    }

    private void shutDownHscanSnapshotScheduledRemoval() {
        this.HSCANSnapshotExpirationExecutor.shutdown();
        this.HSCANSnapshotExpirationExecutor = null;
    }

    @Override
    public synchronized void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeHashMap(this.hash, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.hash = DataSerializer.readHashMap((DataInput)in);
    }

    public int getDSFID() {
        return 2188;
    }

    private synchronized ByteArrayWrapper hashPut(ByteArrayWrapper field, ByteArrayWrapper value) {
        return this.hash.put(field, value);
    }

    private synchronized ByteArrayWrapper hashPutIfAbsent(ByteArrayWrapper field, ByteArrayWrapper value) {
        return this.hash.putIfAbsent(field, value);
    }

    private synchronized ByteArrayWrapper hashRemove(ByteArrayWrapper field) {
        return this.hash.remove(field);
    }

    @Override
    protected void applyDelta(DeltaInfo deltaInfo) {
        if (deltaInfo instanceof AddsDeltaInfo) {
            AddsDeltaInfo addsDeltaInfo = (AddsDeltaInfo)deltaInfo;
            Iterator<ByteArrayWrapper> iterator = addsDeltaInfo.getAdds().iterator();
            while (iterator.hasNext()) {
                ByteArrayWrapper field = iterator.next();
                ByteArrayWrapper value = iterator.next();
                this.hashPut(field, value);
            }
        } else {
            RemsDeltaInfo remsDeltaInfo = (RemsDeltaInfo)deltaInfo;
            for (ByteArrayWrapper field : remsDeltaInfo.getRemoves()) {
                this.hashRemove(field);
            }
        }
    }

    public int hset(Region<RedisKey, RedisData> region, RedisKey key, List<ByteArrayWrapper> fieldsToSet, boolean nx) {
        int fieldsAdded = 0;
        AddsDeltaInfo deltaInfo = null;
        Iterator<ByteArrayWrapper> iterator = fieldsToSet.iterator();
        while (iterator.hasNext()) {
            boolean newField;
            ByteArrayWrapper field = iterator.next();
            ByteArrayWrapper value = iterator.next();
            boolean added = true;
            if (nx) {
                added = newField = this.hashPutIfAbsent(field, value) == null;
            } else {
                boolean bl = newField = this.hashPut(field, value) == null;
            }
            if (added) {
                if (deltaInfo == null) {
                    deltaInfo = new AddsDeltaInfo();
                }
                deltaInfo.add(field);
                deltaInfo.add(value);
            }
            if (!newField) continue;
            ++fieldsAdded;
        }
        this.storeChanges(region, key, deltaInfo);
        return fieldsAdded;
    }

    public int hdel(Region<RedisKey, RedisData> region, RedisKey key, List<ByteArrayWrapper> fieldsToRemove) {
        int fieldsRemoved = 0;
        RemsDeltaInfo deltaInfo = null;
        for (ByteArrayWrapper fieldToRemove : fieldsToRemove) {
            if (this.hashRemove(fieldToRemove) == null) continue;
            if (deltaInfo == null) {
                deltaInfo = new RemsDeltaInfo();
            }
            deltaInfo.add(fieldToRemove);
            ++fieldsRemoved;
        }
        this.storeChanges(region, key, deltaInfo);
        return fieldsRemoved;
    }

    public Collection<ByteArrayWrapper> hgetall() {
        ArrayList<ByteArrayWrapper> result = new ArrayList<ByteArrayWrapper>();
        for (Map.Entry<ByteArrayWrapper, ByteArrayWrapper> entry : this.hash.entrySet()) {
            result.add(entry.getKey());
            result.add(entry.getValue());
        }
        return result;
    }

    public int hexists(ByteArrayWrapper field) {
        if (this.hash.containsKey(field)) {
            return 1;
        }
        return 0;
    }

    public ByteArrayWrapper hget(ByteArrayWrapper field) {
        return this.hash.get(field);
    }

    public int hlen() {
        return this.hash.size();
    }

    public int hstrlen(ByteArrayWrapper field) {
        ByteArrayWrapper entry = this.hget(field);
        return entry != null ? entry.length() : 0;
    }

    public List<ByteArrayWrapper> hmget(List<ByteArrayWrapper> fields) {
        ArrayList<ByteArrayWrapper> results = new ArrayList<ByteArrayWrapper>(fields.size());
        for (ByteArrayWrapper field : fields) {
            results.add(this.hash.get(field));
        }
        return results;
    }

    public Collection<ByteArrayWrapper> hvals() {
        return new ArrayList<ByteArrayWrapper>(this.hash.values());
    }

    public Collection<ByteArrayWrapper> hkeys() {
        return new ArrayList<ByteArrayWrapper>(this.hash.keySet());
    }

    public ImmutablePair<Integer, List<Object>> hscan(UUID clientID, Pattern matchPattern, int count, int startCursor) {
        List<ByteArrayWrapper> keysToScan = this.getSnapShotOfKeySet(clientID);
        Pair<Integer, List<Object>> resultsPair = this.getResultsPair(keysToScan, startCursor, count, matchPattern);
        List resultList = (List)resultsPair.getRight();
        Integer numberOfIterationsCompleted = (Integer)resultsPair.getLeft();
        int returnCursorValueAsInt = this.getCursorValueToReturn(startCursor, numberOfIterationsCompleted, keysToScan);
        if (returnCursorValueAsInt == 0) {
            this.removeHSCANSnapshot(clientID);
        }
        return new ImmutablePair((Object)returnCursorValueAsInt, (Object)resultList);
    }

    private void removeHSCANSnapshot(UUID clientID) {
        this.hScanSnapShots.remove(clientID);
        this.hScanSnapShotCreationTimes.remove(clientID);
        if (this.hScanSnapShots.isEmpty()) {
            this.shutDownHscanSnapshotScheduledRemoval();
        }
    }

    private Pair<Integer, List<Object>> getResultsPair(List<ByteArrayWrapper> keysSnapShot, int startCursor, int count, Pattern matchPattern) {
        int indexOfKeys = startCursor;
        ArrayList<ByteArrayWrapper> resultList = new ArrayList<ByteArrayWrapper>();
        for (int index = startCursor; index < keysSnapShot.size() && index - startCursor != count; ++index) {
            ByteArrayWrapper key = keysSnapShot.get(index);
            ++indexOfKeys;
            ByteArrayWrapper value = this.hash.get(key);
            if (value == null) continue;
            if (matchPattern != null) {
                if (!matchPattern.matcher(key.toString()).matches()) continue;
                resultList.add(key);
                resultList.add(value);
                continue;
            }
            resultList.add(key);
            resultList.add(value);
        }
        Integer numberOfIterationsCompleted = indexOfKeys - startCursor;
        return new ImmutablePair((Object)numberOfIterationsCompleted, resultList);
    }

    private int getCursorValueToReturn(int startCursor, int numberOfIterationsCompleted, List<ByteArrayWrapper> keySnapshot) {
        if (startCursor + numberOfIterationsCompleted >= keySnapshot.size()) {
            return 0;
        }
        return startCursor + numberOfIterationsCompleted;
    }

    private List<ByteArrayWrapper> getSnapShotOfKeySet(UUID clientID) {
        List<ByteArrayWrapper> keySnapShot = this.hScanSnapShots.get(clientID);
        if (keySnapShot == null) {
            if (this.hScanSnapShots.isEmpty()) {
                this.startHscanSnapshotScheduledRemoval();
            }
            keySnapShot = this.createKeySnapShot(clientID);
        }
        return keySnapShot;
    }

    private List<ByteArrayWrapper> createKeySnapShot(UUID clientID) {
        List<ByteArrayWrapper> keySnapShot = this.hash.keySet().stream().map(key -> new ByteArrayWrapper(key.toBytes())).collect(Collectors.toList());
        this.hScanSnapShots.put(clientID, keySnapShot);
        this.hScanSnapShotCreationTimes.put(clientID, System.currentTimeMillis());
        return keySnapShot;
    }

    public long hincrby(Region<RedisKey, RedisData> region, RedisKey key, ByteArrayWrapper field, long increment) throws NumberFormatException, ArithmeticException {
        long value;
        ByteArrayWrapper oldValue = this.hash.get(field);
        if (oldValue == null) {
            ByteArrayWrapper newValue = new ByteArrayWrapper(Coder.longToBytes(increment));
            this.hashPut(field, newValue);
            AddsDeltaInfo deltaInfo = new AddsDeltaInfo();
            deltaInfo.add(field);
            deltaInfo.add(newValue);
            this.storeChanges(region, key, deltaInfo);
            return increment;
        }
        try {
            value = Long.parseLong(oldValue.toString());
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("value is not an integer or out of range");
        }
        if (value >= 0L && increment > Long.MAX_VALUE - value || value <= 0L && increment < Long.MIN_VALUE - value) {
            throw new ArithmeticException("increment or decrement would overflow");
        }
        ByteArrayWrapper modifiedValue = new ByteArrayWrapper(Coder.longToBytes(value += increment));
        this.hashPut(field, modifiedValue);
        AddsDeltaInfo deltaInfo = new AddsDeltaInfo();
        deltaInfo.add(field);
        deltaInfo.add(modifiedValue);
        this.storeChanges(region, key, deltaInfo);
        return value;
    }

    public BigDecimal hincrbyfloat(Region<RedisKey, RedisData> region, RedisKey key, ByteArrayWrapper field, BigDecimal increment) throws NumberFormatException {
        BigDecimal value;
        ByteArrayWrapper oldValue = this.hash.get(field);
        if (oldValue == null) {
            ByteArrayWrapper newValue = new ByteArrayWrapper(Coder.bigDecimalToBytes(increment));
            this.hashPut(field, newValue);
            AddsDeltaInfo deltaInfo = new AddsDeltaInfo();
            deltaInfo.add(field);
            deltaInfo.add(newValue);
            this.storeChanges(region, key, deltaInfo);
            return increment.stripTrailingZeros();
        }
        String valueS = oldValue.toString();
        if (valueS.contains(" ")) {
            throw new NumberFormatException("hash value is not a float");
        }
        try {
            value = new BigDecimal(valueS);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("hash value is not a float");
        }
        value = value.add(increment);
        ByteArrayWrapper modifiedValue = new ByteArrayWrapper(Coder.bigDecimalToBytes(value));
        this.hashPut(field, modifiedValue);
        AddsDeltaInfo deltaInfo = new AddsDeltaInfo();
        deltaInfo.add(field);
        deltaInfo.add(modifiedValue);
        this.storeChanges(region, key, deltaInfo);
        return value.stripTrailingZeros();
    }

    @Override
    public RedisDataType getType() {
        return RedisDataType.REDIS_HASH;
    }

    @Override
    protected boolean removeFromRegion() {
        return this.hash.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisHash)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RedisHash redisHash = (RedisHash)o;
        return Objects.equals(this.hash, redisHash.hash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hash);
    }

    @Override
    public String toString() {
        return "RedisHash{" + super.toString() + ", hash=" + this.hash + '}';
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

