/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.redis.internal.data.AbstractRedisData;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisDataType;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.delta.AddsDeltaInfo;
import org.apache.geode.redis.internal.delta.DeltaInfo;
import org.apache.geode.redis.internal.delta.RemsDeltaInfo;

public class RedisSet
extends AbstractRedisData {
    private HashSet<ByteArrayWrapper> members;

    RedisSet(Collection<ByteArrayWrapper> members) {
        this.members = members instanceof HashSet ? (HashSet<Object>)members : new HashSet<ByteArrayWrapper>(members);
    }

    public RedisSet() {
    }

    Pair<BigInteger, List<Object>> sscan(Pattern matchPattern, int count, BigInteger cursor) {
        ArrayList<ByteArrayWrapper> returnList = new ArrayList<ByteArrayWrapper>();
        int size = this.members.size();
        BigInteger beforeCursor = new BigInteger("0");
        int numElements = 0;
        int i = -1;
        for (ByteArrayWrapper value : this.members) {
            ++i;
            if (beforeCursor.compareTo(cursor) < 0) {
                beforeCursor = beforeCursor.add(new BigInteger("1"));
                continue;
            }
            if (matchPattern != null) {
                if (matchPattern.matcher(value.toString()).matches()) {
                    returnList.add(value);
                    ++numElements;
                }
            } else {
                returnList.add(value);
                ++numElements;
            }
            if (numElements != count) continue;
            break;
        }
        ImmutablePair scanResult = i >= size - 1 ? new ImmutablePair((Object)new BigInteger("0"), returnList) : new ImmutablePair((Object)new BigInteger(String.valueOf(i + 1)), returnList);
        return scanResult;
    }

    Collection<ByteArrayWrapper> spop(Region<RedisKey, RedisData> region, RedisKey key, int popCount) {
        int originalSize = this.scard();
        if (originalSize == 0) {
            return Collections.emptyList();
        }
        if (popCount >= originalSize) {
            region.remove((Object)key, (Object)this);
            return this.members;
        }
        ArrayList<ByteArrayWrapper> popped = new ArrayList<ByteArrayWrapper>();
        ByteArrayWrapper[] setMembers = this.members.toArray(new ByteArrayWrapper[originalSize]);
        Random rand = new Random();
        while (popped.size() < popCount) {
            int idx = rand.nextInt(originalSize);
            ByteArrayWrapper memberToPop = setMembers[idx];
            if (memberToPop == null) continue;
            setMembers[idx] = null;
            popped.add(memberToPop);
            this.membersRemove(memberToPop);
        }
        if (!popped.isEmpty()) {
            this.storeChanges(region, key, new RemsDeltaInfo(popped));
        }
        return popped;
    }

    Collection<ByteArrayWrapper> srandmember(int count) {
        boolean duplicatesAllowed;
        int membersSize = this.members.size();
        boolean bl = duplicatesAllowed = count < 0;
        if (duplicatesAllowed) {
            count = -count;
        }
        if (!duplicatesAllowed && membersSize <= count && count != 1) {
            return new ArrayList<ByteArrayWrapper>(this.members);
        }
        Random rand = new Random();
        ByteArrayWrapper[] entries = this.members.toArray(new ByteArrayWrapper[membersSize]);
        if (count == 1) {
            ByteArrayWrapper randEntry = entries[rand.nextInt(entries.length)];
            ArrayList<ByteArrayWrapper> result = new ArrayList<ByteArrayWrapper>(1);
            result.add(randEntry);
            return result;
        }
        if (duplicatesAllowed) {
            ArrayList<ByteArrayWrapper> result = new ArrayList<ByteArrayWrapper>(count);
            while (count > 0) {
                result.add(entries[rand.nextInt(entries.length)]);
                --count;
            }
            return result;
        }
        HashSet<ByteArrayWrapper> result = new HashSet<ByteArrayWrapper>();
        while (result.size() < count) {
            ByteArrayWrapper s = entries[rand.nextInt(entries.length)];
            result.add(s);
        }
        return result;
    }

    public boolean sismember(ByteArrayWrapper member) {
        return this.members.contains(member);
    }

    public int scard() {
        return this.members.size();
    }

    @Override
    protected void applyDelta(DeltaInfo deltaInfo) {
        if (deltaInfo instanceof AddsDeltaInfo) {
            AddsDeltaInfo addsDeltaInfo = (AddsDeltaInfo)deltaInfo;
            this.membersAddAll(addsDeltaInfo);
        } else {
            RemsDeltaInfo remsDeltaInfo = (RemsDeltaInfo)deltaInfo;
            this.membersRemoveAll(remsDeltaInfo);
        }
    }

    @Override
    public synchronized void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        InternalDataSerializer.writeHashSet(this.members, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.members = InternalDataSerializer.readHashSet((DataInput)in);
    }

    public int getDSFID() {
        return 2186;
    }

    private synchronized boolean membersAdd(ByteArrayWrapper memberToAdd) {
        return this.members.add(memberToAdd);
    }

    private boolean membersRemove(ByteArrayWrapper memberToRemove) {
        return this.members.remove(memberToRemove);
    }

    private synchronized boolean membersAddAll(AddsDeltaInfo addsDeltaInfo) {
        return this.members.addAll(addsDeltaInfo.getAdds());
    }

    private synchronized boolean membersRemoveAll(RemsDeltaInfo remsDeltaInfo) {
        return this.members.removeAll(remsDeltaInfo.getRemoves());
    }

    long sadd(ArrayList<ByteArrayWrapper> membersToAdd, Region<RedisKey, RedisData> region, RedisKey key) {
        membersToAdd.removeIf(memberToAdd -> !this.membersAdd((ByteArrayWrapper)memberToAdd));
        int membersAdded = membersToAdd.size();
        if (membersAdded != 0) {
            this.storeChanges(region, key, new AddsDeltaInfo(membersToAdd));
        }
        return membersAdded;
    }

    long srem(ArrayList<ByteArrayWrapper> membersToRemove, Region<RedisKey, RedisData> region, RedisKey key) {
        membersToRemove.removeIf(memberToRemove -> !this.membersRemove((ByteArrayWrapper)memberToRemove));
        int membersRemoved = membersToRemove.size();
        if (membersRemoved != 0) {
            this.storeChanges(region, key, new RemsDeltaInfo(membersToRemove));
        }
        return membersRemoved;
    }

    @VisibleForTesting
    Set<ByteArrayWrapper> smembers() {
        return new HashSet<ByteArrayWrapper>(this.members);
    }

    @Override
    public RedisDataType getType() {
        return RedisDataType.REDIS_SET;
    }

    @Override
    protected boolean removeFromRegion() {
        return this.members.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisSet)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RedisSet redisSet = (RedisSet)o;
        return Objects.equals(this.members, redisSet.members);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.members);
    }

    @Override
    public String toString() {
        return "RedisSet{" + super.toString() + ", members=" + this.members + '}';
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

