/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.math.BigDecimal;
import java.util.List;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.NullRedisDataStructures;
import org.apache.geode.redis.internal.data.RedisDataCommandsFunctionExecutor;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.data.RedisString;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.SetOptions;

public class RedisStringCommandsFunctionExecutor
extends RedisDataCommandsFunctionExecutor
implements RedisStringCommands {
    public RedisStringCommandsFunctionExecutor(CommandHelper helper) {
        super(helper);
    }

    private RedisString getRedisString(RedisKey key, boolean updateStats) {
        return this.helper.getRedisString(key, updateStats);
    }

    private RedisString getRedisStringIgnoringType(RedisKey key, boolean updateStats) {
        return this.helper.getRedisStringIgnoringType(key, updateStats);
    }

    @Override
    public long append(RedisKey key, ByteArrayWrapper valueToAppend) {
        return this.stripedExecute(key, () -> this.getRedisString(key, false).append(valueToAppend, this.getRegion(), key)).intValue();
    }

    @Override
    public ByteArrayWrapper get(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisString(key, true).get());
    }

    @Override
    public ByteArrayWrapper mget(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisStringIgnoringType(key, true).get());
    }

    @Override
    public boolean set(RedisKey key, ByteArrayWrapper value, SetOptions options) {
        return this.stripedExecute(key, () -> NullRedisDataStructures.NULL_REDIS_STRING.set(this.helper, key, value, options));
    }

    @Override
    public long incr(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisString(key, false).incr(this.getRegion(), key));
    }

    @Override
    public long decr(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisString(key, false).decr(this.getRegion(), key));
    }

    @Override
    public ByteArrayWrapper getset(RedisKey key, ByteArrayWrapper value) {
        return this.stripedExecute(key, () -> this.getRedisString(key, true).getset(this.getRegion(), key, value));
    }

    @Override
    public long incrby(RedisKey key, long increment) {
        return this.stripedExecute(key, () -> this.getRedisString(key, false).incrby(this.getRegion(), key, increment));
    }

    @Override
    public BigDecimal incrbyfloat(RedisKey key, BigDecimal increment) {
        return this.stripedExecute(key, () -> this.getRedisString(key, false).incrbyfloat(this.getRegion(), key, increment));
    }

    @Override
    public int bitop(String operation, RedisKey key, List<RedisKey> sources) {
        return NullRedisDataStructures.NULL_REDIS_STRING.bitop(this.helper, operation, key, sources);
    }

    @Override
    public long decrby(RedisKey key, long decrement) {
        return this.stripedExecute(key, () -> this.getRedisString(key, false).decrby(this.getRegion(), key, decrement));
    }

    @Override
    public ByteArrayWrapper getrange(RedisKey key, long start, long end) {
        return this.stripedExecute(key, () -> this.getRedisString(key, true).getrange(start, end));
    }

    @Override
    public int setrange(RedisKey key, int offset, byte[] value) {
        return this.stripedExecute(key, () -> this.getRedisString(key, false).setrange(this.getRegion(), key, offset, value));
    }

    @Override
    public int bitpos(RedisKey key, int bit, int start, Integer end) {
        return this.stripedExecute(key, () -> this.getRedisString(key, true).bitpos(this.getRegion(), key, bit, start, end));
    }

    @Override
    public long bitcount(RedisKey key, int start, int end) {
        return this.stripedExecute(key, () -> this.getRedisString(key, true).bitcount(start, end));
    }

    @Override
    public long bitcount(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisString(key, true).bitcount());
    }

    @Override
    public int strlen(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisString(key, true).strlen());
    }

    @Override
    public int getbit(RedisKey key, int offset) {
        return this.stripedExecute(key, () -> this.getRedisString(key, true).getbit(offset));
    }

    @Override
    public int setbit(RedisKey key, long offset, int value) {
        int byteIndex = (int)(offset / 8L);
        byte bitIndex = (byte)(offset % 8L);
        return this.stripedExecute(key, () -> this.getRedisString(key, false).setbit(this.getRegion(), key, value, byteIndex, bitIndex));
    }
}

