/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.Collections;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.internal.cache.PrimaryBucketLockException;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.CommandFunction;
import org.apache.geode.redis.internal.executor.SingleResultCollector;

public abstract class RedisCommandsFunctionInvoker {
    protected final Region<RedisKey, RedisData> region;

    protected RedisCommandsFunctionInvoker(Region<RedisKey, RedisData> region) {
        this.region = region;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T invoke(String functionId, Object filter, Object ... arguments) {
        while (true) {
            SingleResultCollector resultsCollector = new SingleResultCollector();
            try {
                FunctionService.onRegion(this.region).withFilter(Collections.singleton(filter)).setArguments((Object)arguments).withCollector(resultsCollector).execute(functionId).getResult();
                return resultsCollector.getResult();
            }
            catch (PrimaryBucketLockException ex) {
                continue;
            }
            catch (FunctionException ex) {
                Throwable initialCause;
                if (!ex.getMessage().equals("Function named " + functionId + " is not registered to FunctionService") && !((initialCause = CommandFunction.getInitialCause(ex)) instanceof PrimaryBucketLockException)) throw ex;
                continue;
            }
            break;
        }
    }

    protected <T> T invokeCommandFunction(RedisKey key, Object ... arguments) {
        return this.invoke("REDIS_COMMAND_FUNCTION", key, arguments);
    }
}

