/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.List;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class UnknownExecutor
extends AbstractExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        StringBuilder commandArguments = new StringBuilder();
        String commandText = null;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems != null && !commandElems.isEmpty()) {
            commandText = Coder.bytesToString(commandElems.get(0));
            if (commandElems.size() > 1) {
                for (int i = 1; i < commandElems.size(); ++i) {
                    if (commandElems.get(i) == null) continue;
                    commandArguments.append("`").append(Coder.bytesToString(commandElems.get(i))).append("`, ");
                }
            }
        }
        return RedisResponse.error(String.format("unknown command `%s`, with args beginning with: %s", commandText, commandArguments));
    }
}

