/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.key;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.key.RedisKeyCommands;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class ExpireAtExecutor
extends AbstractExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        long timestamp;
        List<byte[]> commandElems = command.getProcessedCommand();
        int TIMESTAMP_INDEX = 2;
        RedisKey wKey = command.getKey();
        byte[] timestampByteArray = commandElems.get(TIMESTAMP_INDEX);
        try {
            timestamp = Coder.bytesToLong(timestampByteArray);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error("value is not an integer or out of range");
        }
        if (!this.timeUnitMillis()) {
            timestamp = TimeUnit.SECONDS.toMillis(timestamp);
        }
        RedisKeyCommands redisKeyCommands = this.getRedisKeyCommands(context);
        int result = redisKeyCommands.pexpireat(wKey, timestamp);
        return RedisResponse.integer(result);
    }

    protected boolean timeUnitMillis() {
        return false;
    }
}

