/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class GetBitExecutor
extends StringExecutor {
    private static final String ERROR_NOT_INT = "The offset provided must be numeric";

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        int offset;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey key = command.getKey();
        try {
            byte[] offAr = commandElems.get(2);
            offset = Coder.bytesToInt(offAr);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error(ERROR_NOT_INT);
        }
        int result = this.getRedisStringCommands(context).getbit(key, offset);
        return RedisResponse.integer(result);
    }
}

