/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.SetOptions;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SetExecutor
extends StringExecutor {
    private static final String SUCCESS = "OK";

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        SetOptions setOptions;
        RedisKey keyToSet = command.getKey();
        List<byte[]> commandElementsBytes = command.getProcessedCommand();
        List<byte[]> optionalParameterBytes = this.getOptionalParameters(commandElementsBytes);
        ByteArrayWrapper valueToSet = this.getValueToSet(commandElementsBytes);
        RedisStringCommands redisStringCommands = this.getRedisStringCommands(context);
        try {
            setOptions = this.parseOptionalParameters(optionalParameterBytes);
        }
        catch (IllegalArgumentException ex) {
            return RedisResponse.error(ex.getMessage());
        }
        return this.doSet(keyToSet, valueToSet, redisStringCommands, setOptions);
    }

    private List<byte[]> getOptionalParameters(List<byte[]> commandElementsBytes) {
        return commandElementsBytes.subList(3, commandElementsBytes.size());
    }

    private RedisResponse doSet(RedisKey key, ByteArrayWrapper value, RedisStringCommands redisStringCommands, SetOptions setOptions) {
        boolean setCompletedSuccessfully = redisStringCommands.set(key, value, setOptions);
        if (setCompletedSuccessfully) {
            return RedisResponse.string(SUCCESS);
        }
        return RedisResponse.nil();
    }

    private ByteArrayWrapper getValueToSet(List<byte[]> commandElems) {
        byte[] value = commandElems.get(2);
        return new ByteArrayWrapper(value);
    }

    private SetOptions parseOptionalParameters(List<byte[]> optionalParameterBytes) throws IllegalArgumentException {
        boolean keepTTL = false;
        SetOptions.Exists existsOption = SetOptions.Exists.NONE;
        long millisecondsUntilExpiration = 0L;
        List<String> optionalParametersStrings = optionalParameterBytes.stream().map(item -> Coder.bytesToString(item).toUpperCase()).collect(Collectors.toList());
        this.throwExceptionIfIncompatableParameterOptions(optionalParametersStrings);
        this.throwErrorIfNumberInWrongPosition(optionalParametersStrings);
        this.throwExceptionIfUnknownParameter(optionalParametersStrings);
        if (optionalParametersStrings.contains("PX")) {
            millisecondsUntilExpiration = this.handleExpiration(optionalParametersStrings, "PX");
        } else if (optionalParametersStrings.contains("EX")) {
            millisecondsUntilExpiration = this.handleExpiration(optionalParametersStrings, "EX");
        }
        if (optionalParametersStrings.contains("NX")) {
            existsOption = SetOptions.Exists.NX;
        } else if (optionalParametersStrings.contains("XX")) {
            existsOption = SetOptions.Exists.XX;
        }
        return new SetOptions(existsOption, millisecondsUntilExpiration, keepTTL);
    }

    private long handleExpiration(List<String> optionalParametersStrings, String expirationType) {
        String nextParameter = this.getNextParameter(expirationType, optionalParametersStrings);
        long timeUntilExpiration = this.convertToLongOrThrowException(nextParameter);
        if (timeUntilExpiration <= 0L) {
            throw new IllegalArgumentException("invalid expire time in set");
        }
        long millisecondsUntilExpiration = expirationType.equals("EX") ? TimeUnit.SECONDS.toMillis(timeUntilExpiration) : timeUntilExpiration;
        return millisecondsUntilExpiration;
    }

    private String getNextParameter(String currentParameter, List<String> optionalParametersStrings) {
        int index = optionalParametersStrings.indexOf(currentParameter);
        if (optionalParametersStrings.size() <= index + 1) {
            throw new IllegalArgumentException("syntax error");
        }
        return optionalParametersStrings.get(index + 1);
    }

    private void throwExceptionIfUnknownParameter(List<String> optionalParameters) {
        List<String> validOptionalParamaters = Arrays.asList("EX", "PX", "NX", "XX");
        List<String> parametersInQuestion = optionalParameters.stream().filter(parameter -> !validOptionalParamaters.contains(parameter)).collect(Collectors.toList());
        parametersInQuestion.forEach(parameter -> {
            int index = optionalParameters.indexOf(parameter);
            if (!this.isANumber((String)parameter)) {
                if (index == 0) {
                    throw new IllegalArgumentException("syntax error");
                }
                String previousParameter = (String)optionalParameters.get(index - 1);
                if (this.previousOptionIsValidAndExpectsANumber(previousParameter)) {
                    throw new IllegalArgumentException("value is not an integer or out of range");
                }
                throw new IllegalArgumentException("syntax error");
            }
        });
    }

    private boolean previousOptionIsValidAndExpectsANumber(String previousParameter) {
        List<String> validParamaters = Arrays.asList("EX", "PX");
        return validParamaters.contains(previousParameter);
    }

    private void throwErrorIfNumberInWrongPosition(List<String> optionalParameters) {
        for (int i = 0; i < optionalParameters.size(); ++i) {
            String parameter = optionalParameters.get(i);
            if (!this.isANumber(parameter)) continue;
            if (i == 0) {
                throw new IllegalArgumentException("syntax error");
            }
            String previousParameter = optionalParameters.get(i - 1);
            if (this.previousOptionIsValidAndExpectsANumber(previousParameter)) continue;
            throw new IllegalArgumentException("syntax error");
        }
    }

    private boolean isANumber(String parameter) {
        try {
            Long.parseLong(parameter);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void throwExceptionIfIncompatableParameterOptions(List<String> passedParametersStrings) {
        if (passedParametersStrings.contains("PX") && passedParametersStrings.contains("EX")) {
            throw new IllegalArgumentException("syntax error");
        }
        if (passedParametersStrings.contains("XX") && passedParametersStrings.contains("NX")) {
            throw new IllegalArgumentException("syntax error");
        }
    }

    private long convertToLongOrThrowException(String expirationTime) {
        try {
            return Long.parseLong(expirationTime);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("value is not an integer or out of range");
        }
    }
}

