/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.netty;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.UUID;

public class Client {
    private Channel channel;
    private UUID id;

    public Client(Channel remoteAddress) {
        this.channel = remoteAddress;
        this.id = UUID.randomUUID();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals(this.channel, client.channel);
    }

    public int hashCode() {
        return Objects.hash(this.channel);
    }

    public void addShutdownListener(GenericFutureListener<? extends Future<? super Void>> shutdownListener) {
        this.channel.closeFuture().addListener(shutdownListener);
    }

    public boolean isDead() {
        return !this.channel.isOpen();
    }

    public String toString() {
        return this.channel.toString();
    }

    public UUID getId() {
        return this.id;
    }
}

