/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.pubsub;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.redis.internal.netty.Client;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.AbstractSubscription;
import org.apache.geode.redis.internal.pubsub.Subscription;
import org.apache.geode.redis.internal.pubsub.Subscriptions;

class ChannelSubscription
extends AbstractSubscription {
    private byte[] channel;

    public ChannelSubscription(Client client, byte[] channel, ExecutionHandlerContext context, Subscriptions subscriptions) {
        super(client, context, subscriptions);
        if (channel == null) {
            throw new IllegalArgumentException("channel cannot be null");
        }
        this.channel = channel;
    }

    @Override
    public Subscription.Type getType() {
        return Subscription.Type.CHANNEL;
    }

    @Override
    public List<Object> createResponse(byte[] channel, byte[] message) {
        return Arrays.asList("message", channel, message);
    }

    @Override
    public boolean isEqualTo(Object channelOrPattern, Client client) {
        return this.channel != null && channelOrPattern instanceof byte[] && Arrays.equals(this.channel, (byte[])channelOrPattern) && this.getClient().equals(client);
    }

    @Override
    public boolean matches(byte[] channel) {
        return Arrays.equals(this.channel, channel);
    }

    @Override
    public byte[] getSubscriptionName() {
        return this.channel;
    }
}

