/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.SecurityConfig;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.metrics.internal.InternalDistributedSystemMetricsService;
import org.apache.geode.metrics.internal.MetricsService;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.SecurityManager;
import org.apache.logging.log4j.Logger;

public class InternalCacheBuilder {
    private static final Logger logger = LogService.getLogger();
    private static final String USE_ASYNC_EVENT_LISTENERS_PROPERTY = "gemfire.Cache.ASYNC_EVENT_LISTENERS";
    private static final boolean IS_EXISTING_OK_DEFAULT = true;
    private static final boolean IS_CLIENT_DEFAULT = false;
    private final Properties configProperties;
    private final CacheConfig cacheConfig;
    private final Supplier<InternalDistributedSystem> singletonSystemSupplier;
    private final Supplier<InternalCache> singletonCacheSupplier;
    private final InternalDistributedSystemConstructor internalDistributedSystemConstructor;
    private final InternalCacheConstructor internalCacheConstructor;
    private final MetricsService.Builder metricsSessionBuilder;
    private boolean isExistingOk = true;
    private boolean isClient = false;
    private boolean useAsyncEventListeners = Boolean.getBoolean("gemfire.Cache.ASYNC_EVENT_LISTENERS");
    private PoolFactory poolFactory;
    private TypeRegistry typeRegistry;

    public InternalCacheBuilder() {
        this(new Properties(), new CacheConfig());
    }

    public InternalCacheBuilder(Properties configProperties) {
        this(configProperties == null ? new Properties() : configProperties, new CacheConfig());
    }

    public InternalCacheBuilder(CacheConfig cacheConfig) {
        this(new Properties(), cacheConfig);
    }

    private InternalCacheBuilder(Properties configProperties, CacheConfig cacheConfig) {
        this(configProperties, cacheConfig, new InternalDistributedSystemMetricsService.Builder(), InternalDistributedSystem::getConnectedInstance, InternalDistributedSystem::connectInternal, GemFireCacheImpl::getInstance, GemFireCacheImpl::new);
    }

    @VisibleForTesting
    InternalCacheBuilder(Properties configProperties, CacheConfig cacheConfig, MetricsService.Builder metricsSessionBuilder, Supplier<InternalDistributedSystem> singletonSystemSupplier, InternalDistributedSystemConstructor internalDistributedSystemConstructor, Supplier<InternalCache> singletonCacheSupplier, InternalCacheConstructor internalCacheConstructor) {
        this.configProperties = configProperties;
        this.cacheConfig = cacheConfig;
        this.singletonSystemSupplier = singletonSystemSupplier;
        this.internalDistributedSystemConstructor = internalDistributedSystemConstructor;
        this.internalCacheConstructor = internalCacheConstructor;
        this.singletonCacheSupplier = singletonCacheSupplier;
        this.metricsSessionBuilder = metricsSessionBuilder;
        this.metricsSessionBuilder.setIsClient(this.isClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCache create() throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Class<InternalCacheBuilder> clazz = InternalCacheBuilder.class;
        synchronized (InternalCacheBuilder.class) {
            InternalDistributedSystem internalDistributedSystem = this.findInternalDistributedSystem().orElseGet(this::createInternalDistributedSystem);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.create(internalDistributedSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCache create(InternalDistributedSystem internalDistributedSystem) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Objects.requireNonNull(internalDistributedSystem, "internalDistributedSystem");
        try {
            Class<InternalCacheBuilder> clazz = InternalCacheBuilder.class;
            synchronized (InternalCacheBuilder.class) {
                Class<GemFireCacheImpl> clazz2 = GemFireCacheImpl.class;
                synchronized (GemFireCacheImpl.class) {
                    InternalCache cache = this.existingCache(internalDistributedSystem::getCache, this.singletonCacheSupplier);
                    if (cache == null) {
                        cache = this.internalCacheConstructor.construct(this.isClient, this.poolFactory, internalDistributedSystem, this.cacheConfig, this.useAsyncEventListeners, this.typeRegistry);
                        internalDistributedSystem.setCache(cache);
                        cache.initialize();
                    } else {
                        internalDistributedSystem.setCache(cache);
                    }
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return cache;
                }
            }
        }
        catch (IllegalArgumentException | CacheXmlException e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        catch (Error | RuntimeException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public InternalCacheBuilder set(String name, String value) {
        this.configProperties.setProperty(name, value);
        return this;
    }

    public InternalCacheBuilder setPdxReadSerialized(boolean readSerialized) {
        this.cacheConfig.setPdxReadSerialized(readSerialized);
        return this;
    }

    public InternalCacheBuilder setSecurityManager(SecurityManager securityManager) {
        this.cacheConfig.setSecurityManager(securityManager);
        return this;
    }

    public InternalCacheBuilder setPostProcessor(PostProcessor postProcessor) {
        this.cacheConfig.setPostProcessor(postProcessor);
        return this;
    }

    public InternalCacheBuilder setPdxSerializer(PdxSerializer serializer) {
        this.cacheConfig.setPdxSerializer(serializer);
        return this;
    }

    public InternalCacheBuilder setPdxDiskStore(String diskStoreName) {
        this.cacheConfig.setPdxDiskStore(diskStoreName);
        return this;
    }

    public InternalCacheBuilder setPdxPersistent(boolean isPersistent) {
        this.cacheConfig.setPdxPersistent(isPersistent);
        return this;
    }

    public InternalCacheBuilder setPdxIgnoreUnreadFields(boolean ignore) {
        this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
        return this;
    }

    public InternalCacheBuilder setCacheXMLDescription(String cacheXML) {
        if (cacheXML != null) {
            this.cacheConfig.setCacheXMLDescription(cacheXML);
        }
        return this;
    }

    public InternalCacheBuilder setIsExistingOk(boolean isExistingOk) {
        this.isExistingOk = isExistingOk;
        return this;
    }

    public InternalCacheBuilder setIsClient(boolean isClient) {
        this.isClient = isClient;
        this.metricsSessionBuilder.setIsClient(isClient);
        return this;
    }

    public InternalCacheBuilder setUseAsyncEventListeners(boolean useAsyncEventListeners) {
        this.useAsyncEventListeners = useAsyncEventListeners;
        return this;
    }

    public InternalCacheBuilder setPoolFactory(PoolFactory poolFactory) {
        this.poolFactory = poolFactory;
        return this;
    }

    public InternalCacheBuilder setTypeRegistry(TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
        return this;
    }

    public InternalCacheBuilder addMeterSubregistry(MeterRegistry subregistry) {
        Objects.requireNonNull(subregistry, "meter registry");
        this.metricsSessionBuilder.addPersistentMeterRegistry(subregistry);
        return this;
    }

    private Optional<InternalDistributedSystem> findInternalDistributedSystem() {
        InternalDistributedSystem internalDistributedSystem = null;
        if (this.configProperties.isEmpty() && !InternalCacheBuilder.allowMultipleSystems()) {
            internalDistributedSystem = this.singletonSystemSupplier.get();
            InternalCacheBuilder.validateUsabilityOfSecurityCallbacks(internalDistributedSystem, this.cacheConfig);
        }
        return Optional.ofNullable(internalDistributedSystem);
    }

    private InternalDistributedSystem createInternalDistributedSystem() {
        SecurityConfig securityConfig = new SecurityConfig(this.cacheConfig.getSecurityManager(), this.cacheConfig.getPostProcessor());
        return this.internalDistributedSystemConstructor.construct(this.configProperties, securityConfig, this.metricsSessionBuilder);
    }

    private InternalCache existingCache(Supplier<? extends InternalCache> systemCacheSupplier, Supplier<? extends InternalCache> singletonCacheSupplier) {
        InternalCache cache;
        InternalCache internalCache = cache = InternalCacheBuilder.allowMultipleSystems() ? systemCacheSupplier.get() : singletonCacheSupplier.get();
        if (this.validateExistingCache(cache)) {
            return cache;
        }
        return null;
    }

    private boolean validateExistingCache(InternalCache existingCache) {
        if (existingCache == null || existingCache.isClosed()) {
            return false;
        }
        if (this.isExistingOk) {
            this.cacheConfig.validateCacheConfig(existingCache);
        } else {
            existingCache.throwCacheExistsException();
        }
        return true;
    }

    private static void validateUsabilityOfSecurityCallbacks(InternalDistributedSystem internalDistributedSystem, CacheConfig cacheConfig) throws GemFireSecurityException {
        if (internalDistributedSystem == null) {
            return;
        }
        if (cacheConfig.getSecurityManager() != null) {
            throw new GemFireSecurityException("Existing DistributedSystem connection cannot use specified SecurityManager");
        }
        if (cacheConfig.getPostProcessor() != null) {
            throw new GemFireSecurityException("Existing DistributedSystem connection cannot use specified PostProcessor");
        }
    }

    private static boolean allowMultipleSystems() {
        return Boolean.getBoolean("gemfire.ALLOW_MULTIPLE_SYSTEMS");
    }

    @VisibleForTesting
    public static interface InternalDistributedSystemConstructor {
        public InternalDistributedSystem construct(Properties var1, SecurityConfig var2, MetricsService.Builder var3);
    }

    @VisibleForTesting
    public static interface InternalCacheConstructor {
        public InternalCache construct(boolean var1, PoolFactory var2, InternalDistributedSystem var3, CacheConfig var4, boolean var5, TypeRegistry var6);
    }
}

